/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public final class CondaEnvSdkFlavor
extends CPythonSdkFlavor {
    private CondaEnvSdkFlavor() {
    }

    public static CondaEnvSdkFlavor getInstance() {
        return (CondaEnvSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(CondaEnvSdkFlavor.class);
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        ArrayList<String> results = new ArrayList<String>();
        Sdk sdk = (Sdk)ReadAction.compute(() -> PythonSdkUtil.findPythonSdk(module));
        try {
            List<String> environments = PyCondaRunKt.listCondaEnvironments(sdk);
            for (String environment : environments) {
                results.addAll((Collection)ReadAction.compute(() -> VirtualEnvSdkFlavor.findInRootDirectory(StandardFileSystems.local().findFileByPath(environment))));
            }
            if (!PyCondaSdkCustomizer.Companion.getInstance().getDetectBaseEnvironment()) {
                results.removeIf(path -> PythonSdkUtil.isBaseConda(path));
            }
        }
        catch (ExecutionException e) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CondaEnvSdkFlavor.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<String> arrayList = results;
        if (arrayList == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkUtil.isConda(file.getPath());
    }

    @Nullable
    public static File getCondaEnvRoot(@NotNull String binaryPath) {
        File binary;
        File parent;
        if (binaryPath == null) {
            CondaEnvSdkFlavor.$$$reportNull$$$0(3);
        }
        if ((parent = (binary = new File(binaryPath)).getParentFile()) == null) {
            return null;
        }
        File parent2 = parent.getParentFile();
        if (parent2 == null) {
            return null;
        }
        File parent3 = parent2.getParentFile();
        if (parent3 != null && "envs".equals(parent3.getName())) {
            return parent2;
        }
        if ("envs".equals(parent2.getName())) {
            return parent;
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Anaconda;
    }

    @Nullable
    public static ValidationInfo validateCondaPath(@Nullable @SystemDependent String condaExecutable) {
        File file;
        String message = StringUtil.isEmptyOrSpaces((String)condaExecutable) ? PyBundle.message("python.add.sdk.conda.executable.path.is.empty", new Object[0]) : (!(file = new File(condaExecutable)).exists() ? PyBundle.message("python.add.sdk.conda.executable.not.found", new Object[0]) : (!file.isFile() || !file.canExecute() ? PyBundle.message("python.add.sdk.conda.executable.path.is.not.executable", new Object[0]) : null));
        return message == null ? null : new ValidationInfo(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/CondaEnvSdkFlavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/CondaEnvSdkFlavor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCondaEnvRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

