/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnixPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"jython", "pypy"};

    private UnixPythonSdkFlavor() {
    }

    public static UnixPythonSdkFlavor getInstance() {
        return (UnixPythonSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(UnixPythonSdkFlavor.class);
    }

    @Override
    public boolean isApplicable() {
        return SystemInfo.isUnix && !SystemInfo.isMac;
    }

    @Override
    @NotNull
    public Collection<String> suggestHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        return UnixPythonSdkFlavor.getDefaultUnixPythons(null);
    }

    @NotNull
    public static Set<String> getDefaultUnixPythons(@Nullable String rootPrefix) {
        HashSet<String> candidates = new HashSet<String>();
        UnixPythonSdkFlavor.collectUnixPythons((rootPrefix != null ? rootPrefix : "") + "/usr/bin", candidates);
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            UnixPythonSdkFlavor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public static void collectUnixPythons(String path, Set<? super String> candidates) {
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (rootDir != null) {
            VirtualFile[] suspects;
            if (rootDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootDir).markDirty();
            }
            rootDir.refresh(true, false);
            block0: for (VirtualFile child : suspects = rootDir.getChildren()) {
                if (child.isDirectory()) continue;
                String childName = StringUtil.toLowerCase((String)child.getName());
                for (String name : NAMES) {
                    if (!childName.startsWith(name) && !PYTHON_RE.matcher(childName).matches()) continue;
                    String childPath = child.getPath();
                    if (childName.endsWith("-config") || childName.startsWith("pythonw") || childName.endsWith("m")) continue block0;
                    candidates.add(childPath);
                    continue block0;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/flavors/UnixPythonSdkFlavor", "getDefaultUnixPythons"));
    }
}

