/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.tasks.trello.TrelloRepository;
import com.intellij.tasks.trello.model.TrelloBoard;
import com.intellij.tasks.trello.model.TrelloList;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloRepositoryEditor
extends BaseRepositoryEditor<TrelloRepository> {
    private static final Logger LOG = Logger.getInstance(TrelloRepositoryEditor.class);
    private ComboBox<TrelloBoard> myBoardComboBox;
    private ComboBox<TrelloList> myListComboBox;
    private JBLabel myListLabel;
    private JBLabel myBoardLabel;
    private JBCheckBox myAllCardsCheckBox;

    public TrelloRepositoryEditor(Project project, TrelloRepository repository, Consumer<? super TrelloRepository> changeListener) {
        super(project, repository, changeListener);
        this.myUrlLabel.setVisible(false);
        this.myURLText.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myPasswordLabel.setText(TaskBundle.message((String)"label.token", (Object[])new Object[0]));
        this.myAllCardsCheckBox.setSelected(((TrelloRepository)this.myRepository).isIncludeAllCards());
        this.myPasswordText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String password;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((password = String.valueOf(TrelloRepositoryEditor.this.myPasswordText.getPassword())).isEmpty() || password.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getPassword())) {
                    return;
                }
                ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setPassword(password);
                new BoardsComboBoxUpdater(){

                    @Override
                    @NotNull
                    protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentUser(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserByToken());
                        Object object = super.fetch(indicator);
                        if (object == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return object;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/tasks/trello/TrelloRepositoryEditor$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/tasks/trello/TrelloRepositoryEditor$1$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "fetch";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "fetch";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                }.queue();
                TrelloRepositoryEditor.this.doApply();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/tasks/trello/TrelloRepositoryEditor$1", "textChanged"));
            }
        });
        this.myBoardComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TrelloBoard board = (TrelloBoard)e.getItem();
                if (e.getStateChange() == 2 || board.equals(((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard())) {
                    return;
                }
                if (board != TrelloRepository.UNSPECIFIED_BOARD) {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(board);
                    new ListsComboBoxUpdater(){

                        @Override
                        @Nullable
                        public TrelloList getSelectedItem() {
                            return TrelloRepository.UNSPECIFIED_LIST;
                        }
                    }.queue();
                } else {
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(null);
                    TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(null);
                }
                TrelloRepositoryEditor.this.doApply();
            }
        });
        this.myBoardComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)TaskBundle.message((String)"label.set.token.first", (Object[])new Object[0]), board -> board.isClosed() ? board.getName() + TaskBundle.message((String)"label.closed", (Object[])new Object[0]) : board.getName()));
        this.myListComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TrelloList list = (TrelloList)e.getItem();
                    ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(list);
                    TrelloRepositoryEditor.this.doApply();
                }
            }
        });
        this.myListComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)TaskBundle.message((String)"label.select.board.first", (Object[])new Object[0]), list -> {
            Object text = list.getName();
            if (list.isClosed() && list.isMoved()) {
                text = (String)text + TaskBundle.message((String)"label.archived.moved", (Object[])new Object[0]);
            } else if (list.isMoved()) {
                text = (String)text + TaskBundle.message((String)"label.moved", (Object[])new Object[0]);
            } else if (list.isClosed()) {
                text = (String)text + TaskBundle.message((String)"label.archived", (Object[])new Object[0]);
            }
            return text;
        }));
        this.installListener((JCheckBox)this.myAllCardsCheckBox);
        UIUtil.invokeLaterIfNeeded(() -> this.initialize());
    }

    private void initialize() {
        if (((TrelloRepository)this.myRepository).getCurrentUser() != null) {
            new BoardsComboBoxUpdater(){

                @Override
                @NotNull
                protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Object boards = super.fetch(indicator);
                    TrelloBoard currentBoard = this.getSelectedItem();
                    if (currentBoard != null && currentBoard != TrelloRepository.UNSPECIFIED_BOARD) {
                        int i = boards.indexOf(currentBoard);
                        currentBoard = i >= 0 ? (TrelloBoard)boards.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardById(currentBoard.getId());
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentBoard(currentBoard);
                    }
                    Object object = boards;
                    if (object == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return object;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/tasks/trello/TrelloRepositoryEditor$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/tasks/trello/TrelloRepositoryEditor$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fetch";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "fetch";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.queue();
        }
        if (((TrelloRepository)this.myRepository).getCurrentBoard() != null && ((TrelloRepository)this.myRepository).getCurrentBoard() != TrelloRepository.UNSPECIFIED_BOARD) {
            new ListsComboBoxUpdater(){

                @Override
                @NotNull
                protected List<TrelloList> fetch(@NotNull ProgressIndicator indicator) throws Exception {
                    if (indicator == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    Object lists = super.fetch(indicator);
                    TrelloList currentList = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentList();
                    if (currentList != null && currentList != TrelloRepository.UNSPECIFIED_LIST) {
                        int i = lists.indexOf(currentList);
                        currentList = i >= 0 ? (TrelloList)lists.get(i) : ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchListById(currentList.getId());
                        TrelloBoard currentBoard = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard();
                        if (currentBoard != null && !currentList.getIdBoard().equals(currentBoard.getId())) {
                            currentList.setMoved(true);
                        }
                        ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).setCurrentList(currentList);
                    }
                    Object object = lists;
                    if (object == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return object;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/tasks/trello/TrelloRepositoryEditor$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/tasks/trello/TrelloRepositoryEditor$5";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fetch";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "fetch";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }.queue();
        }
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.myBoardComboBox = new ComboBox(300);
        this.myBoardLabel = new JBLabel(TaskBundle.message((String)"label.board", (Object[])new Object[0]), 4);
        this.myBoardLabel.setLabelFor(this.myBoardComboBox);
        this.myListComboBox = new ComboBox(300);
        this.myListLabel = new JBLabel(TaskBundle.message((String)"label.list", (Object[])new Object[0]), 4);
        this.myListLabel.setLabelFor(this.myListComboBox);
        this.myAllCardsCheckBox = new JBCheckBox(TaskBundle.message((String)"checkbox.include.cards.not.assigned.to.me", (Object[])new Object[0]));
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myBoardLabel, this.myBoardComboBox).addLabeledComponent((JComponent)this.myListLabel, this.myListComboBox).addComponentToRightColumn((JComponent)this.myAllCardsCheckBox).getPanel();
    }

    @Override
    public void apply() {
        super.apply();
        ((TrelloRepository)this.myRepository).setIncludeAllCards(this.myAllCardsCheckBox.isSelected());
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myListLabel.setAnchor(anchor);
        this.myBoardLabel.setAnchor(anchor);
    }

    private class ListsComboBoxUpdater
    extends TaskUiUtil.ComboBoxUpdater<TrelloList> {
        ListsComboBoxUpdater() {
            super(TrelloRepositoryEditor.this.myProject, TaskBundle.message((String)"progress.title.downloading.trello.lists", (Object[])new Object[0]), TrelloRepositoryEditor.this.myListComboBox);
        }

        @Override
        @NotNull
        protected List<TrelloList> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                ListsComboBoxUpdater.$$$reportNull$$$0(0);
            }
            List<TrelloList> list = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchBoardLists();
            if (list == null) {
                ListsComboBoxUpdater.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        public TrelloList getExtraItem() {
            return TrelloRepository.UNSPECIFIED_LIST;
        }

        @Override
        @Nullable
        public TrelloList getSelectedItem() {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentList();
        }

        @Override
        protected boolean addSelectedItemIfMissing() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/trello/TrelloRepositoryEditor$ListsComboBoxUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/trello/TrelloRepositoryEditor$ListsComboBoxUpdater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class BoardsComboBoxUpdater
    extends TaskUiUtil.ComboBoxUpdater<TrelloBoard> {
        BoardsComboBoxUpdater() {
            super(TrelloRepositoryEditor.this.myProject, TaskBundle.message((String)"progress.title.downloading.trello.boards", (Object[])new Object[0]), TrelloRepositoryEditor.this.myBoardComboBox);
        }

        @Override
        @NotNull
        protected List<TrelloBoard> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            if (indicator == null) {
                BoardsComboBoxUpdater.$$$reportNull$$$0(0);
            }
            List<TrelloBoard> list = ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).fetchUserBoards();
            if (list == null) {
                BoardsComboBoxUpdater.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        public TrelloBoard getExtraItem() {
            return TrelloRepository.UNSPECIFIED_BOARD;
        }

        @Override
        @Nullable
        public TrelloBoard getSelectedItem() {
            return ((TrelloRepository)TrelloRepositoryEditor.this.myRepository).getCurrentBoard();
        }

        @Override
        protected void handleError() {
            super.handleError();
            TrelloRepositoryEditor.this.myListComboBox.removeAllItems();
        }

        @Override
        protected boolean addSelectedItemIfMissing() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/tasks/trello/TrelloRepositoryEditor$BoardsComboBoxUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/tasks/trello/TrelloRepositoryEditor$BoardsComboBoxUpdater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fetch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fetch";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

