/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import git4idea.index.LightFileStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001aB\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014\u001a\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0000\u001aJ\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0014\u001a\u0014\u0010\u001d\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a \u0010\u001e\u001a\u00020\u00142\n\u0010\u001f\u001a\u00060\u0019j\u0002`\u001a2\n\u0010 \u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0014\u0010!\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0014\u0010\"\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a \u0010#\u001a\u00020\u00142\n\u0010\u001f\u001a\u00060\u0019j\u0002`\u001a2\n\u0010 \u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0012\u0010%\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a\u001a\u0014\u0010&\u001a\u00020\u00142\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001aH\u0000\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a:\u0010)\u001a\u00020*2\b\b\u0001\u0010+\u001a\u00020\u00012\b\b\u0001\u0010(\u001a\u00020\u00012\b\b\u0001\u0010,\u001a\u00020\u00012\b\b\u0001\u0010-\u001a\u00020\u00192\b\b\u0001\u0010.\u001a\u00020\u0019H\u0002\u001a2\u0010/\u001a\u00020**\u0002002\u0006\u00101\u001a\u0002022\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0014H\u0002\u001a\n\u00103\u001a\u00020\u0014*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005*\n\u00104\"\u00020\u00192\u00020\u0019\u00a8\u00065"}, d2={"NUL", "", "repositoryPath", "Lgit4idea/index/LightFileStatus;", "getRepositoryPath", "(Lgit4idea/index/LightFileStatus;)Ljava/lang/String;", "getFilePath", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "executable", "Lgit4idea/config/GitExecutable;", "getFileStatus", "", "Lgit4idea/index/LightFileStatus$StatusRecord;", "project", "Lcom/intellij/openapi/project/Project;", "files", "withRenames", "", "withUntracked", "withIgnored", "Lcom/intellij/openapi/vcs/FileStatus;", "status", "", "Lgit4idea/index/StatusCode;", "getStatus", "Lgit4idea/index/GitFileStatus;", "isAdded", "isConflicted", "index", "workTree", "isDeleted", "isIgnored", "isIntendedToBeAdded", "isKnownStatus", "isRenamed", "isUntracked", "parseGitStatusOutput", "output", "throwGFE", "", "message", "line", "xStatus", "yStatus", "appendParameters", "Lgit4idea/commands/GitLineHandler;", "gitVersion", "Lgit4idea/config/GitVersion;", "isTracked", "StatusCode", "intellij.vcs.git"})
public final class GitIndexStatusUtilKt {
    @NotNull
    public static final String NUL = "\u0000";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GitFileStatus> getStatus(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean withRenames, boolean withUntracked, boolean withIgnored) throws VcsException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = GitIndexStatusUtilKt.getFileStatus(project, root, files, withRenames, withUntracked, withIgnored);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GitFileStatus gitFileStatus = new GitFileStatus(root, (LightFileStatus.StatusRecord)it);
            collection.add(gitFileStatus);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getStatus$default(Project project, VirtualFile virtualFile, List list2, boolean bl, boolean bl2, boolean bl3, int n, Object object) throws VcsException {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        return GitIndexStatusUtilKt.getStatus(project, virtualFile, list2, bl, bl2, bl3);
    }

    @NotNull
    public static final List<LightFileStatus.StatusRecord> getFileStatus(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean withRenames, boolean withUntracked, boolean withIgnored) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Object t = GitUtil.createHandlerWithPaths((Collection<? extends FilePath>)files, (Computable)new Computable(project, root, withRenames, withUntracked, withIgnored){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ boolean $withRenames;
            final /* synthetic */ boolean $withUntracked;
            final /* synthetic */ boolean $withIgnored;

            /*
             * WARNING - void declaration
             */
            public final GitLineHandler compute() {
                void var1_1;
                GitLineHandler h2 = new GitLineHandler(this.$project, this.$root, GitCommand.STATUS);
                h2.setSilent(true);
                GitVersion gitVersion = GitExecutableManager.getInstance().tryGetVersion(this.$project);
                if (gitVersion == null) {
                    gitVersion = GitVersion.NULL;
                }
                Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"GitExecutableManager.get\u2026oject) ?: GitVersion.NULL");
                GitIndexStatusUtilKt.access$appendParameters(h2, gitVersion, this.$withRenames, this.$withUntracked, this.$withIgnored);
                return var1_1;
            }
            {
                this.$project = project;
                this.$root = virtualFile;
                this.$withRenames = bl;
                this.$withUntracked = bl2;
                this.$withIgnored = bl3;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"GitUtil.createHandlerWit\u2026 = withIgnored)\n    h\n  }");
        GitLineHandler h2 = (GitLineHandler)t;
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String output2 = string;
        return GitIndexStatusUtilKt.parseGitStatusOutput(output2);
    }

    @NotNull
    public static final LightFileStatus getFileStatus(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        GitLineHandler h2 = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.STATUS, CollectionsKt.emptyList());
        h2.setSilent(true);
        GitVersion gitVersion = GitExecutableManager.getInstance().getVersion(executable);
        Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"GitExecutableManager.get\u2026().getVersion(executable)");
        GitIndexStatusUtilKt.appendParameters(h2, gitVersion, false, true, true);
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String output2 = string;
        CharSequence charSequence = output2;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            List<LightFileStatus.StatusRecord> gitStatusOutput = GitIndexStatusUtilKt.parseGitStatusOutput(output2);
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)CollectionsKt.firstOrNull(gitStatusOutput);
            return statusRecord != null ? (LightFileStatus)statusRecord : (LightFileStatus)LightFileStatus.Blank.INSTANCE;
        }
        String string2 = GitIndexStatusUtilKt.getFilePath(root, filePath, executable);
        if (string2 == null) {
            return LightFileStatus.Blank.INSTANCE;
        }
        String repositoryPath = string2;
        return new LightFileStatus.NotChanged(repositoryPath);
    }

    private static final void appendParameters(GitLineHandler $this$appendParameters, GitVersion gitVersion, boolean withRenames, boolean withUntracked, boolean withIgnored) {
        $this$appendParameters.addParameters("--porcelain", "-z");
        if (!withRenames && GitVersionSpecialty.STATUS_SUPPORTS_NO_RENAMES.existsIn(gitVersion)) {
            $this$appendParameters.addParameters("--no-renames");
        }
        $this$appendParameters.addParameters("--untracked-files=" + (withUntracked ? "all" : "no"));
        if (GitVersionSpecialty.STATUS_SUPPORTS_IGNORED_MODES.existsIn(gitVersion)) {
            if (withIgnored) {
                $this$appendParameters.addParameters("--ignored=matching");
            } else {
                $this$appendParameters.addParameters("--ignored=no");
            }
        } else if (withIgnored) {
            $this$appendParameters.addParameters("--ignored");
        }
    }

    static /* synthetic */ void appendParameters$default(GitLineHandler gitLineHandler, GitVersion gitVersion, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        GitIndexStatusUtilKt.appendParameters(gitLineHandler, gitVersion, bl, bl2, bl3);
    }

    @Nullable
    public static final String getFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.LS_FILES, CollectionsKt.emptyList());
        handler.addParameters("--full-name");
        handler.addRelativePaths(filePath);
        handler.setSilent(true);
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCom\u2026ndler).getOutputOrThrow()");
        return (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string));
    }

    private static final List<LightFileStatus.StatusRecord> parseGitStatusOutput(String output2) throws VcsException {
        boolean bl = false;
        List result2 = new ArrayList();
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)output2, (String[])new String[]{NUL}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] split = objectArray;
        Iterator it = ArrayIteratorKt.iterator((Object[])split);
        while (it.hasNext()) {
            String pathPart;
            String line = (String)it.next();
            if (StringUtil.isEmptyOrSpaces((String)line) || StringsKt.startsWith$default((String)line, (String)"starting fsmonitor-daemon in ", (boolean)false, (int)2, null)) continue;
            if (line.length() < 4 || line.charAt(2) != ' ') {
                String string = GitBundle.message("status.exception.message.line.is.too.short", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"statu\u2026ssage.line.is.too.short\")");
                GitIndexStatusUtilKt.throwGFE(string, output2, line, '0', '0');
            }
            char xStatus = line.charAt(0);
            char yStatus = line.charAt(1);
            if (!GitIndexStatusUtilKt.isKnownStatus(xStatus) || !GitIndexStatusUtilKt.isKnownStatus(yStatus)) {
                String string = GitBundle.message("status.exception.message.unexpected", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"statu\u2026tion.message.unexpected\")");
                GitIndexStatusUtilKt.throwGFE(string, output2, line, xStatus, yStatus);
            }
            String string = line;
            int n = 3;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            if (GitIndexStatusUtilKt.isRenamed(xStatus) || GitIndexStatusUtilKt.isRenamed(yStatus)) {
                if (!it.hasNext()) {
                    String string3 = GitBundle.message("status.exception.message.missing.path", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"statu\u2026on.message.missing.path\")");
                    GitIndexStatusUtilKt.throwGFE(string3, output2, line, xStatus, yStatus);
                    continue;
                }
                String origPath = (String)it.next();
                result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, origPath));
                continue;
            }
            result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, null, 8, null));
        }
        return result2;
    }

    private static final void throwGFE(@Nls String message, @NlsSafe String output2, @NlsSafe String line, @NlsSafe char xStatus, @NlsSafe char yStatus) {
        throw (Throwable)new VcsException(GitBundle.message("status.exception.message.format.message.xstatus.ystatus.line.output", message, Character.valueOf(xStatus), Character.valueOf(yStatus), line, output2));
    }

    private static final boolean isKnownStatus(char status) {
        return status == ' ' || status == 'M' || status == 'A' || status == 'D' || status == 'C' || status == 'R' || status == 'U' || status == 'T' || status == '!' || status == '?';
    }

    @Nullable
    public static final FileStatus getFileStatus(char status) throws VcsException {
        FileStatus fileStatus;
        switch (status) {
            case ' ': {
                fileStatus = null;
                break;
            }
            case 'C': 
            case 'M': 
            case 'R': 
            case 'T': {
                fileStatus = FileStatus.MODIFIED;
                break;
            }
            case 'A': {
                fileStatus = FileStatus.ADDED;
                break;
            }
            case 'D': {
                fileStatus = FileStatus.DELETED;
                break;
            }
            case 'U': {
                fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
                break;
            }
            case '!': {
                fileStatus = FileStatus.IGNORED;
                break;
            }
            case '?': {
                fileStatus = FileStatus.UNKNOWN;
                break;
            }
            default: {
                throw (Throwable)new VcsException(GitBundle.message("status.exception.message.unexpected.status", Character.valueOf(status)));
            }
        }
        return fileStatus;
    }

    public static final boolean isIgnored(char status) {
        return status == '!';
    }

    public static final boolean isUntracked(char status) {
        return status == '?';
    }

    public static final boolean isRenamed(char status) {
        return status == 'R' || status == 'C';
    }

    public static final boolean isAdded(char status) {
        return status == 'A';
    }

    public static final boolean isIntendedToBeAdded(char index, char workTree) {
        return index == ' ' && workTree == 'A';
    }

    public static final boolean isDeleted(char status) {
        return status == 'D';
    }

    public static final boolean isConflicted(char index, char workTree) {
        return index == 'D' && workTree == 'D' || index == 'A' && workTree == 'A' || index == 'T' && workTree == 'T' || index == 'U' || workTree == 'U';
    }

    public static final boolean isTracked(@NotNull LightFileStatus $this$isTracked) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isTracked, (String)"$this$isTracked");
        LightFileStatus lightFileStatus = $this$isTracked;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            bl = false;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            bl = true;
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            bl = !GitIndexStatusUtilKt.isIgnored(((LightFileStatus.StatusRecord)$this$isTracked).getIndex()) && !GitIndexStatusUtilKt.isUntracked(((LightFileStatus.StatusRecord)$this$isTracked).getIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull LightFileStatus $this$repositoryPath) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$repositoryPath, (String)"$this$repositoryPath");
        LightFileStatus lightFileStatus = $this$repositoryPath;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            string = null;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            string = ((LightFileStatus.NotChanged)$this$repositoryPath).getPath();
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            if (!GitIndexStatusUtilKt.isTracked($this$repositoryPath) || ((LightFileStatus.StatusRecord)$this$repositoryPath).getIndex() == 'A' || ((LightFileStatus.StatusRecord)$this$repositoryPath).getWorkTree() == 'A') {
                string = null;
            } else {
                string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getOrigPath();
                if (string == null) {
                    string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getPath();
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ void access$appendParameters(GitLineHandler $this$access_u24appendParameters, GitVersion gitVersion, boolean withRenames, boolean withUntracked, boolean withIgnored) {
        GitIndexStatusUtilKt.appendParameters($this$access_u24appendParameters, gitVersion, withRenames, withUntracked, withIgnored);
    }
}

