/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log.drop;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitCommitEditingNotificationsKt;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.rebase.log.GitLogCommitDetailsLoaderKt;
import git4idea.rebase.log.GitMultipleCommitEditingAction;
import git4idea.rebase.log.drop.GitDropOperation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Lgit4idea/rebase/log/drop/GitDropLogAction;", "Lgit4idea/rebase/log/GitMultipleCommitEditingAction;", "()V", "actionPerformedAfterChecks", "", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "getFailureTitle", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.vcs.git"})
public final class GitDropLogAction
extends GitMultipleCommitEditingAction {
    @Override
    protected void update(@NotNull AnActionEvent e, @NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setText(GitBundle.message("rebase.log.drop.action.custom.text", commitEditingData.getSelectedCommitList().size()));
    }

    @Override
    protected void actionPerformedAfterChecks(@NotNull GitCommitEditingActionBase.MultipleCommitEditingData commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
        Project project = commitEditingData.getProject();
        List<VcsCommitMetadata> commitDetails = GitLogCommitDetailsLoaderKt.getOrLoadDetails(project, commitEditingData.getLogData(), commitEditingData.getSelectedCommitList());
        new Task.Backgroundable(commitEditingData, commitDetails, project, project, GitBundle.message("rebase.log.drop.progress.indicator.title", commitDetails.size())){
            final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData $commitEditingData;
            final /* synthetic */ List $commitDetails;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult operationResult = new GitDropOperation(this.$commitEditingData.getRepository()).execute(this.$commitDetails);
                if (operationResult instanceof GitCommitEditingOperationResult.Complete) {
                    GitCommitEditingOperationResult.Complete complete = (GitCommitEditingOperationResult.Complete)operationResult;
                    String string = GitBundle.message("rebase.log.drop.success.notification.title", this.$commitDetails.size());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026tle\", commitDetails.size)");
                    String string2 = GitBundle.message("rebase.log.drop.undo.progress.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"rebas\u2026rop.undo.progress.title\")");
                    String string3 = GitBundle.message("rebase.log.drop.undo.impossible.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GitBundle.message(\"rebas\u2026p.undo.impossible.title\")");
                    String string4 = GitBundle.message("rebase.log.drop.undo.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"GitBundle.message(\"rebas\u2026.drop.undo.failed.title\")");
                    GitCommitEditingNotificationsKt.notifySuccess(complete, string, string2, string3, string4);
                }
            }
            {
                this.$commitEditingData = $captured_local_variable$0;
                this.$commitDetails = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        String string = GitBundle.message("rebase.log.drop.action.failure.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026op.action.failure.title\")");
        return string;
    }
}

