/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GitRefNameValidator
implements InputValidator {
    private static final GitRefNameValidator INSTANCE = new GitRefNameValidator();
    private static final String CONTROL_CHARS;
    private static final Pattern ILLEGALCHARS;
    private static final Pattern ILLEGAL;

    public static GitRefNameValidator getInstance() {
        return INSTANCE;
    }

    private GitRefNameValidator() {
    }

    public boolean checkInput(String inputString) {
        return !StringUtil.isEmptyOrSpaces((String)inputString) && !ILLEGAL.matcher(inputString).find();
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String branchName) {
        if (branchName == null) {
            GitRefNameValidator.$$$reportNull$$$0(0);
        }
        String string = this.deduplicateChars(branchName.replaceAll(ILLEGAL.pattern(), "_").replaceAll("\"", ""));
        if (string == null) {
            GitRefNameValidator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String cleanUpBranchNameOnTyping(@NotNull String branchName) {
        if (branchName == null) {
            GitRefNameValidator.$$$reportNull$$$0(2);
        }
        String string = branchName.replaceAll(ILLEGALCHARS.pattern(), "_");
        if (string == null) {
            GitRefNameValidator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String deduplicateChars(@NotNull String branchName) {
        if (branchName == null) {
            GitRefNameValidator.$$$reportNull$$$0(4);
        }
        String string = branchName.replaceAll("(/){2,}", "/").replaceAll("(_){2,}", "_");
        if (string == null) {
            GitRefNameValidator.$$$reportNull$$$0(5);
        }
        return string;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        sb.append('\u007f');
        sb.append("]");
        CONTROL_CHARS = sb.toString();
        ILLEGALCHARS = Pattern.compile("(^\\.)|(^-)|(^/)|(\\.\\.)+|[ ~:^?*\\[\\\\]+|(@\\{)+|" + CONTROL_CHARS);
        ILLEGAL = Pattern.compile("(([./]|\\.lock)$)|\\.(?=/)|(?<=/)\\.|" + ILLEGALCHARS.pattern());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/validators/GitRefNameValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/validators/GitRefNameValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchNameOnTyping";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchNameOnTyping";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

