/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.TemplateParameterTraversalPolicy;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NextPrevParameterHandler
extends EditorWriteActionHandler.ForEachCaret {
    private static final LanguageExtension<TemplateParameterTraversalPolicy> EP = new LanguageExtension("com.intellij.templateParameterTraversalPolicy");
    protected final EditorActionHandler originalHandler;
    protected final boolean next;

    public NextPrevParameterHandler(EditorActionHandler originalHandler, boolean next) {
        this.originalHandler = originalHandler;
        this.next = next;
    }

    public static boolean hasSuitablePolicy(Editor editor, PsiFile file) {
        return NextPrevParameterHandler.findSuitableTraversalPolicy(editor, file) != null;
    }

    public static boolean isEnabledForContext(DataContext context, Boolean next) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return false;
        }
        return NextPrevParameterHandler.handleTab(editor, context, false, next);
    }

    public static boolean hasSuitablePolicy(PsiFile file) {
        return NextPrevParameterHandler.findPolicyForFile(file) != null;
    }

    @Nullable
    static TemplateParameterTraversalPolicy findSuitableTraversalPolicy(Editor editor, PsiFile file) {
        TemplateParameterTraversalPolicy policy = NextPrevParameterHandler.findPolicyForFile(file);
        return policy != null && policy.isValidForFile(editor, file) ? policy : null;
    }

    private static TemplateParameterTraversalPolicy findPolicyForFile(PsiFile file) {
        return EP.forLanguage(file.getLanguage());
    }

    @Override
    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            NextPrevParameterHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            NextPrevParameterHandler.$$$reportNull$$$0(1);
        }
        if (this.originalHandler == null) {
            return false;
        }
        return this.originalHandler.isEnabled(editor, caret, dataContext);
    }

    @Override
    public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            NextPrevParameterHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            NextPrevParameterHandler.$$$reportNull$$$0(3);
        }
        if (!NextPrevParameterHandler.handleTab(editor, dataContext, true, this.next)) {
            this.originalHandler.execute(editor, caret, dataContext);
        }
    }

    private static boolean handleTab(@NotNull Editor editor, DataContext dataContext, boolean invoke, boolean next) {
        Shortcut[] shortcuts;
        if (editor == null) {
            NextPrevParameterHandler.$$$reportNull$$$0(4);
        }
        if (editor.getCaretModel().getCaretCount() > 1) {
            return false;
        }
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager != null && ClientId.isCurrentlyUnderLocalId() && (shortcuts = keymapManager.getActiveKeymap().getShortcuts(next ? "NextTemplateParameter" : "PrevTemplateParameter")).length > 0) {
            return false;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        PsiFile psiFile = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE);
        if (project == null || psiFile == null) {
            return false;
        }
        TemplateParameterTraversalPolicy policy = NextPrevParameterHandler.findSuitableTraversalPolicy(editor, psiFile);
        if (policy != null) {
            if (invoke) {
                policy.invoke(editor, psiFile, next);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/NextPrevParameterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWriteAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

