/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import org.jetbrains.annotations.NotNull;

public abstract class DfaValue {
    private final int myID;
    @NotNull
    protected final DfaValueFactory myFactory;

    protected DfaValue(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            DfaValue.$$$reportNull$$$0(0);
        }
        this.myFactory = factory;
        this.myID = factory.registerValue(this);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaValue.$$$reportNull$$$0(1);
        }
        return dfaValueFactory;
    }

    public abstract DfaValue bindToFactory(@NotNull DfaValueFactory var1);

    public int getID() {
        return this.myID;
    }

    @NotNull
    public DfType getDfType() {
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            DfaValue.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    public DfaValue unite(DfaValue other) {
        if (this == other) {
            return this;
        }
        return this.myFactory.fromDfType(this.getDfType().join(other.getDfType()));
    }

    public final DfaCondition eq(DfaValue other) {
        return this.cond(RelationType.EQ, other);
    }

    public final DfaCondition eq(DfType other) {
        return this.cond(RelationType.EQ, this.myFactory.fromDfType(other));
    }

    @NotNull
    public final DfaCondition cond(@NotNull RelationType relationType, @NotNull DfaValue other) {
        if (relationType == null) {
            DfaValue.$$$reportNull$$$0(3);
        }
        if (other == null) {
            DfaValue.$$$reportNull$$$0(4);
        }
        DfaCondition dfaCondition = DfaCondition.createCondition(this, relationType, other);
        if (dfaCondition == null) {
            DfaValue.$$$reportNull$$$0(5);
        }
        return dfaCondition;
    }

    @NotNull
    public DfaCondition cond(@NotNull RelationType relationType, @NotNull DfType other) {
        DfaCondition.Exact result;
        if (relationType == null) {
            DfaValue.$$$reportNull$$$0(6);
        }
        if (other == null) {
            DfaValue.$$$reportNull$$$0(7);
        }
        if ((result = DfaCondition.tryEvaluate(this.getDfType(), relationType, other)) != null) {
            DfaCondition.Exact exact = result;
            if (exact == null) {
                DfaValue.$$$reportNull$$$0(8);
            }
            return exact;
        }
        DfaCondition dfaCondition = DfaCondition.createCondition(this, relationType, this.myFactory.fromDfType(other));
        if (dfaCondition == null) {
            DfaValue.$$$reportNull$$$0(9);
        }
        return dfaCondition;
    }

    public boolean dependsOn(DfaVariableValue other) {
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof DfaValue && this.getID() == ((DfaValue)obj).getID();
    }

    public int hashCode() {
        return this.getID();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaValue";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "cond";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cond";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

