/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.CharsetConverter;
import com.intellij.execution.configurations.PathConverter;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="log_file")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B9\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nBC\b\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0007R+\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R+\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R+\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R+\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00078G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R/\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u0014\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R/\u0010%\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0014\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#\u00a8\u0006/"}, d2={"Lcom/intellij/execution/configurations/LogFileOptions;", "Lcom/intellij/openapi/components/BaseState;", "()V", "name", "", "path", "enabled", "", "skipContent", "showAll", "(Ljava/lang/String;Ljava/lang/String;ZZZ)V", "charset", "Ljava/nio/charset/Charset;", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/charset/Charset;ZZZ)V", "<set-?>", "getCharset", "()Ljava/nio/charset/Charset;", "setCharset", "(Ljava/nio/charset/Charset;)V", "charset$delegate", "Lkotlin/properties/ReadWriteProperty;", "isEnabled", "()Z", "setEnabled", "(Z)V", "isEnabled$delegate", "isShowAll", "setShowAll", "isShowAll$delegate", "isSkipContent", "setSkipContent", "isSkipContent$delegate", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "name$delegate", "pathPattern", "getPathPattern", "setPathPattern", "pathPattern$delegate", "getPaths", "", "setLast", "", "last", "Companion", "intellij.platform.lang"})
public final class LogFileOptions
extends BaseState {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private final ReadWriteProperty name$delegate;
    @Nullable
    private final ReadWriteProperty pathPattern$delegate;
    @NotNull
    private final ReadWriteProperty isEnabled$delegate;
    @NotNull
    private final ReadWriteProperty isSkipContent$delegate;
    @NotNull
    private final ReadWriteProperty isShowAll$delegate;
    @NotNull
    private final ReadWriteProperty charset$delegate;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "name", "getName()Ljava/lang/String;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "pathPattern", "getPathPattern()Ljava/lang/String;", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "isEnabled", "isEnabled()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "isSkipContent", "isSkipContent()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "isShowAll", "isShowAll()Z", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(LogFileOptions.class, "charset", "getCharset()Ljava/nio/charset/Charset;", 0))};
        Companion = new Companion(null);
    }

    @Attribute(value="alias")
    @NlsSafe
    @Nullable
    public final String getName() {
        return (String)this.name$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setName(@Nullable String string) {
        this.name$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @Attribute(value="path", converter=PathConverter.class)
    @NlsSafe
    @Nullable
    public final String getPathPattern() {
        return (String)this.pathPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setPathPattern(@Nullable String string) {
        this.pathPattern$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    @Attribute(value="checked")
    public final boolean isEnabled() {
        return (Boolean)this.isEnabled$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    @Attribute(value="skipped")
    public final boolean isSkipContent() {
        return (Boolean)this.isSkipContent$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setSkipContent(boolean bl) {
        this.isSkipContent$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)bl);
    }

    @Attribute(value="show_all")
    public final boolean isShowAll() {
        return (Boolean)this.isShowAll$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final void setShowAll(boolean bl) {
        this.isShowAll$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)bl);
    }

    @Attribute(value="charset", converter=CharsetConverter.class)
    @NotNull
    public final Charset getCharset() {
        return (Charset)this.charset$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    public final void setCharset(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.charset$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getPaths() {
        String string = this.getPathPattern();
        Intrinsics.checkNotNull((Object)string);
        File logFile = new File(string);
        if (logFile.exists()) {
            String string2 = this.getPathPattern();
            Intrinsics.checkNotNull((Object)string2);
            return SetsKt.setOf((Object)string2);
        }
        String string3 = this.getPathPattern();
        Intrinsics.checkNotNull((Object)string3);
        CharSequence charSequence = string3;
        String string4 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"File.separator");
        int dirIndex = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
        if (dirIndex == -1) {
            return SetsKt.emptySet();
        }
        SmartList files = new SmartList();
        String string5 = this.getPathPattern();
        Intrinsics.checkNotNull((Object)string5);
        String string6 = string5;
        int n = 0;
        boolean bl = false;
        String string7 = string6;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n, dirIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        File file = new File(string8);
        String string9 = this.getPathPattern();
        Intrinsics.checkNotNull((Object)string9);
        string6 = string9;
        n = dirIndex + File.separator.length();
        bl = false;
        String string10 = string6;
        if (string10 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string11 = string10.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.String).substring(startIndex)");
        Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)string11));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(FileUtil\u2026 File.separator.length)))");
        Companion.collectMatchedFiles(file, pattern, (List)files);
        if (files.isEmpty()) {
            return SetsKt.emptySet();
        }
        if (this.isShowAll()) {
            HashSet result = new HashSet(files.size());
            Iterable $this$mapTo$iv = (Iterable)files;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File file2 = (File)item$iv;
                Collection collection = result;
                boolean bl2 = false;
                void v13 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"it");
                String string12 = v13.getPath();
                collection.add(string12);
            }
            return result;
        }
        File lastFile = null;
        for (File file3 : files) {
            if (lastFile != null) {
                if (file3.lastModified() <= lastFile.lastModified()) continue;
                lastFile = file3;
                continue;
            }
            lastFile = file3;
        }
        n = lastFile != null ? 1 : 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl5 = false;
            String string13 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string13));
        }
        File file4 = lastFile;
        Intrinsics.checkNotNull((Object)file4);
        return SetsKt.setOf((Object)file4.getPath());
    }

    public final void setLast(boolean last) {
        this.setShowAll(!last);
    }

    public LogFileOptions() {
        this.name$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        this.pathPattern$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        this.isEnabled$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
        this.isSkipContent$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[3]);
        this.isShowAll$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[4]);
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        this.charset$delegate = this.property(charset).provideDelegate((Object)this, $$delegatedProperties[5]);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, boolean enabled, boolean skipContent, boolean showAll) {
        this(name, path2, null, enabled, skipContent, showAll);
    }

    public /* synthetic */ LogFileOptions(String string, String string2, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(string, string2, bl, bl2, bl3);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, boolean enabled, boolean skipContent) {
        this(name, path2, enabled, skipContent, false, 16, null);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, boolean enabled) {
        this(name, path2, enabled, false, false, 24, null);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2) {
        this(name, path2, false, false, false, 28, null);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, @Nullable Charset charset, boolean enabled, boolean skipContent, boolean showAll) {
        this.name$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        this.pathPattern$delegate = BaseState.string$default(this, null, 1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        this.isEnabled$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[2]);
        this.isSkipContent$delegate = this.property(true).provideDelegate((Object)this, $$delegatedProperties[3]);
        this.isShowAll$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[4]);
        Charset charset2 = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"Charset.defaultCharset()");
        this.charset$delegate = this.property(charset2).provideDelegate((Object)this, $$delegatedProperties[5]);
        this.setName(name);
        this.setPathPattern(path2);
        this.setEnabled(enabled);
        this.setSkipContent(skipContent);
        this.setShowAll(showAll);
        Charset charset3 = charset;
        if (charset3 == null) {
            Charset charset4 = Charset.defaultCharset();
            charset3 = charset4;
            Intrinsics.checkNotNullExpressionValue((Object)charset4, (String)"Charset.defaultCharset()");
        }
        this.setCharset(charset3);
    }

    public /* synthetic */ LogFileOptions(String string, String string2, Charset charset, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        this(string, string2, charset, bl, bl2, bl3);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, @Nullable Charset charset, boolean enabled, boolean skipContent) {
        this(name, path2, charset, enabled, skipContent, false, 32, null);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, @Nullable Charset charset, boolean enabled) {
        this(name, path2, charset, enabled, false, false, 48, null);
    }

    @JvmOverloads
    public LogFileOptions(@Nullable String name, @Nullable String path2, @Nullable Charset charset) {
        this(name, path2, charset, false, false, false, 56, null);
    }

    @JvmStatic
    public static final void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
        Companion.collectMatchedFiles(root, pattern, files);
    }

    @JvmStatic
    public static final boolean areEqual(@Nullable LogFileOptions options1, @Nullable LogFileOptions options2) {
        return Companion.areEqual(options1, options2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/configurations/LogFileOptions$Companion;", "", "()V", "areEqual", "", "options1", "Lcom/intellij/execution/configurations/LogFileOptions;", "options2", "collectMatchedFiles", "", "root", "Ljava/io/File;", "pattern", "Ljava/util/regex/Pattern;", "files", "", "intellij.platform.lang"})
    public static final class Companion {
        @JvmStatic
        public final void collectMatchedFiles(@NotNull File root, @NotNull Pattern pattern, @NotNull List<File> files) {
            File[] dirs;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            File[] fileArray = root.listFiles();
            if (fileArray == null) {
                return;
            }
            File[] $this$filterTo$iv = dirs = fileArray;
            boolean $i$f$filterTo = false;
            File[] fileArray2 = $this$filterTo$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (!(pattern.matcher(file.getName()).matches() && it.isFile())) continue;
                ((Collection)files).add(element$iv);
            }
        }

        @JvmStatic
        public final boolean areEqual(@Nullable LogFileOptions options1, @Nullable LogFileOptions options2) {
            return options1 == null || options2 == null ? options1 == options2 : Intrinsics.areEqual((Object)options1.getName(), (Object)options2.getName()) && Intrinsics.areEqual((Object)options1.getPathPattern(), (Object)options2.getPathPattern()) && !options1.isShowAll() == !options2.isShowAll() && options1.isEnabled() == options2.isEnabled() && options1.isSkipContent() == options2.isSkipContent();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

