/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherApplessKt;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.UrlOpener;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0016J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016JK\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J8\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u000f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u001a\u0010\u001e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014JJ\u0010 \u001a\u00020\u00042\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0003\u0010\"\u001a\u0004\u0018\u00010\t2\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless;", "Lcom/intellij/ide/browsers/BrowserLauncher;", "()V", "browse", "", "file", "Ljava/io/File;", "Ljava/nio/file/Path;", "url", "", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "project", "Lcom/intellij/openapi/project/Project;", "browseUsingPath", "", "browserPath", "openInNewWindow", "additionalParameters", "", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ide/browsers/WebBrowser;Lcom/intellij/openapi/project/Project;Z[Ljava/lang/String;)Z", "doLaunch", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "fix", "Lkotlin/Function0;", "getEffectiveBrowser", "open", "openOrBrowse", "_url", "openWithDefaultBrowser", "openWithExplicitBrowser", "showError", "error", "title", "signUrl", "Companion", "intellij.platform.ide"})
public class BrowserLauncherAppless
extends BrowserLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void open(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BrowserLauncherAppless.openOrBrowse$default(this, url, false, null, 4, null);
    }

    @Override
    public void browse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path2 = file.getAbsolutePath();
        if (SystemInfo.isWindows && path2.charAt(0) != '/') {
            path2 = '/' + path2;
        }
        BrowserLauncherAppless.openOrBrowse$default(this, "file://" + path2, true, null, 4, null);
    }

    @Override
    public void browse(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String path2 = ((Object)file.toAbsolutePath()).toString();
        if (SystemInfo.isWindows && path2.charAt(0) != '/') {
            path2 = '/' + path2;
        }
        BrowserLauncherAppless.openOrBrowse$default(this, "file://" + path2, true, null, 4, null);
    }

    protected void openWithExplicitBrowser(@NotNull String url, @Nullable String browserPath, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BrowserLauncher.browseUsingPath$default(this, url, browserPath, null, project, false, null, 52, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void openOrBrowse(@NotNull String _url, boolean browse, @Nullable Project project) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)_url, (String)"_url");
        String string = _url;
        BrowserLauncherAppless browserLauncherAppless = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String url = browserLauncherAppless.signUrl(string2);
        Logger $this$debug$iv = BrowserLauncherApplessKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            browserLauncherAppless = $this$debug$iv;
            boolean bl = false;
            string2 = "opening [" + url + ']';
            browserLauncherAppless.debug(string2, e$iv);
        }
        if (StringsKt.startsWith$default((String)url, (String)"mailto:", (boolean)false, (int)2, null) && BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.MAIL)) {
            try {
                BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#mail");
                Desktop.getDesktop().mail(new URI(url));
            }
            catch (Exception e) {
                BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
            }
            return;
        }
        if (!BrowserUtil.isAbsoluteURL(url)) {
            File file = new File(url);
            if (!browse && BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.OPEN)) {
                if (!file.exists()) {
                    BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.file.does.not.exist", file.getPath()), null, project, null, null, 26, null);
                    return;
                }
                try {
                    BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#open");
                    Desktop.getDesktop().open(file);
                    return;
                }
                catch (IOException e) {
                    BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
                }
            }
            this.browse(file);
            return;
        }
        GeneralSettings settings = BrowserLauncherApplessKt.access$getGeneralSettings$p();
        if (settings.isUseDefaultBrowser()) {
            this.openWithDefaultBrowser(url, project);
        } else {
            this.openWithExplicitBrowser(url, settings.getBrowserPath(), project);
        }
    }

    public static /* synthetic */ void openOrBrowse$default(BrowserLauncherAppless browserLauncherAppless, String string, boolean bl, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openOrBrowse");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        browserLauncherAppless.openOrBrowse(string, bl, project);
    }

    private final void openWithDefaultBrowser(String url, Project project) {
        List command;
        block6: {
            if (BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.BROWSE)) {
                URI uri = VfsUtil.toUri(url);
                if (uri == null) {
                    BrowserLauncherAppless.showError$default(this, IdeBundle.message("error.malformed.url", url), null, project, null, null, 26, null);
                    return;
                }
                try {
                    BrowserLauncherApplessKt.access$getLOG$p().debug("Trying Desktop#browse");
                    Desktop.getDesktop().browse(uri);
                    return;
                }
                catch (Exception e) {
                    BrowserLauncherApplessKt.access$getLOG$p().warn('[' + url + ']', (Throwable)e);
                    if (!SystemInfo.isMac) break block6;
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"Error code: -10814", (boolean)false, (int)2, null)) break block6;
                    return;
                }
            }
        }
        if ((command = BrowserLauncherApplessKt.access$getDefaultBrowserCommand$p()) == null) {
            BrowserLauncherAppless.showError$default(this, IdeBundle.message("browser.default.not.supported", new Object[0]), null, project, null, null, 26, null);
            return;
        }
        if (StringsKt.startsWith$default((String)url, (String)"jar:", (boolean)false, (int)2, null)) {
            return;
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withParameters(new String[]{url});
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"GeneralCommandLine(command).withParameters(url)");
        BrowserLauncherAppless.doLaunch$default(this, generalCommandLine, project, null, null, 12, null);
    }

    @NotNull
    protected String signUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return url;
    }

    @Override
    public void browse(@NotNull String url, @Nullable WebBrowser browser, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        WebBrowser effectiveBrowser = this.getEffectiveBrowser(browser);
        if (effectiveBrowser == null || browser == null && !StringsKt.startsWith$default((String)url, (String)"http", (boolean)false, (int)2, null)) {
            this.openOrBrowse(url, true, project);
        } else {
            ExtensionPointName<UrlOpener> extensionPointName = UrlOpener.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"UrlOpener.EP_NAME");
            Object[] objectArray = extensionPointName.getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"UrlOpener.EP_NAME.extensions");
            Object[] $this$any$iv = objectArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                UrlOpener it = (UrlOpener)element$iv;
                boolean bl = false;
                if (it.openUrl(effectiveBrowser, this.signUrl(url), project)) break;
            }
        }
    }

    @Override
    public boolean browseUsingPath(@Nullable String url, @Nullable String browserPath, @Nullable WebBrowser browser, @Nullable Project project, boolean openInNewWindow, @NotNull String[] additionalParameters) {
        Object specific;
        Object object;
        BrowserSpecificSettings browserSpecificSettings;
        String string;
        boolean byName;
        Intrinsics.checkNotNullParameter((Object)additionalParameters, (String)"additionalParameters");
        if (url != null && StringsKt.startsWith$default((String)url, (String)"jar:", (boolean)false, (int)2, null)) {
            return false;
        }
        boolean bl = byName = browserPath == null && browser != null;
        if (byName) {
            WebBrowser webBrowser = browser;
            Intrinsics.checkNotNull((Object)webBrowser);
            string = PathUtil.toSystemDependentName(webBrowser.getPath());
        } else {
            string = browserPath;
        }
        String effectivePath = string;
        Function0 fix2 = byName ? (Function0)new Function0<Unit>(this, url, browser, project, openInNewWindow, additionalParameters){
            final /* synthetic */ BrowserLauncherAppless this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $openInNewWindow;
            final /* synthetic */ String[] $additionalParameters;

            public final void invoke() {
                WebBrowser webBrowser = this.$browser;
                Intrinsics.checkNotNull((Object)webBrowser);
                this.this$0.browseUsingPath(this.$url, null, webBrowser, this.$project, this.$openInNewWindow, this.$additionalParameters);
            }
            {
                this.this$0 = browserLauncherAppless;
                this.$url = string;
                this.$browser = webBrowser;
                this.$project = project;
                this.$openInNewWindow = bl;
                this.$additionalParameters = stringArray;
                super(0);
            }
        } : null;
        CharSequence charSequence = effectivePath;
        boolean bl2 = false;
        boolean bl3 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Object object2 = browser;
            if (object2 == null || (object2 = ((WebBrowser)object2).getBrowserNotFoundMessage()) == null) {
                object2 = IdeBundle.message("error.please.specify.path.to.web.browser", CommonBundle.settingsActionPath());
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"browser?.browserNotFound\u2026dle.settingsActionPath())");
            Object message = object2;
            this.showError((String)message, browser, project, IdeBundle.message("title.browser.not.found", new Object[0]), (Function0<Unit>)fix2);
            return false;
        }
        List<String> list = BrowserUtil.getOpenBrowserCommand(effectivePath, openInNewWindow);
        Intrinsics.checkNotNullExpressionValue(list, (String)"BrowserUtil.getOpenBrows\u2026ivePath, openInNewWindow)");
        List commandWithUrl = CollectionsKt.toMutableList((Collection)list);
        if (url != null) {
            if (browser != null) {
                browser.addOpenUrlParameter(commandWithUrl, url);
            } else {
                Collection collection = commandWithUrl;
                bl3 = false;
                collection.add(url);
            }
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(commandWithUrl);
        WebBrowser webBrowser = browser;
        BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = webBrowser != null ? webBrowser.getSpecificSettings() : null;
        if (browserSpecificSettings != null) {
            Map map = commandLine.getEnvironment();
            Map<String, String> map2 = browserSpecificSettings.getEnvironmentVariables();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"browserSpecificSettings.environmentVariables");
            map.putAll(map2);
        }
        if ((object = browserSpecificSettings) == null || (object = ((BrowserSpecificSettings)object).getAdditionalParameters()) == null) {
            object = specific = CollectionsKt.emptyList();
        }
        if (specific.size() + additionalParameters.length > 0) {
            if (Companion.isOpenCommandUsed(commandLine)) {
                commandLine.addParameter("--args");
            }
            commandLine.addParameters((List)specific);
            commandLine.addParameters(Arrays.copyOf(additionalParameters, additionalParameters.length));
        }
        this.doLaunch(commandLine, project, browser, (Function0<Unit>)fix2);
        return true;
    }

    private final void doLaunch(GeneralCommandLine command, Project project, WebBrowser browser, Function0<Unit> fix2) {
        Logger $this$debug$iv = BrowserLauncherApplessKt.access$getLOG$p();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = command.getCommandLineString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.commandLineString");
            String string2 = string;
            logger.debug(string2, (Throwable)e$iv);
        }
        ProcessIOExecutorService.INSTANCE.execute(new Runnable(this, command, browser, project, fix2){
            final /* synthetic */ BrowserLauncherAppless this$0;
            final /* synthetic */ GeneralCommandLine $command;
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0 $fix;

            public final void run() {
                try {
                    ProcessOutput output = new CapturingProcessHandler.Silent(this.$command).runProcess(10000, false);
                    if (!output.checkSuccess(BrowserLauncherApplessKt.access$getLOG$p())) {
                        ProcessOutput processOutput = output;
                        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"output");
                        if (processOutput.getExitCode() == 1) {
                            List list = output.getStderrLines();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"output.stderrLines");
                            String error = (String)CollectionsKt.firstOrNull((List)list);
                            this.this$0.showError(error, this.$browser, this.$project, null, (Function0<Unit>)this.$fix);
                        }
                    }
                }
                catch (ExecutionException e) {
                    this.this$0.showError(e.getMessage(), this.$browser, this.$project, null, (Function0<Unit>)this.$fix);
                }
            }
            {
                this.this$0 = browserLauncherAppless;
                this.$command = generalCommandLine;
                this.$browser = webBrowser;
                this.$project = project;
                this.$fix = function0;
            }
        });
    }

    static /* synthetic */ void doLaunch$default(BrowserLauncherAppless browserLauncherAppless, GeneralCommandLine generalCommandLine, Project project, WebBrowser webBrowser, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doLaunch");
        }
        if ((n & 4) != 0) {
            webBrowser = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        browserLauncherAppless.doLaunch(generalCommandLine, project, webBrowser, (Function0<Unit>)function0);
    }

    protected void showError(@NlsContexts.DialogMessage @Nullable String error, @Nullable WebBrowser browser, @Nullable Project project, @NlsContexts.DialogTitle @Nullable String title, @Nullable Function0<Unit> fix2) {
        BrowserLauncherApplessKt.access$getLOG$p().warn(error);
    }

    public static /* synthetic */ void showError$default(BrowserLauncherAppless browserLauncherAppless, String string, WebBrowser webBrowser, Project project, String string2, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showError");
        }
        if ((n & 2) != 0) {
            webBrowser = null;
        }
        if ((n & 4) != 0) {
            project = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        browserLauncherAppless.showError(string, webBrowser, project, string2, (Function0<Unit>)function0);
    }

    @Nullable
    protected WebBrowser getEffectiveBrowser(@Nullable WebBrowser browser) {
        return browser;
    }

    @JvmStatic
    public static final boolean canUseSystemDefaultBrowserPolicy() {
        return Companion.canUseSystemDefaultBrowserPolicy();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/browsers/BrowserLauncherAppless$Companion;", "", "()V", "canUseSystemDefaultBrowserPolicy", "", "isOpenCommandUsed", "command", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.platform.ide"})
    public static final class Companion {
        @JvmStatic
        public final boolean canUseSystemDefaultBrowserPolicy() {
            return BrowserLauncherApplessKt.access$isDesktopActionSupported(Desktop.Action.BROWSE) || SystemInfo.isMac || SystemInfo.isWindows || SystemInfo.isUnix && SystemInfo.hasXdgOpen();
        }

        public final boolean isOpenCommandUsed(@NotNull GeneralCommandLine command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return SystemInfo.isMac && Intrinsics.areEqual((Object)ExecUtil.getOpenCommandPath(), (Object)command.getExePath());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

