/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScratchUtil {
    private ScratchUtil() {
    }

    public static boolean isScratch(@Nullable VirtualFile file) {
        RootType rootType = RootType.forFile(file);
        return rootType != null && !rootType.isHidden();
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file) {
        int idx;
        if (project == null) {
            ScratchUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ScratchUtil.$$$reportNull$$$0(1);
        }
        RootType rootType = Objects.requireNonNull(RootType.forFile(file));
        String rootPath = ScratchFileService.getInstance().getRootPath(rootType);
        VirtualFile rootFile = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (rootFile == null || !VfsUtilCore.isAncestor(rootFile, file, false)) {
            throw new AssertionError((Object)file.getPath());
        }
        StringBuilder sb = new StringBuilder();
        VirtualFile o = file;
        while (!rootFile.equals(o)) {
            String part = StringUtil.notNullize((String)rootType.substituteName(project, o), (String)o.getName());
            if (sb.length() == 0 && part.indexOf(47) > -1) {
                part = part.substring(part.lastIndexOf(47) + 1);
            }
            sb.insert(0, "/" + part);
            o = o.getParent();
        }
        sb.insert(0, rootType.getDisplayName());
        if (sb.charAt(sb.length() - 1) == ']' && (idx = sb.lastIndexOf(" [")) > 0 && sb.indexOf("/" + sb.substring(idx + 2, sb.length() - 1) + "/") < idx) {
            sb.setLength(idx);
        }
        String string = sb.toString();
        if (string == null) {
            ScratchUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

