/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.XmlDomReader;
import com.intellij.util.XmlElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String prefix;
        block16: {
            prefix = System.getProperty("idea.platform.prefix", "");
            if (Boolean.getBoolean("idea.use.dev.build.server")) {
                String module = null;
                if (prefix.isEmpty() || prefix.equals("idea")) {
                    module = "intellij.idea.ultimate.resources";
                } else if (prefix.equals("WebStorm")) {
                    module = "intellij.webstorm";
                }
                if (module != null) {
                    XmlElement xmlElement2;
                    Path file = Paths.get(PathManager.getHomePath() + "/out/classes/production/" + module + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml", new String[0]);
                    try {
                        xmlElement2 = XmlDomReader.readXmlAsModel((InputStream)Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        break block16;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load " + file, e);
                    }
                    if (xmlElement2 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(0);
                    }
                    return xmlElement2;
                }
            } else {
                String appInfoData = ApplicationNamesInfo.getAppInfoData();
                if (!appInfoData.isEmpty()) {
                    XmlElement xmlElement3 = XmlDomReader.readXmlAsModel((byte[])appInfoData.getBytes(StandardCharsets.UTF_8));
                    if (xmlElement3 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(1);
                    }
                    return xmlElement3;
                }
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            xmlElement = XmlDomReader.readXmlAsModel((InputStream)stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(2);
        }
        return xmlElement;
    }

    private static String getAppInfoData() {
        return "<!-- Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file. -->\n<component xmlns=\"http://jetbrains.org/intellij/schema/application-info\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n           xsi:schemaLocation=\"http://jetbrains.org/intellij/schema/application-info http://jetbrains.org/intellij/schema/ApplicationInfo.xsd\">\n  <version major=\"2021\" minor=\"2.3\" eap=\"false\"/>\n  <company name=\"JetBrains s.r.o.\" url=\"https://www.jetbrains.com\" copyrightStart=\"2010\"/>\n  <build number=\"PC-212.5457.59\" date=\"202111081929\" majorReleaseDate=\"20210728\"/>\n  <logo url=\"/pycharm_core_logo.png\" textcolor=\"ffffff\" progressColor=\"ffffff\" progressY=\"396\" progressHeight=\"4\"/>\n  <about url=\"/pycharm_core_about.png\" logoX=\"540\" logoY=\"300\" logoW=\"100\" logoH=\"100\" foreground=\"ffffff\"\n         copyrightForeground=\"ffffff\" linkColor=\"589bf2\"/>\n  <icon ico=\"PyCharmCore.ico\" svg=\"/pycharm-ce.svg\" svg-small=\"/pycharm-ce_16.svg\"/>\n  <icon-eap svg=\"/pycharm-ce-eap.svg\" svg-small=\"/pycharm-ce-eap_16.svg\"/>\n  <names product=\"PyCharm\" edition=\"Community Edition\" script=\"pycharm\" default-launcher-name=\"charm\" motto=\"Python IDE for Professional Developers\"/>\n\n  <essential-plugin>PythonCore</essential-plugin>\n  <essential-plugin>com.jetbrains.pycharm.community.customization</essential-plugin>\n\n  <welcome-screen logo-url=\"/PyCharmCoreWelcomeScreen.png\"/>\n\n  <plugins url=\"https://plugins.jetbrains.com/\"\n           builtin-url=\"\"/>\n  <update-urls check=\"https://www.jetbrains.com/updates/updates.xml\"\n               patches=\"https://download.jetbrains.com/python/\"/>\n\n  <help webhelp-url=\"https://www.jetbrains.com/pycharm/webhelp\"/>\n  <documentation url=\"https://www.jetbrains.com/pycharm/learn/\"/>\n  <support url=\"https://intellij-support.jetbrains.com/hc/en-us/requests/new?ticket_form_id=66731&amp;product=PyCharm&amp;build=$BUILD&amp;os=$OS&amp;timezone=$TIMEZONE\"/>\n  <youtrack url=\"https://youtrack.jetbrains.com/newissue?project=PY&amp;clearDraft=true&amp;description=$DESCR\"/>\n  <feedback url=\"https://www.jetbrains.com/feedback/feedback.jsp?product=PyCharm&amp;build=$BUILD&amp;timezone=$TIMEZONE&amp;eval=$EVAL\"/>\n  <whatsnew url=\"https://www.jetbrains.com/pycharm/whatsnew/\"/>\n  <jetbrains-tv url=\"https://www.youtube.com/playlist?list=PLCTHcU1KoD99eyuXqUJHZy90-9jU2H2Y2\"/>\n</component>\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            XmlElement xmlElement = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(3);
            }
            return xmlElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result = instance;
            if (result == null) {
                instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(4);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(5);
        }
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

