/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorModificationUtil
extends EditorModificationUtilEx {
    private static final Key<ReadOnlyHint> READ_ONLY_VIEW_HINT_KEY = Key.create((String)"READ_ONLY_VIEW_HINT_KEY");

    private EditorModificationUtil() {
    }

    public static void deleteSelectedTextForAllCarets(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(0);
        }
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.deleteSelectedText(editor));
    }

    public static void zeroWidthBlockSelectionAtCaretColumn(Editor editor, int startLine, int endLine) {
        int caretColumn = editor.getCaretModel().getLogicalPosition().column;
        editor.getSelectionModel().setBlockSelection(new LogicalPosition(startLine, caretColumn), new LogicalPosition(endLine, caretColumn));
    }

    public static void pasteTransferableAsBlock(Editor editor, @Nullable Supplier<? extends Transferable> producer) {
        Transferable content = EditorModificationUtil.getTransferable(producer);
        if (content == null) {
            return;
        }
        String text2 = EditorModificationUtil.getStringContent(content);
        if (text2 == null) {
            return;
        }
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        LogicalPosition caretToRestore = editor.getCaretModel().getLogicalPosition();
        String[] lines2 = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false);
        int longestLineLength = 0;
        for (int i = 0; i < lines2.length; ++i) {
            String line = lines2[i];
            longestLineLength = Math.max(longestLineLength, line.length());
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(caretLine + i, caretToRestore.column));
            EditorModificationUtil.insertStringAtCaret(editor, line, false, true);
        }
        caretToRestore = new LogicalPosition(caretLine, caretToRestore.column + longestLineLength);
        editor.getCaretModel().moveToLogicalPosition(caretToRestore);
        EditorModificationUtil.zeroWidthBlockSelectionAtCaretColumn(editor, caretLine, caretLine);
    }

    @Nullable
    public static Transferable getContentsToPasteToEditor(@Nullable Producer<? extends Transferable> producer) {
        if (producer == null) {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            return manager.areDataFlavorsAvailable(DataFlavor.stringFlavor) ? manager.getContents() : null;
        }
        return (Transferable)producer.produce();
    }

    @Nullable
    public static String getStringContent(@NotNull Transferable content) {
        RawText raw;
        if (content == null) {
            EditorModificationUtil.$$$reportNull$$$0(1);
        }
        if ((raw = RawText.fromTransferable(content)) != null) {
            return raw.rawText;
        }
        try {
            return (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    private static Transferable getTransferable(Supplier<? extends Transferable> producer) {
        Transferable content = null;
        if (producer != null) {
            content = producer.get();
        } else {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            if (manager.areDataFlavorsAvailable(DataFlavor.stringFlavor)) {
                content = manager.getContents();
            }
        }
        return content;
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str) {
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(2);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, int caretShift) {
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(3);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true, caretShift);
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, boolean toProcessOverwriteMode) {
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(4);
        }
        EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, toProcessOverwriteMode, str.length());
    }

    public static void typeInStringAtCaretHonorMultipleCarets(Editor editor, @NotNull String str, boolean toProcessOverwriteMode, int caretShift) throws ReadOnlyFragmentModificationException {
        if (str == null) {
            EditorModificationUtil.$$$reportNull$$$0(5);
        }
        editor.getCaretModel().runForEachCaret(__ -> EditorModificationUtil.insertStringAtCaretNoScrolling(editor, str, toProcessOverwriteMode, true, caretShift));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public static void moveAllCaretsRelatively(@NotNull Editor editor, int caretShift) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(6);
        }
        editor.getCaretModel().runForEachCaret(caret -> caret.moveToOffset(caret.getOffset() + caretShift));
    }

    public static void moveCaretRelatively(@NotNull Editor editor, int caretShift) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(7);
        }
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(caretModel.getOffset() + caretShift);
    }

    @NotNull
    public static List<CaretState> calcBlockSelectionState(@NotNull Editor editor, @NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(8);
        }
        if (blockStart == null) {
            EditorModificationUtil.$$$reportNull$$$0(9);
        }
        if (blockEnd == null) {
            EditorModificationUtil.$$$reportNull$$$0(10);
        }
        int startLine = Math.max(Math.min(blockStart.line, editor.getDocument().getLineCount() - 1), 0);
        int endLine = Math.max(Math.min(blockEnd.line, editor.getDocument().getLineCount() - 1), 0);
        int step = endLine < startLine ? -1 : 1;
        int count = 1 + Math.abs(endLine - startLine);
        LinkedList<CaretState> caretStates = new LinkedList<CaretState>();
        boolean hasSelection = false;
        int line = startLine;
        int i = 0;
        while (i < count) {
            int startColumn = blockStart.column;
            int endColumn = blockEnd.column;
            int lineEndOffset = editor.getDocument().getLineEndOffset(line);
            LogicalPosition lineEndPosition = editor.offsetToLogicalPosition(lineEndOffset);
            int lineWidth = lineEndPosition.column;
            if (startColumn > lineWidth && endColumn > lineWidth && !editor.isColumnMode()) {
                LogicalPosition caretPos = new LogicalPosition(line, Math.min(startColumn, endColumn));
                caretStates.add(new CaretState(caretPos, lineEndPosition, lineEndPosition));
            } else {
                LogicalPosition startPos = new LogicalPosition(line, editor.isColumnMode() ? startColumn : Math.min(startColumn, lineWidth));
                LogicalPosition endPos = new LogicalPosition(line, editor.isColumnMode() ? endColumn : Math.min(endColumn, lineWidth));
                int startOffset = editor.logicalPositionToOffset(startPos);
                int endOffset = editor.logicalPositionToOffset(endPos);
                caretStates.add(new CaretState(endPos, startPos, endPos));
                hasSelection |= startOffset != endOffset;
            }
            ++i;
            line += step;
        }
        if (hasSelection && !editor.isColumnMode()) {
            Iterator caretStateIterator = caretStates.iterator();
            while (caretStateIterator.hasNext()) {
                CaretState state = (CaretState)caretStateIterator.next();
                if (!state.getSelectionStart().equals(state.getSelectionEnd())) continue;
                caretStateIterator.remove();
            }
        }
        LinkedList<CaretState> linkedList = caretStates;
        if (linkedList == null) {
            EditorModificationUtil.$$$reportNull$$$0(11);
        }
        return linkedList;
    }

    public static boolean requestWriting(@NotNull Editor editor) {
        FileDocumentManager.WriteAccessStatus writeAccess;
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(12);
        }
        if (!(writeAccess = FileDocumentManager.getInstance().requestWritingStatus(editor.getDocument(), editor.getProject())).hasWriteAccess()) {
            HintManager.getInstance().showInformationHint(editor, writeAccess.getReadOnlyMessage());
            return false;
        }
        return true;
    }

    public static boolean checkModificationAllowed(Editor editor) {
        if (!editor.isViewer()) {
            return true;
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || editor instanceof TextComponentEditor) {
            return false;
        }
        ReadOnlyHint hint = (ReadOnlyHint)ObjectUtils.chooseNotNull((Object)((ReadOnlyHint)READ_ONLY_VIEW_HINT_KEY.get((UserDataHolder)editor)), (Object)new ReadOnlyHint(EditorBundle.message("editing.viewer.hint", new Object[0]), null));
        HintManager.getInstance().showInformationHint(editor, hint.message, hint.linkListener);
        return false;
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @Nullable @NlsContexts.HintText String message) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(13);
        }
        EditorModificationUtil.setReadOnlyHint(editor, message, null);
    }

    public static void setReadOnlyHint(@NotNull Editor editor, @Nullable @NlsContexts.HintText String message, @Nullable HyperlinkListener linkListener) {
        if (editor == null) {
            EditorModificationUtil.$$$reportNull$$$0(14);
        }
        editor.putUserData(READ_ONLY_VIEW_HINT_KEY, message != null ? new ReadOnlyHint(message, linkListener) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/EditorModificationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/EditorModificationUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBlockSelectionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteSelectedTextForAllCarets";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "typeInStringAtCaretHonorMultipleCarets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moveAllCaretsRelatively";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretRelatively";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockSelectionState";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnlyHint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ReadOnlyHint {
        @NotNull
        public final @NlsContexts.HintText String message;
        @Nullable
        public final HyperlinkListener linkListener;

        private ReadOnlyHint(@NotNull @NlsContexts.HintText String message, @Nullable HyperlinkListener linkListener) {
            if (message == null) {
                ReadOnlyHint.$$$reportNull$$$0(0);
            }
            this.message = message;
            this.linkListener = linkListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/editor/EditorModificationUtil$ReadOnlyHint", "<init>"));
        }
    }
}

