/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectSystemId
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Map<String, ProjectSystemId> ourExistingIds = new ConcurrentHashMap<String, ProjectSystemId>();
    @NotNull
    public static final ProjectSystemId IDE = new ProjectSystemId("IDE");
    @NotNull
    @NonNls
    private final String id;
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    private final String readableName;

    public ProjectSystemId(@NotNull @NlsSafe String id) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(0);
        }
        this(id, StringUtil.capitalize((String)StringUtil.toLowerCase((String)id)));
    }

    @PropertyMapping(value={"id", "readableName"})
    public ProjectSystemId(@NotNull @NonNls String id, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String readableName) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(1);
        }
        if (readableName == null) {
            ProjectSystemId.$$$reportNull$$$0(2);
        }
        this.id = id;
        this.readableName = readableName;
        ourExistingIds.putIfAbsent(id, this);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSystemId owner = (ProjectSystemId)o;
        return this.id.equals(owner.id);
    }

    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            ProjectSystemId.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    public String getReadableName() {
        String string = this.readableName;
        if (string == null) {
            ProjectSystemId.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String toString() {
        return this.id;
    }

    @NotNull
    public ProjectSystemId intern() {
        ProjectSystemId current = ourExistingIds.putIfAbsent(this.id, this);
        ProjectSystemId projectSystemId = current == null ? this : current;
        if (projectSystemId == null) {
            ProjectSystemId.$$$reportNull$$$0(5);
        }
        return projectSystemId;
    }

    @Nullable
    public static ProjectSystemId findById(@NotNull String id) {
        if (id == null) {
            ProjectSystemId.$$$reportNull$$$0(6);
        }
        return ourExistingIds.get(id);
    }

    private Object readResolve() {
        ProjectSystemId cached = ourExistingIds.get(this.id);
        if (cached != null) {
            return cached;
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readableName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/ProjectSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/ProjectSystemId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

