/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.serialization.PropertyMapping;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectId
implements ProjectCoordinate,
Serializable {
    @Nullable
    private final String groupId;
    @Nullable
    private final String artifactId;
    @Nullable
    private final String version;

    @PropertyMapping(value={"groupId", "artifactId", "version"})
    public ProjectId(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @NotNull
    public String getKey() {
        StringBuilder builder = new StringBuilder();
        ProjectId.append(builder, this.groupId);
        ProjectId.append(builder, this.artifactId);
        ProjectId.append(builder, this.version);
        String string = builder.toString();
        if (string == null) {
            ProjectId.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayString() {
        String string = this.getKey();
        if (string == null) {
            ProjectId.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void append(StringBuilder builder, String part) {
        if (builder.length() != 0) {
            builder.append(':');
        }
        builder.append(part == null ? "<unknown>" : part);
    }

    public String toString() {
        return this.getDisplayString();
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId) {
        if (this.artifactId != null ? !this.artifactId.equals(artifactId) : artifactId != null) {
            return false;
        }
        return !(this.groupId != null ? !this.groupId.equals(groupId) : groupId != null);
    }

    public boolean equals(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        if (!this.equals(groupId, artifactId)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(version) : version != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectId other = (ProjectId)o;
        return this.equals(other.getGroupId(), other.artifactId, other.version);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/externalSystem/model/project/ProjectId";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

