/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.ide.DataManager;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileNavigator;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileNavigatorImpl
implements FileNavigator {
    @Override
    public void navigate(@NotNull OpenFileDescriptor descriptor, boolean requestFocus) {
        if (descriptor == null) {
            FileNavigatorImpl.$$$reportNull$$$0(0);
        }
        if (!this.canNavigate(descriptor.getFile())) {
            throw new IllegalStateException("target not valid");
        }
        if (!descriptor.getFile().isDirectory() && this.navigateInEditorOrNativeApp(descriptor, requestFocus)) {
            return;
        }
        if (this.navigateInProjectView(descriptor.getProject(), descriptor.getFile(), requestFocus)) {
            return;
        }
        String message = IdeBundle.message("error.files.of.this.type.cannot.be.opened", ApplicationNamesInfo.getInstance().getProductName());
        Messages.showErrorDialog(descriptor.getProject(), message, IdeBundle.message("title.cannot.open.file", new Object[0]));
    }

    private boolean navigateInEditorOrNativeApp(@NotNull OpenFileDescriptor descriptor, boolean requestFocus) {
        FileType type;
        if (descriptor == null) {
            FileNavigatorImpl.$$$reportNull$$$0(1);
        }
        if ((type = FileTypeManager.getInstance().getKnownFileTypeOrAssociate(descriptor.getFile(), descriptor.getProject())) == null || !descriptor.getFile().isValid()) {
            return false;
        }
        if (type instanceof INativeFileType) {
            return ((INativeFileType)type).openFileInAssociatedApplication(descriptor.getProject(), descriptor.getFile());
        }
        return this.navigateInEditor(descriptor, requestFocus);
    }

    private boolean navigateInProjectView(@NotNull Project project, @NotNull VirtualFile file, boolean requestFocus) {
        if (project == null) {
            FileNavigatorImpl.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FileNavigatorImpl.$$$reportNull$$$0(3);
        }
        FileSelectInContext context = new FileSelectInContext(project, file, null);
        for (SelectInTarget target : SelectInManager.getInstance(project).getTargetList()) {
            if (!context.selectIn(target, requestFocus)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean navigateInEditor(@NotNull OpenFileDescriptor descriptor, boolean requestFocus) {
        if (descriptor == null) {
            FileNavigatorImpl.$$$reportNull$$$0(4);
        }
        return this.navigateInRequestedEditor(descriptor) || this.navigateInAnyFileEditor(descriptor, requestFocus);
    }

    private boolean navigateInRequestedEditor(@NotNull OpenFileDescriptor descriptor) {
        DataContext ctx;
        Editor e;
        if (descriptor == null) {
            FileNavigatorImpl.$$$reportNull$$$0(5);
        }
        if ((e = (Editor)OpenFileDescriptor.NAVIGATE_IN_EDITOR.getData(ctx = DataManager.getInstance().getDataContext())) == null) {
            return false;
        }
        if (e.isDisposed()) {
            Logger.getInstance(OpenFileDescriptor.class).error("Disposed editor returned for NAVIGATE_IN_EDITOR from " + ctx);
            return false;
        }
        if (!Comparing.equal((Object)FileDocumentManager.getInstance().getFile(e.getDocument()), (Object)descriptor.getFile())) {
            return false;
        }
        OpenFileDescriptor.navigateInEditor(descriptor, e);
        return true;
    }

    protected boolean navigateInAnyFileEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            FileNavigatorImpl.$$$reportNull$$$0(6);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance(descriptor.getProject());
        List<FileEditor> editors = fileEditorManager.openEditor(descriptor, focusEditor);
        for (FileEditor editor : editors) {
            if (!(editor instanceof TextEditor)) continue;
            Editor e = ((TextEditor)editor).getEditor();
            fileEditorManager.runWhenLoaded(e, () -> OpenFileDescriptor.unfoldCurrentLine(e));
        }
        return !editors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/FileNavigatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "navigate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateInEditorOrNativeApp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateInProjectView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateInEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateInRequestedEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateInAnyFileEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

