/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.messages;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.messages.MessagesBorderLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageDialog
extends DialogWrapper {
    protected @NlsContexts.DialogMessage @Nullable String myMessage;
    protected String[] myOptions;
    protected int myDefaultOptionIndex;
    protected int myFocusedOptionIndex;
    protected Icon myIcon;
    private MessagesBorderLayout myLayout;
    @NonNls
    @Nullable
    private String myHelpId;

    public MessageDialog(@Nullable Project project, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon2, boolean canBeParent) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(0);
        }
        this(project, null, message, title, options, defaultOptionIndex, -1, icon2, null, canBeParent);
    }

    public MessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean canBeParent) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(1);
        }
        this(project, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, canBeParent, null);
    }

    public MessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, boolean canBeParent, @Nullable String helpId) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(2);
        }
        super(project, parentComponent, canBeParent, DialogWrapper.IdeModalityType.IDE);
        this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon2, doNotAskOption, helpId);
    }

    public MessageDialog(@NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon2) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(3);
        }
        this(null, null, message, title, options, defaultOptionIndex, -1, icon2, null, false);
    }

    protected MessageDialog() {
        super(false);
    }

    protected MessageDialog(Project project) {
        super(project, false);
    }

    public MessageDialog(Project project, boolean canBeParent) {
        super(project, canBeParent);
    }

    protected void _init(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage @Nullable String message, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, @Nullable String helpId) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(4);
        }
        this.setTitle(title);
        if (Messages.isMacSheetEmulation()) {
            this.setUndecorated(true);
        }
        this.myMessage = message;
        this.myOptions = options;
        this.myDefaultOptionIndex = defaultOptionIndex;
        this.myFocusedOptionIndex = focusedOptionIndex;
        this.myIcon = icon2;
        this.myHelpId = helpId;
        this.setDoNotAskOption(doNotAskOption);
        this.init();
        if (Messages.isMacSheetEmulation()) {
            MacUtil.adjustFocusTraversal((Disposable)this.myDisposable);
        }
    }

    @Override
    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (int i = 0; i < this.myOptions.length; ++i) {
            String option = this.myOptions[i];
            final int exitCode = i;
            AbstractAction action2 = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)option)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.close(exitCode, true);
                }
            };
            if (i == this.myDefaultOptionIndex) {
                action2.putValue("DefaultAction", Boolean.TRUE);
            }
            if (i == this.myFocusedOptionIndex) {
                action2.putValue("FocusedAction", Boolean.TRUE);
            }
            UIUtil.assignMnemonic((String)option, (Action)action2);
            actions.add(action2);
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            MessageDialog.$$$reportNull$$$0(5);
        }
        return actionArray;
    }

    @Override
    public void doCancelAction() {
        this.close(-1);
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.doCreateCenterPanel();
    }

    @Override
    @NotNull
    protected LayoutManager createRootLayout() {
        LayoutManager layoutManager;
        if (Messages.isMacSheetEmulation()) {
            this.myLayout = new MessagesBorderLayout();
            layoutManager = this.myLayout;
        } else {
            layoutManager = super.createRootLayout();
        }
        if (layoutManager == null) {
            MessageDialog.$$$reportNull$$$0(6);
        }
        return layoutManager;
    }

    @Override
    protected void dispose() {
        if (Messages.isMacSheetEmulation()) {
            this.animate();
        } else {
            super.dispose();
        }
    }

    @Override
    public void show() {
        if (Messages.isMacSheetEmulation()) {
            this.setInitialLocationCallback((Computable<? extends Point>)((Computable)() -> {
                JRootPane rootPane = SwingUtilities.getRootPane(this.getWindow().getParent());
                if (rootPane == null) {
                    rootPane = SwingUtilities.getRootPane(this.getWindow().getOwner());
                }
                Point p = rootPane.getLocationOnScreen();
                p.x += (rootPane.getWidth() - this.getWindow().getWidth()) / 2;
                return p;
            }));
            this.animate();
            this.getPeer().getWindow().setOpacity(0.8f);
            this.setAutoAdjustable(false);
            this.setSize(this.getPreferredSize().width, 0);
        }
        super.show();
    }

    private void animate() {
        final int height = this.getPreferredSize().height;
        int frameCount = 10;
        final boolean toClose = this.isShowing();
        final AtomicInteger i = new AtomicInteger(-1);
        final Alarm animator = new Alarm(this.myDisposable);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int state = i.addAndGet(1);
                double linearProgress = (double)state / 10.0;
                if (toClose) {
                    linearProgress = 1.0 - linearProgress;
                }
                MessageDialog.this.myLayout.setPhase((1.0 - Math.cos(Math.PI * linearProgress)) / 2.0);
                Window window = MessageDialog.this.getPeer().getWindow();
                Rectangle bounds = window.getBounds();
                bounds.height = (int)((double)height * MessageDialog.this.myLayout.getPhase());
                window.setBounds(bounds);
                if (state == 0 && !toClose && window.getOwner() instanceof IdeFrame) {
                    WindowManager.getInstance().requestUserAttention((IdeFrame)((Object)window.getOwner()), true);
                }
                if (state < 10) {
                    animator.addRequest((Runnable)this, 10);
                } else if (toClose) {
                    MessageDialog.super.dispose();
                }
            }
        };
        animator.addRequest(runnable, 10, ModalityState.stateForComponent(this.getRootPane()));
    }

    protected JComponent doCreateCenterPanel() {
        JPanel panel2 = this.createIconPanel();
        if (this.myMessage != null) {
            JTextPane messageComponent2 = this.createMessageComponent(this.myMessage);
            panel2.add((Component)Messages.wrapToScrollPaneIfNeeded(messageComponent2, 100, 15), "Center");
        }
        return panel2;
    }

    @NotNull
    protected JPanel createIconPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(15, 0));
        if (this.myIcon != null) {
            JLabel iconLabel = new JLabel(this.myIcon);
            Container container = new Container();
            container.setLayout(new BorderLayout());
            container.add((Component)iconLabel, "North");
            panel2.add((Component)container, "West");
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MessageDialog.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @NotNull
    protected JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new BorderLayout());
        if (this.myMessage != null) {
            JLabel textLabel = new JLabel(this.myMessage);
            textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            textLabel.setUI(new MultiLineLabelUI());
            messagePanel.add((Component)textLabel, "North");
        }
        JPanel jPanel = messagePanel;
        if (jPanel == null) {
            MessageDialog.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    protected JTextPane createMessageComponent(@NlsContexts.DialogMessage String message) {
        JTextPane messageComponent2 = new JTextPane();
        return Messages.configureMessagePaneUi(messageComponent2, message);
    }

    @Override
    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/messages/MessageDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/messages/MessageDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootLayout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "_init";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

