/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRefElementCreator;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementRef<T extends PsiElement> {
    private volatile PsiRefColleague<T> myColleague;

    public PsiElementRef(PsiRefColleague<T> colleague) {
        this.myColleague = colleague;
    }

    public boolean isImaginary() {
        return this.getPsiElement() == null;
    }

    @Nullable
    public T getPsiElement() {
        return this.myColleague.getPsiElement();
    }

    @NotNull
    public T ensurePsiElementExists() {
        PsiRefColleague.Real<T> realColleague = this.myColleague.makeReal();
        this.myColleague = realColleague;
        T t = realColleague.getPsiElement();
        if (t == null) {
            PsiElementRef.$$$reportNull$$$0(0);
        }
        return t;
    }

    @NotNull
    public PsiElement getRoot() {
        PsiElement psiElement = this.myColleague.getRoot();
        if (psiElement == null) {
            PsiElementRef.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    public boolean equals(Object o) {
        return o instanceof PsiElementRef && this.myColleague.equals(((PsiElementRef)o).myColleague);
    }

    public int hashCode() {
        return this.myColleague.hashCode();
    }

    public boolean isValid() {
        return this.myColleague.isValid();
    }

    public static <T extends PsiElement> PsiElementRef<T> real(@NotNull T element) {
        if (element == null) {
            PsiElementRef.$$$reportNull$$$0(2);
        }
        return new PsiElementRef<T>(new PsiRefColleague.Real<T>(element));
    }

    public static <Child extends PsiElement, Parent extends PsiElement> PsiElementRef<Child> imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<? super Parent, ? extends Child> creator) {
        return new PsiElementRef(new PsiRefColleague.Imaginary<Child, Parent>(parent, creator));
    }

    public PsiManager getPsiManager() {
        return this.myColleague.getRoot().getManager();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiElementRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ensurePsiElementExists";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiElementRef";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "real";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface PsiRefColleague<T extends PsiElement> {
        public boolean isValid();

        @Nullable
        public T getPsiElement();

        @NotNull
        public Real<T> makeReal();

        @NotNull
        public PsiElement getRoot();

        public static class Imaginary<Child extends PsiElement, Parent extends PsiElement>
        implements PsiRefColleague<Child> {
            private final PsiElementRef<? extends Parent> myParent;
            private final PsiRefElementCreator<? super Parent, ? extends Child> myCreator;

            public Imaginary(PsiElementRef<? extends Parent> parent, PsiRefElementCreator<? super Parent, ? extends Child> creator) {
                this.myParent = parent;
                this.myCreator = creator;
            }

            @Override
            public boolean isValid() {
                return this.myParent.isValid();
            }

            @Override
            public Child getPsiElement() {
                return null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Imaginary imaginary = (Imaginary)o;
                if (!this.myCreator.equals(imaginary.myCreator)) {
                    return false;
                }
                return this.myParent.equals(imaginary.myParent);
            }

            public int hashCode() {
                int result = this.myParent.hashCode();
                result = 31 * result + this.myCreator.hashCode();
                return result;
            }

            @Override
            @NotNull
            public Real<Child> makeReal() {
                return new Real<PsiElement>((PsiElement)this.myCreator.createChild(this.myParent.ensurePsiElementExists()));
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                PsiElement psiElement = this.myParent.getRoot();
                if (psiElement == null) {
                    Imaginary.$$$reportNull$$$0(0);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiElementRef$PsiRefColleague$Imaginary", "getRoot"));
            }
        }

        public static class Real<T extends PsiElement>
        implements PsiRefColleague<T> {
            private final T myElement;

            public Real(@NotNull T element) {
                if (element == null) {
                    Real.$$$reportNull$$$0(0);
                }
                PsiUtilCore.ensureValid(element);
                this.myElement = element;
            }

            @Override
            @NotNull
            public T getPsiElement() {
                T t = this.myElement;
                if (t == null) {
                    Real.$$$reportNull$$$0(1);
                }
                return t;
            }

            @Override
            public boolean isValid() {
                return this.myElement.isValid();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Real real = (Real)o;
                return this.myElement.equals(real.myElement);
            }

            public int hashCode() {
                return this.myElement.hashCode();
            }

            @Override
            @NotNull
            public Real<T> makeReal() {
                Real real = this;
                if (real == null) {
                    Real.$$$reportNull$$$0(2);
                }
                return real;
            }

            @Override
            @NotNull
            public PsiElement getRoot() {
                T t = this.myElement;
                if (t == null) {
                    Real.$$$reportNull$$$0(3);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/PsiElementRef$PsiRefColleague$Real";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/PsiElementRef$PsiRefColleague$Real";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPsiElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "makeReal";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRoot";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

