/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class OptionalChooserComponent<T>
implements CheckBoxListListener,
ComponentWithEmptyText {
    private JPanel myContentPane;
    private CheckBoxList myList;
    private DefaultListModel myListModel;
    private List<Pair<T, Boolean>> myInitialList;
    private ArrayList<Pair<T, Boolean>> myWorkingList;

    public OptionalChooserComponent(@NotNull List<Pair<T, Boolean>> list) {
        if (list == null) {
            OptionalChooserComponent.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.setInitialList(list);
        this.myWorkingList = new ArrayList<Pair<T, Boolean>>(this.myInitialList);
        this.reset();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myList.getEmptyText();
        if (statusText == null) {
            OptionalChooserComponent.$$$reportNull$$$0(1);
        }
        return statusText;
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public void checkBoxSelectionChanged(int index, boolean value2) {
        Pair<T, Boolean> pair = this.myWorkingList.remove(index);
        this.myWorkingList.add(index, Pair.create((Object)pair.first, (Object)value2));
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList(this);
        this.myList.setBorder(null);
        this.myListModel = (DefaultListModel)this.myList.getModel();
    }

    public void reset() {
        this.myWorkingList = new ArrayList<Pair<T, Boolean>>(this.myInitialList);
        this.refresh();
    }

    protected abstract JCheckBox createCheckBox(T var1, boolean var2);

    public int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.myList.setSelectedIndex(index);
    }

    public boolean removeAt(int index) {
        this.getCurrentModel().remove(index);
        this.refresh();
        if (index < this.getCurrentModel().size()) {
            this.setSelectedIndex(index);
            return true;
        }
        if (index > 0) {
            this.setSelectedIndex(index - 1);
            return true;
        }
        return false;
    }

    public boolean removeSelected() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex != -1) {
            return this.removeAt(selectedIndex);
        }
        return false;
    }

    public boolean isModified() {
        return !this.myWorkingList.equals(this.myInitialList);
    }

    public void setInitialList(@NotNull List<Pair<T, Boolean>> list) {
        if (list == null) {
            OptionalChooserComponent.$$$reportNull$$$0(2);
        }
        this.myInitialList = list;
    }

    public ArrayList<Pair<T, Boolean>> getCurrentModel() {
        return this.myWorkingList;
    }

    public void apply() {
        this.myInitialList.clear();
        this.myInitialList.addAll(this.myWorkingList);
    }

    public void refresh() {
        this.myListModel.clear();
        for (Pair<T, Boolean> pair : this.myWorkingList) {
            this.myListModel.addElement(this.createCheckBox(pair.first, (Boolean)pair.second));
        }
    }

    public CheckBoxList getList() {
        return this.myList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/OptionalChooserComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/OptionalChooserComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setInitialList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        CheckBoxList checkBoxList = this.myList;
        checkBoxList.setSelectionMode(0);
        jBScrollPane.setViewportView(checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

