/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathsChooserComponent
implements ComponentWithEmptyText {
    private final JPanel myContentPane;
    private final JBList myList;
    private final DefaultListModel myListModel;
    private List<@NlsSafe String> myWorkingCollection;
    private final List<@NlsSafe String> myInitialCollection;
    @Nullable
    private final Project myProject;

    public PathsChooserComponent(@NotNull List<String> collection, @NotNull PathProcessor processor) {
        if (collection == null) {
            PathsChooserComponent.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PathsChooserComponent.$$$reportNull$$$0(1);
        }
        this(collection, processor, null);
    }

    public PathsChooserComponent(@NotNull List<String> collection, final @NotNull PathProcessor processor, @Nullable Project project) {
        if (collection == null) {
            PathsChooserComponent.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PathsChooserComponent.$$$reportNull$$$0(3);
        }
        this.myList = new JBList();
        this.myList.setSelectionMode(0);
        this.myInitialCollection = collection;
        this.myProject = project;
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        this.myListModel = new DefaultListModel();
        this.myList.setModel(this.myListModel);
        this.myContentPane = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor dirChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                dirChooser.setShowFileSystemRoots(true);
                dirChooser.setHideIgnored(true);
                dirChooser.setTitle(UIBundle.message("file.chooser.default.title", new Object[0]));
                FileChooser.chooseFiles(dirChooser, PathsChooserComponent.this.myProject, null, (Consumer<? super List<VirtualFile>>)((Consumer)files -> {
                    for (VirtualFile file : files) {
                        String path2 = file.getPresentableUrl();
                        if (!processor.addPath(PathsChooserComponent.this.myWorkingCollection, path2)) continue;
                        PathsChooserComponent.this.myListModel.addElement(path2);
                    }
                }));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String path2;
                int selected = PathsChooserComponent.this.myList.getSelectedIndex();
                if (selected != -1 && processor.removePath(PathsChooserComponent.this.myWorkingCollection, path2 = (String)PathsChooserComponent.this.myListModel.get(selected))) {
                    PathsChooserComponent.this.myListModel.remove(selected);
                }
            }
        }).createPanel();
        this.reset();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myList.getEmptyText();
        if (statusText == null) {
            PathsChooserComponent.$$$reportNull$$$0(4);
        }
        return statusText;
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public List<String> getValues() {
        return this.myWorkingCollection;
    }

    public void reset() {
        this.myListModel.clear();
        this.myWorkingCollection = new ArrayList<String>(this.myInitialCollection);
        for (String path2 : this.myWorkingCollection) {
            this.myListModel.addElement(path2);
        }
    }

    public boolean isModified() {
        return !this.myWorkingCollection.equals(this.myInitialCollection);
    }

    public void apply() {
        this.myInitialCollection.clear();
        this.myInitialCollection.addAll(this.myWorkingCollection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/PathsChooserComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/PathsChooserComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PathProcessor {
        public boolean addPath(List<String> var1, String var2);

        public boolean removePath(List<String> var1, String var2);
    }
}

