/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.util.animation.CubicBezierEasing;

@FunctionalInterface
public interface Easing {
    public static final Easing LINEAR = n -> n;

    public double calc(double var1);

    public static Easing bezier(double c1x, double c1y, double c2x, double c2y) {
        return new CubicBezierEasing(c1x, c1y, c2x, c2y);
    }

    default public Easing convert(double t, double b, double c, double d) {
        return x -> c * this.calc(t / d) + b;
    }

    default public Easing reverse() {
        return x -> this.calc(1.0 - x);
    }

    default public Easing invert() {
        return x -> 1.0 - this.calc(1.0 - x);
    }

    default public Easing mirror() {
        return x -> this.calc(x < 0.5 ? x * 2.0 : 1.0 - (x - 0.5) * 2.0);
    }

    default public Stateful stateful() {
        return new Stateful(this);
    }

    default public Easing coerceIn(double start, double end) {
        return x -> this.calc(x * (end - start) + start);
    }

    public static final class Stateful
    implements Easing {
        private final Easing delegate;
        public double value;

        private Stateful(Easing delegate) {
            this.delegate = delegate;
        }

        @Override
        public double calc(double x) {
            this.value = x;
            return this.delegate.calc(this.value);
        }
    }
}

