/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.idea.IdeaLogger;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemBase;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.project.ProjectKt;
import com.intellij.project.TestProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.OpenProjectTaskBuilder;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeavyPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    protected Project myProject;
    protected Module myModule;
    private final TemporaryDirectory temporaryDirectory = new TemporaryDirectory();
    protected boolean myAssertionsInTestDetected;
    private static TestCase ourTestCase;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private SdkLeakTracker myOldSdks;
    private VirtualFilePointerTracker myVirtualFilePointerTracker;
    @Nullable
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private AccessToken projectTracker;
    private static final String[] PREFIX_CANDIDATES;

    @NotNull
    protected final TemporaryDirectory getTempDir() {
        TemporaryDirectory temporaryDirectory = this.temporaryDirectory;
        if (temporaryDirectory == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(0);
        }
        return temporaryDirectory;
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure() {
        return this.createTestProjectStructure(null, true);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(@Nullable String rootPath) {
        return this.createTestProjectStructure(rootPath, true);
    }

    @NotNull
    protected final VirtualFile createTestProjectStructure(@Nullable String rootPath, boolean addProjectRoots) {
        Path dir = this.temporaryDirectory.newPath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        VirtualFile result = HeavyTestHelper.createTestProjectStructure(this.myModule, rootPath, dir, addProjectRoots);
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        VirtualFile virtualFile = result;
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(1);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createTestProjectStructure(@Nullable Module module, @Nullable String rootPath, boolean addProjectRoots, @NotNull TemporaryDirectory temporaryDirectory) {
        if (temporaryDirectory == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(2);
        }
        Path dir = temporaryDirectory.newPath();
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        VirtualFile virtualFile = HeavyTestHelper.createTestProjectStructure(module, rootPath, dir, addProjectRoots);
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    protected VirtualFile createTestProjectStructure(@NotNull Project project2, @Nullable Module module, @Nullable String rootPath, boolean addProjectRoots) {
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(4);
        }
        VirtualFile file2 = HeavyPlatformTestCase.createTestProjectStructure(module, rootPath, addProjectRoots, this.getTempDir());
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(6);
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    public static VirtualFile synchronizeTempDirVfs(@NotNull Path tempDir) {
        VirtualFile virtualFile;
        if (tempDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(7);
        }
        if ((virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)tempDir.toString()))) != null) {
            HeavyPlatformTestCase.synchronizeTempDirVfs(virtualFile);
        }
        return virtualFile;
    }

    protected void initApplication() throws Exception {
        TestApplicationManager testAppManager = TestApplicationManager.getInstance();
        testAppManager.setDataProvider(this);
        this.myOldSdks = new SdkLeakTracker();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        if (System.getProperty("idea.platform.prefix") != null) {
            ourPlatformPrefixInitialized = true;
            return;
        }
        for (String candidate : PREFIX_CANDIDATES) {
            Object markerPath = candidate == null ? "idea/ApplicationInfo.xml" : "META-INF/" + candidate + "Plugin.xml";
            URL resource = HeavyPlatformTestCase.class.getClassLoader().getResource((String)markerPath);
            if (resource == null) continue;
            if (candidate == null) break;
            HeavyPlatformTestCase.setPlatformPrefix(candidate);
            break;
        }
    }

    @Override
    @NotNull
    final Path createGlobalTempDirectory() {
        Object testName;
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        Object object = testName = policy == null ? null : policy.getPerTestTempDirName();
        if (testName == null) {
            testName = "unitTest_" + TemporaryDirectory.testNameToFileName(this.getName());
        }
        Path result = TemporaryDirectory.generateTemporaryPath((String)testName);
        this.temporaryDirectory.scheduleDelete(result);
        FileUtil.resetCanonicalTempPathCache((String)result.toString());
        this.temporaryDirectory.init("", result);
        Path path = result;
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(8);
        }
        return path;
    }

    @Override
    final void removeGlobalTempDirectory(@NotNull Path dir) {
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(9);
        }
        this.temporaryDirectory.after();
    }

    @Override
    protected void addTmpFileToKeep(@NotNull Path file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            HeavyPlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.debug(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.projectTracker = ((TestProjectManager)ProjectManager.getInstance()).startTracking();
        if (this.myOldSdks == null) {
            this.myOldSdks = new SdkLeakTracker();
        }
        this.setUpProject();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        boolean isTrackCodeStyleChanges = !this.isStressTest() && ApplicationManager.getApplication() != null && !(ApplicationManager.getApplication() instanceof MockApplication);
        this.myCodeStyleSettingsTracker = isTrackCodeStyleChanges ? new CodeStyleSettingsTracker(() -> CodeStyle.getDefaultSettings()) : null;
        ourTestCase = this;
        if (this.myProject != null) {
            CodeStyle.setTemporarySettings((Project)this.myProject, (CodeStyleSettings)CodeStyle.createTestSettings());
            InjectedLanguageManagerImpl.pushInjectors((Project)this.myProject);
            ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).clearUncommittedDocuments();
        }
        UIUtil.dispatchAllInvocationEvents();
        this.myVirtualFilePointerTracker = new VirtualFilePointerTracker();
    }

    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final PsiManager getPsiManager() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        if (psiManager == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(11);
        }
        return psiManager;
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProject = this.doCreateAndOpenProject();
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            this.setUpModule();
            this.setUpJdk();
        }));
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    @NotNull
    protected OpenProjectTaskBuilder getOpenProjectOptions() {
        OpenProjectTaskBuilder openProjectTaskBuilder = new OpenProjectTaskBuilder().projectName(this.getProjectFilename());
        if (openProjectTaskBuilder == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(12);
        }
        return openProjectTaskBuilder;
    }

    @NotNull
    protected Project doCreateAndOpenProject() {
        OpenProjectTaskBuilder optionBuilder = this.getOpenProjectOptions();
        Path projectFile = this.getProjectDirOrFile(this.isCreateDirectoryBasedProject());
        Project project2 = Objects.requireNonNull(ProjectManagerEx.getInstanceEx().openProject(projectFile, optionBuilder.build()));
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(13);
        }
        return project2;
    }

    protected boolean isCreateDirectoryBasedProject() {
        return false;
    }

    @NotNull
    protected final Path getProjectDirOrFile() {
        Path path = this.getProjectDirOrFile(this.isCreateDirectoryBasedProject());
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(14);
        }
        return path;
    }

    @NotNull
    protected Path getProjectDirOrFile(boolean isDirectoryBasedProject) {
        Path path = this.temporaryDirectory.newPath(this.getProjectFilename() + (isDirectoryBasedProject ? "" : ".ipr"));
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(15);
        }
        return path;
    }

    @Nullable
    private String getProjectFilename() {
        String testName = this.getName();
        return testName == null ? null : FileUtil.sanitizeFileName((String)testName, (boolean)false);
    }

    protected void setUpModule() {
        try {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> {
                this.myModule = this.createMainModule();
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected Module createMainModule() throws IOException {
        Module module = this.createModule(this.myProject.getName());
        if (module == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(16);
        }
        return module;
    }

    @NotNull
    protected Module createModule(@NonNls @NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(17);
        }
        Module module = this.doCreateRealModule(moduleName);
        if (module == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(18);
        }
        return module;
    }

    @NotNull
    protected Module doCreateRealModule(@NotNull String moduleName) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(19);
        }
        return this.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    @NotNull
    protected final Module doCreateRealModuleIn(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(20);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(21);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(22);
        }
        return this.createModuleAt(moduleName, project2, moduleType, ProjectKt.getStateStore((Project)project2).getProjectBasePath());
    }

    @NotNull
    protected final Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull Path path) {
        if (moduleName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(24);
        }
        if (moduleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(25);
        }
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(26);
        }
        Path moduleFile = path.resolve(moduleName + ".iml");
        Module module = (Module)WriteAction.computeAndWait(() -> ModuleManager.getInstance((Project)project2).newModule(moduleFile, moduleType.getId()));
        if (module == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(27);
        }
        return module;
    }

    @NotNull
    protected ModuleType<?> getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(28);
        }
        return emptyModuleType;
    }

    public static void cleanupApplicationCaches(@Nullable Project project2) {
        LocalFileSystemBase localFileSystem;
        FileBasedIndex fileBasedIndex;
        ProjectManagerEx projectManager;
        Application app = ApplicationManager.getApplication();
        if (app == null) {
            return;
        }
        NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
        if (globalInstance != null) {
            globalInstance.dropHistoryInTests();
        }
        if (project2 != null && !project2.isDisposed()) {
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        if ((projectManager = ProjectManagerEx.getInstanceExIfCreated()) != null && projectManager.isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        if ((fileBasedIndex = (FileBasedIndex)app.getServiceIfCreated(FileBasedIndex.class)) instanceof FileBasedIndexImpl) {
            ((FileBasedIndexImpl)fileBasedIndex).cleanupForNextTest();
        }
        if (app.getServiceIfCreated(VirtualFileManager.class) != null && (localFileSystem = (LocalFileSystemBase)LocalFileSystem.getInstance()) != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    @NotNull
    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            Set<VirtualFile> set = ourEternallyLivingFilesCache;
            if (set == null) {
                HeavyPlatformTestCase.$$$reportNull$$$0(29);
            }
            return set;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                HeavyPlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        HashSet<VirtualFile> hashSet = survivors;
        if (hashSet == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(30);
        }
        return hashSet;
    }

    public static void addSurvivingFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(31);
        }
        for (VirtualFile virtualFile : files) {
            HeavyPlatformTestCase.registerSurvivor(HeavyPlatformTestCase.eternallyLivingFiles(), virtualFile);
        }
    }

    private static void registerSurvivor(@NotNull Set<? super VirtualFile> survivors, @NotNull VirtualFile file2) {
        if (survivors == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(33);
        }
        HeavyPlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add((VirtualFile)file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(@NotNull VirtualFile root, @NotNull Set<? super VirtualFile> to) {
        if (root == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(34);
        }
        if (to == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(35);
        }
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add((VirtualFile)child);
                HeavyPlatformTestCase.addSubTree(child, to);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = this.myProject;
        if (project2 != null && !project2.isDisposed()) {
            TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
        }
        RunAll.runAll(() -> this.disposeRootDisposable(), () -> {
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
            this.myProject = null;
        }, () -> {
            AccessToken projectTracker = this.projectTracker;
            if (projectTracker != null) {
                this.projectTracker = null;
                projectTracker.finish();
            }
        }, () -> UIUtil.dispatchAllInvocationEvents(), () -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            JarFileSystemImpl.cleanupForNextTest();
            LaterInvocator.dispatchPendingFlushes();
        }, () -> {
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }, () -> super.tearDown(), () -> {
            if (this.myEditorListenerTracker != null) {
                this.myEditorListenerTracker.checkListenersLeak();
            }
        }, () -> {
            if (this.myThreadTracker != null) {
                this.myThreadTracker.checkLeak();
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> this.myOldSdks.checkForJdkTableLeaks(), () -> this.myVirtualFilePointerTracker.assertPointersAreDisposed(), () -> {
            this.myModule = null;
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
        });
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    @NotNull
    protected final <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(36);
        }
        Disposer.register((Disposable)this.myProject, disposable);
        T t = disposable;
        if (t == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(37);
        }
        return t;
    }

    private void resetClassFields(@NotNull Class<?> aClass) {
        if (aClass == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(38);
        }
        try {
            HeavyPlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == HeavyPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    protected void registerTestProjectJdk(Sdk jdk) {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk existingSdk : jdkTable.getAllJdks()) {
            if (existingSdk != jdk) continue;
            return;
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)this.myProject));
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        if (jdk != null) {
            this.registerTestProjectJdk(jdk);
        }
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    protected void runBare(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(39);
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.wrapTestRunnable((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.runBareImpl(testRunnable))).run();
        }
        finally {
            try {
                EdtTestUtil.runInEdtAndWait(() -> {
                    HeavyPlatformTestCase.cleanupApplicationCaches(this.getProject());
                    this.resetAllFields();
                });
            }
            catch (Throwable throwable) {}
        }
    }

    private void runBareImpl(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(40);
        }
        ThrowableRunnable runnable = () -> {
            try {
                this.myAssertionsInTestDetected = true;
                this.setUp();
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                try {
                    this.tearDown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            Throwable exception = null;
            try {
                this.myAssertionsInTestDetected = true;
                this.runTestRunnable(testRunnable);
                this.myAssertionsInTestDetected = false;
            }
            catch (Throwable e) {
                exception = e;
            }
            finally {
                block17: {
                    try {
                        this.tearDown();
                    }
                    catch (Throwable e) {
                        if (exception != null) break block17;
                        exception = e;
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        };
        this.runBareRunnable((ThrowableRunnable<Throwable>)runnable);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        HeavyPlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(41);
        }
        if (this.runInDispatchThread()) {
            EdtTestUtil.runInEdtAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(42);
        }
        boolean runInCommand = this.annotatedWith(WrapInCommand.class);
        boolean runInWriteAction = this.isRunInWriteAction();
        if (runInCommand && runInWriteAction) {
            WriteCommandAction.writeCommandAction((Project)this.getProject()).run(() -> super.runTestRunnable(testRunnable));
        } else if (runInCommand) {
            Ref e = new Ref();
            CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
                try {
                    super.runTestRunnable(testRunnable);
                }
                catch (Throwable throwable) {
                    e.set((Object)throwable);
                }
            }, null, null);
            if (!e.isNull()) {
                throw (Throwable)e.get();
            }
        } else if (runInWriteAction) {
            WriteAction.runAndWait(() -> super.runTestRunnable(testRunnable));
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(43);
        }
        return this.myProject == null || this.myProject.isDisposed() ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    @NotNull
    protected final File createTempDir(@NotNull String prefix) throws IOException {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(44);
        }
        Path dir = this.temporaryDirectory.newPath(prefix, true);
        Files.createDirectories(dir, new FileAttribute[0]);
        File file2 = dir.toFile();
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(45);
        }
        return file2;
    }

    @NotNull
    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(46);
        }
        VirtualFile virtualFile = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(47);
        }
        return virtualFile;
    }

    @NotNull
    protected final File createTempDirectory() throws IOException {
        return this.createTempDir("");
    }

    @NotNull
    protected final File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(48);
        }
        Path dir = this.temporaryDirectory.newPath("", true);
        Path file2 = dir.resolve(name);
        if (text == null) {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.createFile(file2, new FileAttribute[0]);
        } else {
            PathKt.write((Path)file2, (CharSequence)text);
        }
        File file3 = file2.toFile();
        if (file3 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(49);
        }
        return file3;
    }

    @NotNull
    public VirtualFile createTempVirtualFile(@NonNls @NotNull String fileName, byte @Nullable [] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        if (fileName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(50);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(51);
        }
        if (charset == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(52);
        }
        File file2 = this.createTempFile(fileName, null);
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
        return HeavyPlatformTestCase.getVirtualFile(file2);
    }

    @Nullable
    protected final PsiFile getPsiFile(@NotNull Document document) {
        if (document == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(53);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    private static void setPlatformPrefix(@NotNull String prefix) {
        if (prefix == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(54);
        }
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    @NotNull
    public static VirtualFile createChildData(@NotNull VirtualFile dir, @NotNull String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(55);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(56);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildData((Object)dir, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(57);
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        VirtualFile virtualFile;
        if (dir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(58);
        }
        if (name == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(59);
        }
        try {
            virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> dir.createChildDirectory((Object)dir, name));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(60);
        }
        return virtualFile;
    }

    public static void rename(@NotNull VirtualFile vFile1, @NotNull String newName) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(61);
        }
        if (newName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(62);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.rename((Object)vFile1, newName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void delete(@NotNull VirtualFile file2) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(63);
        }
        VfsTestUtil.deleteFile(file2);
    }

    public static void move(@NotNull VirtualFile vFile1, @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(64);
        }
        if (newFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(65);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> vFile1.move((Object)vFile1, newFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected static VirtualFile copy(@NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(66);
        }
        if (newParent == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(67);
        }
        if (copyName == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(68);
        }
        VirtualFile[] copy = new VirtualFile[1];
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                copy[0] = file2.copy((Object)file2, newParent, copyName);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        VirtualFile virtualFile = copy[0];
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(69);
        }
        return virtualFile;
    }

    public static void copyDirContentsTo(@NotNull VirtualFile vTestRoot, @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(70);
        }
        if (toDir == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(71);
        }
        try {
            WriteCommandAction.writeCommandAction(null).run(() -> {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)file2, (VirtualFile)file2, (VirtualFile)toDir);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFileText(@NotNull VirtualFile file2, @NotNull String text) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(72);
        }
        if (text == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(73);
        }
        try {
            WriteAction.runAndWait(() -> LoadTextUtil.write(null, (VirtualFile)file2, (Object)file2, (String)text, (long)-1L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(74);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(75);
        }
        try {
            WriteAction.runAndWait(() -> file2.setBinaryContent(content));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(@NotNull VirtualFile file2, byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) {
        if (file2 == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(76);
        }
        if (content == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(77);
        }
        try {
            void requestor;
            WriteAction.runAndWait(() -> file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    protected final VirtualFile getOrCreateProjectBaseDir() {
        VirtualFile virtualFile = HeavyTestHelper.getOrCreateProjectBaseDir(this.myProject);
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(78);
        }
        return virtualFile;
    }

    @NotNull
    protected final Path createTempDirectoryWithSuffix(@Nullable String suffix) throws IOException {
        Path path = FileUtilRt.createTempDirectory((String)this.getTestName(true), (String)suffix, (boolean)false).toPath();
        if (path == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(79);
        }
        return path;
    }

    @NotNull
    protected static VirtualFile getOrCreateModuleDir(@NotNull Module module) throws IOException {
        if (module == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(80);
        }
        Path moduleDir = module.getModuleNioFile().getParent();
        Files.createDirectories(moduleDir, new FileAttribute[0]);
        VirtualFile virtualFile = Objects.requireNonNull(LocalFileSystem.getInstance().refreshAndFindFileByNioFile(moduleDir));
        if (virtualFile == null) {
            HeavyPlatformTestCase.$$$reportNull$$$0(81);
        }
        return virtualFile;
    }

    static {
        PREFIX_CANDIDATES = new String[]{"Rider", "GoLand", "CLion", "MobileIDE", null, "AppCode", "SwiftTests", "DataGrip", "Python", "PyCharmDS", "PyCharmCore", "Ruby", "PhpStorm", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temporaryDirectory";
                break;
            }
            case 4: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 9: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 33: 
            case 46: 
            case 63: 
            case 66: 
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "survivors";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 44: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 48: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 51: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile1";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vTestRoot";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDir";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestProjectStructure";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/HeavyPlatformTestCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalTempDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProjectOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateAndOpenProject";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirOrFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainModule";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleAt";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "eternallyLivingFiles";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDir";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateProjectBaseDir";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectoryWithSuffix";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateModuleDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTestProjectStructure";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeTempDirVfs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeGlobalTempDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModule";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRealModuleIn";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createModuleAt";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addSurvivingFiles";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerSurvivor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addSubTree";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runBare";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runBareImpl";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createTempDir";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createTempVirtualFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setPlatformPrefix";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "copyDirContentsTo";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setFileText";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateModuleDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 80: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

