/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.CodeStyleSettingsTracker;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.fixtures.LightIdeaTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import org.jetbrains.annotations.NotNull;

public final class LightIdeaTestFixtureImpl
extends BaseFixture
implements LightIdeaTestFixture {
    private final LightProjectDescriptor myProjectDescriptor;
    private SdkLeakTracker myOldSdks;
    private CodeStyleSettingsTracker myCodeStyleSettingsTracker;
    private Project myProject;
    private Module myModule;
    private final Disposable mySdkParentDisposable;

    public LightIdeaTestFixtureImpl(@NotNull LightProjectDescriptor projectDescriptor) {
        if (projectDescriptor == null) {
            LightIdeaTestFixtureImpl.$$$reportNull$$$0(0);
        }
        this.mySdkParentDisposable = Disposer.newDisposable((String)"sdk for project in light test fixture");
        this.myProjectDescriptor = projectDescriptor;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestApplicationManager application = TestApplicationManager.getInstance();
        Pair.NonNull<Project, Module> setup = LightPlatformTestCase.doSetup(this.myProjectDescriptor, LocalInspectionTool.EMPTY_ARRAY, this.getTestRootDisposable(), this.mySdkParentDisposable);
        this.myProject = (Project)setup.getFirst();
        this.myModule = (Module)setup.getSecond();
        InjectedLanguageManagerImpl.pushInjectors((Project)this.getProject());
        this.myCodeStyleSettingsTracker = new CodeStyleSettingsTracker(this::getCurrentCodeStyleSettings);
        application.setDataProvider(new TestDataProvider(this.getProject()));
        this.myOldSdks = new SdkLeakTracker();
    }

    @Override
    public void tearDown() {
        Project project2 = this.getProject();
        if (project2 != null) {
            CodeStyle.dropTemporarySettings((Project)project2);
        }
        new RunAll(() -> {
            if (this.myCodeStyleSettingsTracker != null) {
                this.myCodeStyleSettingsTracker.checkForSettingsDamage();
            }
        }, () -> {
            if (project2 != null) {
                TestApplicationManagerKt.waitForProjectLeakingThreads(project2);
            }
        }, () -> super.tearDown(), () -> {
            this.myProject = null;
            this.myModule = null;
            if (project2 != null) {
                TestApplicationManagerKt.tearDownProjectAndApp(project2);
            }
        }, () -> LightPlatformTestCase.checkEditorsReleased(), () -> Disposer.dispose((Disposable)this.mySdkParentDisposable), () -> {
            SdkLeakTracker oldSdks = this.myOldSdks;
            if (oldSdks != null) {
                oldSdks.checkForJdkTableLeaks();
            }
        }, () -> {
            if (project2 != null) {
                InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2);
            }
        }, () -> {
            ManagingFS managingFS;
            Application app = ApplicationManager.getApplication();
            if (app != null && (managingFS = (ManagingFS)app.getServiceIfCreated(ManagingFS.class)) != null) {
                ((PersistentFS)managingFS).clearIdCache();
            }
        }, () -> HeavyPlatformTestCase.cleanupApplicationCaches(project2)).run();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    private CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return CodeStyle.createTestSettings();
        }
        return CodeStyle.getSettings((Project)this.getProject());
    }

    @Override
    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDescriptor", "com/intellij/testFramework/fixtures/impl/LightIdeaTestFixtureImpl", "<init>"));
    }
}

