/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.collaboration.auth.AccountManagerBase;
import com.intellij.collaboration.auth.AccountsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.AccountRemovedListener;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GHPersistentAccounts;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \n2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "Lcom/intellij/collaboration/auth/AccountManagerBase;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "()V", "accountsRepository", "Lorg/jetbrains/plugins/github/authentication/accounts/GHPersistentAccounts;", "deserializeCredentials", "credentials", "serializeCredentials", "Companion", "intellij.vcs.github"})
public final class GHAccountManager
extends AccountManagerBase<GithubAccount, String> {
    @NotNull
    private static final Topic<AccountRemovedListener> ACCOUNT_REMOVED_TOPIC;
    @NotNull
    private static final Topic<AccountTokenChangedListener> ACCOUNT_TOKEN_CHANGED_TOPIC;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected GHPersistentAccounts accountsRepository() {
        boolean $i$f$service = false;
        Class<GHPersistentAccounts> serviceClass$iv = GHPersistentAccounts.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        return (GHPersistentAccounts)object;
    }

    @NotNull
    protected String serializeCredentials(@NotNull String credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return credentials;
    }

    @NotNull
    protected String deserializeCredentials(@NotNull String credentials) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        return credentials;
    }

    public GHAccountManager() {
        super("GitHub");
        this.addListener((Disposable)this, (AccountsListener)new AccountsListener<GithubAccount>(){

            public void onAccountListChanged(@NotNull Collection<GithubAccount> old, @NotNull Collection<GithubAccount> collection) {
                Intrinsics.checkNotNullParameter(old, (String)"old");
                Intrinsics.checkNotNullParameter(collection, (String)"new");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                Object object = application.getMessageBus().syncPublisher(Companion.getACCOUNT_REMOVED_TOPIC());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026er(ACCOUNT_REMOVED_TOPIC)");
                AccountRemovedListener removedPublisher = (AccountRemovedListener)object;
                for (GithubAccount account : CollectionsKt.minus((Iterable)old, (Iterable)collection)) {
                    removedPublisher.accountRemoved(account);
                }
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
                Object object2 = application2.getMessageBus().syncPublisher(Companion.getACCOUNT_TOKEN_CHANGED_TOPIC());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ApplicationManager.getAp\u2026OUNT_TOKEN_CHANGED_TOPIC)");
                AccountTokenChangedListener tokenPublisher = (AccountTokenChangedListener)object2;
                for (GithubAccount account : CollectionsKt.minus((Iterable)collection, (Iterable)old)) {
                    tokenPublisher.tokenChanged(account);
                }
            }

            public void onAccountCredentialsChanged(@NotNull GithubAccount account) {
                Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                ((AccountTokenChangedListener)application.getMessageBus().syncPublisher(Companion.getACCOUNT_TOKEN_CHANGED_TOPIC())).tokenChanged(account);
            }
        });
    }

    static {
        Companion = new Companion(null);
        ACCOUNT_REMOVED_TOPIC = new Topic("GITHUB_ACCOUNT_REMOVED", AccountRemovedListener.class);
        ACCOUNT_TOKEN_CHANGED_TOPIC = new Topic("GITHUB_ACCOUNT_TOKEN_CHANGED", AccountTokenChangedListener.class);
    }

    @NotNull
    public static final Topic<AccountRemovedListener> getACCOUNT_REMOVED_TOPIC() {
        Companion companion = Companion;
        return ACCOUNT_REMOVED_TOPIC;
    }

    @NotNull
    public static final Topic<AccountTokenChangedListener> getACCOUNT_TOKEN_CHANGED_TOPIC() {
        Companion companion = Companion;
        return ACCOUNT_TOKEN_CHANGED_TOPIC;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R*\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR*\u0010\n\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u000b0\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager$Companion;", "", "()V", "ACCOUNT_REMOVED_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountRemovedListener;", "kotlin.jvm.PlatformType", "getACCOUNT_REMOVED_TOPIC$annotations", "getACCOUNT_REMOVED_TOPIC", "()Lcom/intellij/util/messages/Topic;", "ACCOUNT_TOKEN_CHANGED_TOPIC", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountTokenChangedListener;", "getACCOUNT_TOKEN_CHANGED_TOPIC$annotations", "getACCOUNT_TOKEN_CHANGED_TOPIC", "createAccount", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "name", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "intellij.vcs.github"})
    public static final class Companion {
        @Deprecated(message="Use TOPIC")
        @JvmStatic
        public static /* synthetic */ void getACCOUNT_REMOVED_TOPIC$annotations() {
        }

        @NotNull
        public final Topic<AccountRemovedListener> getACCOUNT_REMOVED_TOPIC() {
            return ACCOUNT_REMOVED_TOPIC;
        }

        @Deprecated(message="Use TOPIC")
        @JvmStatic
        public static /* synthetic */ void getACCOUNT_TOKEN_CHANGED_TOPIC$annotations() {
        }

        @NotNull
        public final Topic<AccountTokenChangedListener> getACCOUNT_TOKEN_CHANGED_TOPIC() {
            return ACCOUNT_TOKEN_CHANGED_TOPIC;
        }

        @NotNull
        public final GithubAccount createAccount(@NotNull String name, @NotNull GithubServerPath server) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return new GithubAccount(name, server, null, 4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

