/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.RowBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHOAuthService;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUi;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012:\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ,\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dj\u0002`\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\fH\u0016J\f\u0010&\u001a\u00020$*\u00020'H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010RE\u0010\u0004\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GHOAuthCredentialsUi;", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "factory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "getFactory", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "()Lkotlin/jvm/functions/Function2;", "acquireLoginAndToken", "Lkotlin/Pair;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "acquireToken", "createExecutor", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "centerPanel", "Lcom/intellij/ui/layout/LayoutBuilder;", "intellij.vcs.github"})
public final class GHOAuthCredentialsUi
extends GHCredentialsUi {
    @NotNull
    private final GithubApiRequestExecutor.Factory factory;
    @NotNull
    private final Function2<String, GithubServerPath, Boolean> isAccountUnique;

    @Override
    @Nullable
    public JComponent getPreferredFocusableComponent() {
        return null;
    }

    @Override
    @NotNull
    public Function0<ValidationInfo> getValidator() {
        return getValidator.1.INSTANCE;
    }

    @Override
    @NotNull
    public GithubApiRequestExecutor createExecutor() {
        return this.factory.create("");
    }

    @Override
    @NotNull
    public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        GithubApiRequestExecutor.WithTokenAuth cfr_ignored_0 = (GithubApiRequestExecutor.WithTokenAuth)executor;
        String token = this.acquireToken(indicator);
        ((GithubApiRequestExecutor.WithTokenAuth)executor).setToken$intellij_vcs_github(token);
        String login2 = GHTokenCredentialsUi.Companion.acquireLogin(server, executor, indicator, this.isAccountUnique, null);
        return TuplesKt.to((Object)login2, (Object)token);
    }

    @Override
    @NotNull
    public ValidationInfo handleAcquireError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return GHTokenCredentialsUi.Companion.handleError(error);
    }

    @Override
    public void setBusy(boolean busy) {
    }

    @Override
    protected void centerPanel(@NotNull LayoutBuilder $this$centerPanel) {
        Intrinsics.checkNotNullParameter((Object)$this$centerPanel, (String)"$this$centerPanel");
        RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$centerPanel), null, (boolean)false, (Function1)centerPanel.1.INSTANCE, (int)3, null);
    }

    private final String acquireToken(ProgressIndicator indicator) {
        CompletableFuture credentialsFuture = GHOAuthService.Companion.getInstance().authorize();
        try {
            return ((Credentials)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)credentialsFuture, (ProgressIndicator)indicator)).getAccessToken();
        }
        catch (ProcessCanceledException pce) {
            credentialsFuture.completeExceptionally(pce);
            throw (Throwable)pce;
        }
    }

    @NotNull
    public final GithubApiRequestExecutor.Factory getFactory() {
        return this.factory;
    }

    @NotNull
    public final Function2<String, GithubServerPath, Boolean> isAccountUnique() {
        return this.isAccountUnique;
    }

    public GHOAuthCredentialsUi(@NotNull GithubApiRequestExecutor.Factory factory2, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter(isAccountUnique, (String)"isAccountUnique");
        this.factory = factory2;
        this.isAccountUnique = isAccountUnique;
    }
}

