/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.diff.editor.DiffRequestProcessorEditorCustomizer;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.GHNewPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffFileEditor;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHRepoVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPREditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.vcs.github"})
public final class GHPREditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof GHRepoVirtualFile && GHPRDataContextRepository.Companion.getInstance(project).findContext(((GHRepoVirtualFile)file).getRepository()) != null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor fileEditor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        GHRepoVirtualFile cfr_ignored_0 = (GHRepoVirtualFile)file;
        GHPRDataContext gHPRDataContext = GHPRDataContextRepository.Companion.getInstance(project).findContext(((GHRepoVirtualFile)file).getRepository());
        Intrinsics.checkNotNull((Object)gHPRDataContext);
        GHPRDataContext dataContext = gHPRDataContext;
        VirtualFile virtualFile = file;
        if (virtualFile instanceof GHPRVirtualFile) {
            FileEditorBase fileEditorBase;
            boolean bl;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
            Disposable dataDisposable = disposable;
            GHPRDataProvider dataProvider = dataContext.getDataProviderRepository().getDataProvider(((GHPRVirtualFile)file).getPullRequest(), dataDisposable);
            VirtualFile virtualFile2 = file;
            if (virtualFile2 instanceof GHPRDiffVirtualFile) {
                GHPRDiffFileEditor gHPRDiffFileEditor = new GHPRDiffFileEditor(project, dataProvider.getDiffRequestModel(), (GHRepoVirtualFile)file);
                bl = false;
                boolean bl2 = false;
                GHPRDiffFileEditor editor = gHPRDiffFileEditor;
                boolean bl3 = false;
                editor.putUserData(EditorWindow.HIDE_TABS, true);
                DiffRequestProcessorEditorCustomizer.Companion.customize(file, (FileEditor)editor, (DiffRequestProcessor)editor.getDiffProcessor$intellij_vcs_github());
                fileEditorBase = gHPRDiffFileEditor;
            } else if (virtualFile2 instanceof GHPRTimelineVirtualFile) {
                fileEditorBase = new GHPRTimelineFileEditor(project, dataContext, dataProvider, (GHRepoVirtualFile)file);
            } else {
                String string = "Unsupported file type";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            virtualFile2 = fileEditorBase;
            boolean bl5 = false;
            bl = false;
            VirtualFile it = virtualFile2;
            boolean bl6 = false;
            Disposer.register((Disposable)((Disposable)it), (Disposable)dataDisposable);
            fileEditor = (FileEditor)virtualFile2;
        } else if (virtualFile instanceof GHNewPRDiffVirtualFile) {
            GHPRDiffFileEditor gHPRDiffFileEditor = new GHPRDiffFileEditor(project, dataContext.getNewPRDiffModel(), (GHRepoVirtualFile)file);
            boolean bl = false;
            boolean bl7 = false;
            GHPRDiffFileEditor editor = gHPRDiffFileEditor;
            boolean bl8 = false;
            editor.putUserData(EditorWindow.HIDE_TABS, true);
            DiffRequestProcessorEditorCustomizer.Companion.customize(file, (FileEditor)editor, (DiffRequestProcessor)editor.getDiffProcessor$intellij_vcs_github());
            fileEditor = (FileEditor)gHPRDiffFileEditor;
        } else {
            String string = "Unsupported file type";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "GHPR";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

