/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class InjectorMatchingEndFinder {
    public static int findMatchingEnd(@NotNull String startSymbol, @NotNull String endSymbol, @NotNull String text, int afterStartIdx) {
        if (startSymbol == null) {
            InjectorMatchingEndFinder.$$$reportNull$$$0(0);
        }
        if (endSymbol == null) {
            InjectorMatchingEndFinder.$$$reportNull$$$0(1);
        }
        if (text == null) {
            InjectorMatchingEndFinder.$$$reportNull$$$0(2);
        }
        if (afterStartIdx < 0) {
            return -1;
        }
        int totalNumStarts = 1;
        int lookFrom = afterStartIdx;
        while (totalNumStarts > 0) {
            --totalNumStarts;
            int nextEndIdx = text.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text, lookFrom, nextEndIdx, startSymbol);
            if (numStarts > 0) {
                totalNumStarts += numStarts;
            }
            lookFrom = nextEndIdx + endSymbol.length();
            if (totalNumStarts != 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text, int from, int toExcluding, String s) {
        if (text == null) {
            InjectorMatchingEndFinder.$$$reportNull$$$0(3);
        }
        int res = 0;
        int i = from;
        int limit2 = Math.min(text.length(), toExcluding);
        while (i < limit2 && (i = text.indexOf(s, i)) >= 0 && i < limit2) {
            ++res;
            i += s.length();
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/text/InjectorMatchingEndFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMatchingEnd";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOccurrenceCount";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

