/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Graphics2DLog
extends Graphics2D {
    protected final Graphics2D myPeer;

    public Graphics2DLog(Graphics g) {
        this.myPeer = (Graphics2D)g;
    }

    protected void log(@NonNls String msg) {
        System.out.println(msg);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.log(String.format("draw3DRect(%d, %d, %d, %d, %b)", x, y, width, height, raised));
        this.myPeer.draw3DRect(x, y, width, height, raised);
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.log(String.format("fill3DRect(%d, %d, %d, %d, %b)", x, y, width, height, raised));
        this.myPeer.fill3DRect(x, y, width, height, raised);
    }

    @Override
    public void draw(Shape s) {
        this.log("draw(" + s + ")");
        this.myPeer.draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.log("drawImage(Image, AffineTransform, ImageObserver)");
        return this.myPeer.drawImage(img, xform, obs);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.log(String.format("drawImage(BufferedImage, BufferedImageOp, %d, %d)", x, y));
        this.myPeer.drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.log("drawRenderedImage(RenderedImage, AffineTransform)");
        this.myPeer.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.log("drawRenderableImage(RenderableImage, AffineTransform)");
        this.myPeer.drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.log(String.format("drawString(%s, %d, %d)", str, x, y));
        this.myPeer.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.log(String.format("drawString(%s, %f, %f)", str, Float.valueOf(x), Float.valueOf(y)));
        this.myPeer.drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.log(String.format("drawString(%s, %d, %d)", iterator, x, y));
        this.myPeer.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.log(String.format("drawString(%s, %f, %f)", iterator, Float.valueOf(x), Float.valueOf(y)));
        this.myPeer.drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.log(String.format("drawGlyphVector(%s, %f, %f)", g, Float.valueOf(x), Float.valueOf(y)));
        this.myPeer.drawGlyphVector(g, x, y);
    }

    @Override
    public void fill(Shape s) {
        this.log(String.format("fill(%s)", s));
        this.myPeer.fill(s);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.log(String.format("hit(%s, %s, %s)", rect, s, onStroke));
        return this.myPeer.hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.myPeer.getDeviceConfiguration();
    }

    @Override
    public void setComposite(Composite comp) {
        this.log(String.format("setComposite(%s)", comp));
        this.myPeer.setComposite(comp);
    }

    @Override
    public void setPaint(Paint paint) {
        this.log(String.format("setPaint(%s)", paint));
        this.myPeer.setPaint(paint);
    }

    @Override
    public void setStroke(Stroke s) {
        this.log(String.format("setStroke(%s)", s));
        this.myPeer.setStroke(s);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.log(String.format("setRenderingHint(%s, %s)", hintKey, hintValue));
        this.myPeer.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        this.log(String.format("getRenderingHint(%s)", hintKey));
        return this.myPeer.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.log(String.format("setRenderingHints(%s)", hints));
        this.myPeer.setRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.log(String.format("addRenderingHints(%s)", hints));
        this.myPeer.addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        this.log("getRenderingHints()");
        return this.myPeer.getRenderingHints();
    }

    @Override
    public void translate(int x, int y) {
        this.log(String.format("translate(%d, %d)", x, y));
        this.myPeer.translate(x, y);
    }

    @Override
    public void translate(double tx, double ty) {
        this.log(String.format("translate(%f, %f)", tx, ty));
        this.myPeer.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.log(String.format("rotate(%f)", theta));
        this.myPeer.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.log(String.format("rotate(%f, %f, %f)", theta, x, y));
        this.myPeer.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.log(String.format("scale(%f, %f)", sx, sy));
        this.myPeer.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.log(String.format("shear(%f, %f)", shx, shy));
        this.myPeer.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.log(String.format("transform(%s)", Tx));
        this.myPeer.transform(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.log(String.format("setTransform(%s)", Tx));
        this.myPeer.setTransform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return this.myPeer.getTransform();
    }

    @Override
    public Paint getPaint() {
        return this.myPeer.getPaint();
    }

    @Override
    public Composite getComposite() {
        return this.myPeer.getComposite();
    }

    @Override
    public void setBackground(Color color) {
        this.log(String.format("setBackground(%s)", Graphics2DLog.toHex(color)));
        this.myPeer.setBackground(color);
    }

    @Override
    public Color getBackground() {
        return this.myPeer.getBackground();
    }

    @Override
    public Stroke getStroke() {
        return this.myPeer.getStroke();
    }

    @Override
    public void clip(Shape s) {
        this.log(String.format("clip(%s)", s));
        this.myPeer.clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.myPeer.getFontRenderContext();
    }

    @Override
    public Graphics create() {
        return new Graphics2DLog(this.myPeer.create());
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        this.log(String.format("create(%d, %d %d, %d)", x, y, width, height));
        return new Graphics2DLog(this.myPeer.create(x, y, width, height));
    }

    @Override
    public Color getColor() {
        return this.myPeer.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.log(String.format("setColor(%s) alpha=%d", Graphics2DLog.toHex(c), c == null ? 0 : c.getAlpha()));
        this.myPeer.setColor(c);
    }

    @Override
    public void setPaintMode() {
        this.log("setPaintMode()");
        this.myPeer.setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.log(String.format("setXORMode(%s)", Graphics2DLog.toHex(c1)));
        this.myPeer.setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.myPeer.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.log(String.format("setFont(%s)", font));
        this.myPeer.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.myPeer.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.myPeer.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.myPeer.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.log(String.format("clipRect(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.log(String.format("setClip(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        this.log("getClip()");
        return this.myPeer.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.log(String.format("setClip(%s)", clip));
        this.myPeer.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.log(String.format("copyArea(%d, %d, %d, %d, %d, %d)", x, y, width, height, dx, dy));
        this.myPeer.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.log(String.format("drawLine(%d, %d, %d, %d)", x1, y1, x2, y2));
        this.myPeer.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.log(String.format("fillRect(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.fillRect(x, y, width, height);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.log(String.format("drawRect(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.drawRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.log(String.format("clearRect(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.log(String.format("drawRoundRect(%d, %d, %d, %d, %d, %d)", x, y, width, height, arcWidth, arcHeight));
        this.myPeer.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.log(String.format("fillRoundRect(%d, %d, %d, %d, %d, %d)", x, y, width, height, arcWidth, arcHeight));
        this.myPeer.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.log(String.format("drawOval(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.log(String.format("fillOval(%d, %d, %d, %d)", x, y, width, height));
        this.myPeer.fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.myPeer.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.myPeer.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.log("drawPolyline(int[], int[], int)");
        this.myPeer.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.log("drawPolygon(int[], int[], int)");
        this.myPeer.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(Polygon p) {
        this.log("drawPolygon()");
        this.myPeer.drawPolygon(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.log("fillPolygon(int[], int[], int)");
        this.myPeer.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(Polygon p) {
        this.log("fillPolygon(" + p + ")");
        this.myPeer.fillPolygon(p);
    }

    @Override
    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.log("drawChars()");
        this.myPeer.drawChars(data, offset, length, x, y);
    }

    @Override
    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.log("drawBytes");
        this.myPeer.drawBytes(data, offset, length, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img == null) {
            this.log(String.format("drawImage(Image(null), %d, %d, ImageObserver)", x, y));
        } else {
            this.log(String.format("drawImage(Image(%d,%d), %d, %d, ImageObserver)", img.getWidth(null), img.getHeight(null), x, y));
        }
        return this.myPeer.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        this.log("drawImage(Image,int,int,int,int,ImageObserver)");
        return this.myPeer.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        this.log("drawImage(Image,int,int,Color,ImageObserver)");
        return this.myPeer.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        this.log("drawImage(Image,int,int,int,int,Color,ImageObserver)");
        return this.myPeer.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        this.log("drawImage(Image,int,int,int,int,int,int,int,int,ImageObserver)");
        return this.myPeer.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        this.log("drawImage(Image,int,int,int,int,int,int,int,int,Color,ImageObserver)");
        return this.myPeer.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        this.log("dispose()");
        this.myPeer.dispose();
    }

    @Override
    public String toString() {
        return this.myPeer.toString();
    }

    @Override
    @Deprecated
    public Rectangle getClipRect() {
        return this.myPeer.getClipRect();
    }

    @Override
    public boolean hitClip(int x, int y, int width, int height) {
        this.log(String.format("hitClip(%d, %d, %d, %d)", x, y, width, height));
        return this.myPeer.hitClip(x, y, width, height);
    }

    @Override
    public Rectangle getClipBounds(Rectangle r) {
        return this.myPeer.getClipBounds(r);
    }

    @Nullable
    private static String toHex(Color c) {
        return c == null ? null : ColorUtil.toHex(c);
    }
}

