/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.Map;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public final class FontUtil {
    @NotNull
    public static String leftArrow(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(0);
        }
        return FontUtil.canDisplay(font, '\u2190', "<-");
    }

    @NotNull
    @NlsSafe
    public static String rightArrow(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(1);
        }
        return FontUtil.canDisplay(font, '\u2192', "->");
    }

    public static boolean isValidFont(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(2);
        }
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static String upArrow(@NotNull Font font, @NotNull String defaultValue) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(3);
        }
        if (defaultValue == null) {
            FontUtil.$$$reportNull$$$0(4);
        }
        return FontUtil.canDisplay(font, '\u2191', defaultValue);
    }

    @NotNull
    public static String canDisplay(@NotNull Font font, char value, @NotNull String defaultValue) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(5);
        }
        if (defaultValue == null) {
            FontUtil.$$$reportNull$$$0(6);
        }
        String string = font.canDisplay(value) ? String.valueOf(value) : defaultValue;
        if (string == null) {
            FontUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String spaceAndThinSpace() {
        String string = " " + FontUtil.thinSpace();
        if (string == null) {
            FontUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String thinSpace() {
        return FontUtil.canDisplay(StartupUiUtil.getLabelFont(), '\u2009', " ");
    }

    @NotNull
    public static Font minusOne(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(9);
        }
        Font font2 = font.deriveFont((float)font.getSize() - 1.0f);
        if (font2 == null) {
            FontUtil.$$$reportNull$$$0(10);
        }
        return font2;
    }

    @NotNull
    public static Font deriveFont(@NotNull Font oldFont, @NotNull Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        if (oldFont == null) {
            FontUtil.$$$reportNull$$$0(11);
        }
        if (attributes == null) {
            FontUtil.$$$reportNull$$$0(12);
        }
        Font newFont = oldFont.deriveFont(attributes);
        Font font = oldFont instanceof UIResource ? new FontUIResource(newFont) : newFont;
        if (font == null) {
            FontUtil.$$$reportNull$$$0(13);
        }
        return font;
    }

    @NotNull
    public static Font disableKerning(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(14);
        }
        return FontUtil.deriveFont(font, DisableKerning.LAZY);
    }

    @NotNull
    public static Font enableKerning(@NotNull Font font) {
        if (font == null) {
            FontUtil.$$$reportNull$$$0(15);
        }
        return FontUtil.deriveFont(font, EnableKerning.LAZY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/FontUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFont";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/FontUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "canDisplay";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceAndThinSpace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "minusOne";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "leftArrow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rightArrow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidFont";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "upArrow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canDisplay";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "minusOne";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deriveFont";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "disableKerning";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enableKerning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EnableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);

        private EnableKerning() {
        }
    }

    private static final class DisableKerning {
        private static final Map<AttributedCharacterIterator.Attribute, Integer> LAZY = Collections.singletonMap(TextAttribute.KERNING, null);

        private DisableKerning() {
        }
    }
}

