/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore.type;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.jetbrains.mvstore.KeyManager;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.ObjectKeyManager;

final class ContiguousByteArrayKeyManager
implements KeyManager<byte[]> {
    private final int count;
    private final int keyLength;
    private final byte[] data;

    ContiguousByteArrayKeyManager(byte[] data, int count, int keyLength) {
        assert (keyLength * count == data.length);
        this.data = data;
        this.count = count;
        this.keyLength = keyLength;
    }

    @Override
    public int getKeyCount() {
        return this.count;
    }

    @Override
    public byte[] getKey(int index) {
        return Arrays.copyOfRange(this.data, index * this.keyLength, index * this.keyLength + this.keyLength);
    }

    @Override
    public int binarySearch(byte[] key, MVMap<byte[], ?> map2, int initialGuess) {
        int length = this.count;
        if (length == 0) {
            return -1;
        }
        int low = 0;
        int high = length - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        return this.binarySearch(key, low, high, x);
    }

    private int binarySearch(byte[] key, int low, int high, int x) {
        byte[] data = this.data;
        while (low <= high) {
            int xOffset = x * this.keyLength;
            int compare = Arrays.compare(key, 0, this.keyLength, data, xOffset, xOffset + this.keyLength);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    public ObjectKeyManager<byte[]> expandKeys(int extraKeyCount, byte[][] extraKeys, MVMap<byte[], ?> map2) {
        int keyCount = this.count;
        byte[][] newKeys = new byte[keyCount + extraKeyCount][];
        for (int i = 0; i < keyCount; ++i) {
            newKeys[i] = Arrays.copyOfRange(this.data, i * this.keyLength, i * this.keyLength + this.keyLength);
        }
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        return new ObjectKeyManager<byte[]>((K[])newKeys, newKeys.length * this.keyLength);
    }

    @Override
    public KeyManager<byte[]> copy(int startIndex, int endIndex, MVMap<byte[], ?> map2) {
        byte[][] copy = new byte[endIndex - startIndex][];
        for (int i = startIndex; i < endIndex; ++i) {
            copy[i] = Arrays.copyOfRange(this.data, i * this.keyLength, i * this.keyLength + this.keyLength);
        }
        return new ObjectKeyManager<byte[]>((K[])copy, copy.length * this.keyLength);
    }

    @Override
    public KeyManager<byte[]> insertKey(int index, byte[] key, MVMap<byte[], ?> map2) {
        byte[][] copy = new byte[this.count + 1][];
        copy[index] = key;
        for (int i = 0; i < this.count; ++i) {
            copy[i >= index ? i + 1 : i] = Arrays.copyOfRange(this.data, i * this.keyLength, i * this.keyLength + this.keyLength);
        }
        return new ObjectKeyManager<byte[]>((K[])copy, copy.length * this.keyLength);
    }

    @Override
    public KeyManager<byte[]> remove(int index, MVMap<byte[], ?> map2) {
        byte[][] copy = new byte[this.count - 1][];
        for (int i = 0; i < this.count; ++i) {
            if (i == index) continue;
            copy[i > index ? i - 1 : i] = Arrays.copyOfRange(this.data, i * this.keyLength, i * this.keyLength + this.keyLength);
        }
        return new ObjectKeyManager<byte[]>((K[])copy, copy.length * this.keyLength);
    }

    @Override
    public void write(int count, MVMap<byte[], ?> map2, ByteBuf buf) {
        buf.writeBytes(this.data);
    }

    @Override
    public int getSerializedDataSize() {
        return this.data.length;
    }
}

