/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Loader;
import com.intellij.util.lang.ResourceFile;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.lang.ZipResourceFile;
import java.io.IOException;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PathClassLoader
extends UrlClassLoader {
    private static final Function<Path, ResourceFile> RESOURCE_FILE_FACTORY = file -> new ZipResourceFile((Path)file);
    private static final boolean isParallelCapable = PathClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = PathClassLoader.class.getClassLoader();
    private final BytecodeTransformer transformer;

    public PathClassLoader(@NotNull UrlClassLoader.Builder builder) {
        if (builder == null) {
            PathClassLoader.$$$reportNull$$$0(0);
        }
        super(builder, RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = null;
    }

    public static Function<Path, ResourceFile> getResourceFileFactory() {
        return RESOURCE_FILE_FACTORY;
    }

    public PathClassLoader(UrlClassLoader.Builder builder, BytecodeTransformer transformer) {
        super(builder, RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = transformer;
    }

    public PathClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            PathClassLoader.$$$reportNull$$$0(1);
        }
        super(PathClassLoader.createDefaultBuilderForJdk((ClassLoader)parent), RESOURCE_FILE_FACTORY, isParallelCapable);
        this.transformer = null;
        PathClassLoader.registerInClassLoaderValueMap((ClassLoader)parent, (ClassLoader)((Object)this));
        assert (appClassLoader != this);
    }

    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(2);
        }
        if (name.startsWith("com.intellij.util.lang.")) {
            return appClassLoader.loadClass(name);
        }
        return super.findClass(name);
    }

    public boolean isByteBufferSupported(@NotNull String name, @Nullable ProtectionDomain protectionDomain) {
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(3);
        }
        return this.transformer == null || !this.transformer.isApplicable(name, (ClassLoader)((Object)this), protectionDomain);
    }

    protected boolean isPackageDefined(String packageName) {
        return this.getDefinedPackage(packageName) != null;
    }

    public Class<?> consumeClassData(@NotNull String name, byte[] data, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
        byte[] transformedData;
        if (name == null) {
            PathClassLoader.$$$reportNull$$$0(4);
        }
        if (this.transformer != null && this.transformer.isApplicable(name, (ClassLoader)((Object)this), protectionDomain) && (transformedData = this.transformer.transform((ClassLoader)((Object)this), name, protectionDomain, data)) != null) {
            return super.consumeClassData(name, transformedData, loader, protectionDomain);
        }
        return super.consumeClassData(name, data, loader, protectionDomain);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/PathClassLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isByteBufferSupported";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeClassData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BytecodeTransformer {
        default public boolean isApplicable(String className, ClassLoader loader, @Nullable ProtectionDomain protectionDomain) {
            return true;
        }

        public byte[] transform(ClassLoader var1, String var2, @Nullable ProtectionDomain var3, byte[] var4);
    }
}

