/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sh.ShBundle;
import com.intellij.sh.ShFileType;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.codeStyle.ShCodeStyleSettings;
import com.intellij.sh.formatter.ShShfmtFormatterUtil;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.sh.psi.ShFile;
import com.intellij.sh.settings.ShSettings;
import com.intellij.util.SmartList;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShExternalFormatter
extends AsyncDocumentFormattingService {
    private static final Logger LOG = Logger.getInstance(ShExternalFormatter.class);
    @NonNls
    private static final List<String> KNOWN_SHELLS = Arrays.asList("bash", "posix", "mksh");
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.noneOf(FormattingService.Feature.class);

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            ShExternalFormatter.$$$reportNull$$$0(0);
        }
        return file instanceof ShFile;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            ShExternalFormatter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    protected String getNotificationGroupId() {
        String string = ShLanguage.NOTIFICATION_GROUP_ID;
        if (string == null) {
            ShExternalFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String getName() {
        String string = ShBundle.message("sh.shell.script", new Object[0]);
        if (string == null) {
            ShExternalFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(final @NotNull AsyncFormattingRequest request) {
        if (request == null) {
            ShExternalFormatter.$$$reportNull$$$0(4);
        }
        FormattingContext formattingContext = request.getContext();
        Project project = formattingContext.getProject();
        String shFmtExecutable = ShSettings.getShfmtPath();
        if (!ShShfmtFormatterUtil.isValidPath(shFmtExecutable)) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Notification notification = new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.install.question", new Object[0]), NotificationType.INFORMATION);
                notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.install", new Object[0]), () -> {
                    notification.expire();
                    ShShfmtFormatterUtil.download(formattingContext.getProject(), () -> Notifications.Bus.notify((Notification)new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.success.install", new Object[0]), NotificationType.INFORMATION)), () -> Notifications.Bus.notify((Notification)new Notification(ShLanguage.NOTIFICATION_GROUP_ID, ShBundle.message("sh.shell.script", new Object[0]), ShBundle.message("sh.fmt.cannot.download", new Object[0]), NotificationType.ERROR)));
                }));
                notification.addAction((AnAction)NotificationAction.createSimple(ShBundle.messagePointer("sh.no.thanks", new Object[0]), () -> {
                    notification.expire();
                    ShSettings.setShfmtPath(ShSettings.I_DO_MIND_SUPPLIER.get());
                }));
                Notifications.Bus.notify((Notification)notification, (Project)project);
            }
            return null;
        }
        ShShfmtFormatterUtil.checkShfmtForUpdate(project);
        String interpreter = ShShebangParserUtil.getInterpreter((ShFile)formattingContext.getContainingFile(), KNOWN_SHELLS, "bash");
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        ShCodeStyleSettings shSettings = (ShCodeStyleSettings)settings.getCustomSettings(ShCodeStyleSettings.class);
        if (ShSettings.I_DO_MIND_SUPPLIER.get().equals(shFmtExecutable)) {
            return null;
        }
        File ioFile = request.getIOFile();
        if (ioFile == null) {
            return null;
        }
        @NonNls SmartList params = new SmartList();
        params.add("-ln=" + interpreter);
        if (!settings.getIndentOptions((FileType)ShFileType.INSTANCE).USE_TAB_CHARACTER) {
            int tabSize = settings.getIndentOptions((FileType)ShFileType.INSTANCE).INDENT_SIZE;
            params.add("-i=" + tabSize);
        }
        if (shSettings.BINARY_OPS_START_LINE) {
            params.add("-bn");
        }
        if (shSettings.SWITCH_CASES_INDENTED) {
            params.add("-ci");
        }
        if (shSettings.REDIRECT_FOLLOWED_BY_SPACE) {
            params.add("-sr");
        }
        if (shSettings.KEEP_COLUMN_ALIGNMENT_PADDING) {
            params.add("-kp");
        }
        if (shSettings.MINIFY_PROGRAM) {
            params.add("-mn");
        }
        params.add(ioFile.getPath());
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withExePath(shFmtExecutable).withParameters((List)params);
            final OSProcessHandler handler = new OSProcessHandler(commandLine.withCharset(StandardCharsets.UTF_8));
            return new AsyncDocumentFormattingService.FormattingTask(){

                public void run() {
                    handler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            int exitCode;
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((exitCode = event.getExitCode()) == 0) {
                                request.onTextReady(this.getOutput().getStdout());
                            } else {
                                request.onError(ShBundle.message("sh.shell.script", new Object[0]), this.getOutput().getStderr());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/formatter/ShExternalFormatter$1$1", "processTerminated"));
                        }
                    });
                    handler.startNotify();
                }

                public boolean cancel() {
                    handler.destroyProcess();
                    return true;
                }

                public boolean isRunUnderProgress() {
                    return true;
                }
            };
        }
        catch (ExecutionException e) {
            request.onError(ShBundle.message("sh.shell.script", new Object[0]), e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShExternalFormatter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShExternalFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroupId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

