/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigPattern;
import org.editorconfig.language.psi.EditorConfigPatternEnumeration;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveBracesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigRemoveBracesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.pattern-enumeration.redundant.remove-braces.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        TextRange range;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (!(psiElement instanceof EditorConfigPatternEnumeration)) {
            psiElement = null;
        }
        EditorConfigPatternEnumeration editorConfigPatternEnumeration = (EditorConfigPatternEnumeration)psiElement;
        if (editorConfigPatternEnumeration == null) {
            return;
        }
        EditorConfigPatternEnumeration patternEnumeration = editorConfigPatternEnumeration;
        List<EditorConfigPattern> list = patternEnumeration.getPatternList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"patternEnumeration.patternList");
        EditorConfigPattern pattern = (EditorConfigPattern)CollectionsKt.single(list);
        EditorConfigHeader header = patternEnumeration.getHeader();
        TextRange textRange = header.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"header.textRange");
        int headerStart = textRange.getStartOffset();
        TextRange textRange2 = range = patternEnumeration.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"range");
        IntRange actualRange = RangesKt.until((int)(textRange2.getStartOffset() - headerStart), (int)(range.getEndOffset() - headerStart));
        String string = header.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.text");
        CharSequence text = string;
        EditorConfigPattern editorConfigPattern = pattern;
        Intrinsics.checkNotNullExpressionValue((Object)editorConfigPattern, (String)"pattern");
        String string2 = editorConfigPattern.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pattern.text");
        CharSequence newText = StringsKt.replaceRange((CharSequence)text, (IntRange)actualRange, (CharSequence)string2);
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigHeader newHeader = factory.createHeader(newText);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(header, newHeader){
            final /* synthetic */ EditorConfigHeader $header;
            final /* synthetic */ EditorConfigHeader $newHeader;

            public final void run() {
                this.$header.replace(this.$newHeader);
            }
            {
                this.$header = editorConfigHeader;
                this.$newHeader = editorConfigHeader2;
            }
        });
    }
}

