/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.psi.EditorConfigElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001d\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/psi/EditorConfigTokenSeparatorGenerator;", "Lcom/intellij/lang/TokenSeparatorGenerator;", "()V", "createLineBreak", "Lcom/intellij/psi/impl/source/tree/LeafElement;", "Lorg/jetbrains/annotations/NotNull;", "manager", "Lcom/intellij/psi/PsiManager;", "createWhitespace", "text", "", "generateWhitespaceBetweenTokens", "Lcom/intellij/lang/ASTNode;", "left", "right", "intellij.editorconfig"})
public final class EditorConfigTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    @Nullable
    public ASTNode generateWhitespaceBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        ASTNode aSTNode = right.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"right.treeParent");
        PsiElement psiElement = aSTNode.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"right.treeParent.psi");
        PsiManager manager = psiElement.getManager();
        if (Intrinsics.areEqual((Object)left.getElementType(), (Object)EditorConfigElementTypes.LINE_COMMENT)) {
            PsiManager psiManager = manager;
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"manager");
            return (ASTNode)this.createLineBreak(psiManager);
        }
        return null;
    }

    private final LeafElement createLineBreak(PsiManager manager) {
        return this.createWhitespace(manager, "\n");
    }

    private final LeafElement createWhitespace(PsiManager manager, String text) {
        LeafElement leafElement = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)text, (int)0, (int)text.length(), null, (PsiManager)manager);
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"Factory.createSingleLeaf\u2026xt.length, null, manager)");
        return leafElement;
    }
}

