/*
 * Decompiled with CFR 0.152.
 */
package training.lang;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowAnchor;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.AbstractLangSupport;
import training.lang.LangSupport;
import training.learn.exceptons.NoSdkException;
import training.project.FileUtils;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J=\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u00102!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\f0\"H\u0016J\b\u0010&\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Ltraining/lang/AbstractLangSupport;", "Ltraining/lang/LangSupport;", "()V", "defaultProjectName", "", "getDefaultProjectName", "()Ljava/lang/String;", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "applyProjectSdk", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "cleanupBeforeLessons", "copyGeneratedFiles", "projectDirectory", "Ljava/io/File;", "destinationFilter", "Ljava/io/FileFilter;", "copyLearningProjectFiles", "", "getProjectFilePath", "projectName", "getSdkForProject", "selectedSdk", "installAndOpenLearningProject", "projectPath", "Ljava/nio/file/Path;", "projectToClose", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "toString", "intellij.featuresTrainer"})
public abstract class AbstractLangSupport
implements LangSupport {
    @Nullable
    private final ReadMeCreator readMeCreator;

    @Override
    @NotNull
    public String getDefaultProjectName() {
        return "LearnProject";
    }

    @Override
    @NotNull
    public String getProjectFilePath(@NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        return ProjectUtil.getBaseDir() + File.separator + projectName;
    }

    @Override
    public void installAndOpenLearningProject(@NotNull Path projectPath, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(projectPath, this, new OpenProjectTask(false, projectToClose, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048573, null), postInitCallback);
    }

    @Override
    public boolean copyLearningProjectFiles(@NotNull File projectDirectory, @Nullable FileFilter destinationFilter) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        URL inputUrl = ProjectUtils.INSTANCE.learningProjectUrl(this);
        boolean bl = FileUtils.INSTANCE.copyResourcesRecursively(inputUrl, projectDirectory, destinationFilter);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        if (it) {
            this.copyGeneratedFiles(projectDirectory, destinationFilter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyGeneratedFiles(File projectDirectory, FileFilter destinationFilter) {
        ReadMeCreator generator = this.getReadMeCreator();
        if (generator != null) {
            File readme = new File(projectDirectory, "README.md");
            if (destinationFilter == null || destinationFilter.accept(readme)) {
                Closeable closeable = new PrintWriter(readme, StandardCharsets.UTF_8);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    PrintWriter it = (PrintWriter)closeable;
                    boolean bl3 = false;
                    it.print(generator.createReadmeMdText());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    @Nullable
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    @Override
    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            this.checkSdk(null, project);
            return null;
        }
        catch (Throwable throwable) {
            return (Sdk)ApplicationManager.getApplication().runReadAction(new ThrowableComputable(this, project){
                final /* synthetic */ AbstractLangSupport this$0;
                final /* synthetic */ Project $project;

                public final Sdk compute() {
                    Sdk sdkOrNull;
                    Sdk sdk;
                    block4: {
                        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)projectJdkTable, (String)"ProjectJdkTable.getInstance()");
                        Sdk[] sdkArray = projectJdkTable.getAllJdks();
                        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"ProjectJdkTable.getInstance().allJdks");
                        Sdk[] sdkArray2 = sdkArray;
                        boolean bl = false;
                        Sdk[] sdkArray3 = sdkArray2;
                        boolean bl2 = false;
                        Sdk[] sdkArray4 = sdkArray3;
                        int n = sdkArray4.length;
                        for (int j = 0; j < n; ++j) {
                            boolean bl3;
                            Sdk sdk2;
                            Sdk it = sdk2 = sdkArray4[j];
                            boolean bl4 = false;
                            try {
                                this.this$0.checkSdk(it, this.$project);
                                bl3 = true;
                            }
                            catch (Throwable e) {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            sdk = sdk2;
                            break block4;
                        }
                        sdk = null;
                    }
                    Sdk sdk3 = sdkOrNull = sdk;
                    if (sdk3 == null) {
                        throw (Throwable)new NoSdkException();
                    }
                    return sdk3;
                }
                {
                    this.this$0 = abstractLangSupport;
                    this.$project = project;
                }
            });
        }
    }

    @Override
    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommandProcessor.getInstance().executeCommand(project, new Runnable(project, sdk){
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $sdk;

            public final void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ applyProjectSdk.1 this$0;

                    public final void run() {
                        ProjectRootManagerEx rootManager;
                        ProjectRootManagerEx projectRootManagerEx = rootManager = ProjectRootManagerEx.getInstanceEx((Project)this.this$0.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)projectRootManagerEx, (String)"rootManager");
                        projectRootManagerEx.setProjectSdk(this.this$0.$sdk);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
                this.$sdk = sdk;
            }
        }, null, null);
    }

    @Override
    public void cleanupBeforeLessons(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectUtils.INSTANCE.restoreProject(this, project);
    }

    @NotNull
    public String toString() {
        return this.getPrimaryLanguage();
    }

    @Override
    @Nullable
    public String getDefaultProductName() {
        return LangSupport.DefaultImpls.getDefaultProductName(this);
    }

    @Override
    @NotNull
    public String getFilename() {
        return LangSupport.DefaultImpls.getFilename(this);
    }

    @Override
    @Nullable
    public String getLangCourseFeedback() {
        return LangSupport.DefaultImpls.getLangCourseFeedback(this);
    }

    @Override
    @NotNull
    public String getProjectResourcePath() {
        return LangSupport.DefaultImpls.getProjectResourcePath(this);
    }

    @Override
    @Nullable
    public String getProjectSandboxRelativePath() {
        return LangSupport.DefaultImpls.getProjectSandboxRelativePath(this);
    }

    @Override
    @NotNull
    public ToolWindowAnchor getToolWindowAnchor() {
        return LangSupport.DefaultImpls.getToolWindowAnchor(this);
    }

    @Override
    public boolean blockProjectFileModification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return LangSupport.DefaultImpls.blockProjectFileModification(this, project, file);
    }

    @Override
    public void startFromWelcomeFrame(@NotNull Function1<? super Sdk, Unit> startCallback) {
        Intrinsics.checkNotNullParameter(startCallback, (String)"startCallback");
        LangSupport.DefaultImpls.startFromWelcomeFrame(this, startCallback);
    }
}

