/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.util.ui.TimerUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.ui.GlassHighlightComponent;
import training.ui.LearningUiHighlightingManager;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020$J\b\u0010'\u001a\u00020\u001cH\u0002R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltraining/ui/RepaintHighlighting;", "T", "Ljava/awt/Component;", "", "original", "glassPane", "Ljavax/swing/JComponent;", "options", "Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "rectangle", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljavax/swing/JComponent;Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;Lkotlin/jvm/functions/Function0;)V", "cellBoundsInList", "highlightComponent", "Ltraining/ui/GlassHighlightComponent;", "listLocationOnScreen", "Ljava/awt/Point;", "getOptions", "()Ltraining/ui/LearningUiHighlightingManager$HighlightingOptions;", "getOriginal", "()Ljava/awt/Component;", "Ljava/awt/Component;", "pulsationOffset", "", "getRectangle", "()Lkotlin/jvm/functions/Function0;", "removed", "", "getRemoved", "()Z", "setRemoved", "(Z)V", "startDate", "Ljava/util/Date;", "cleanup", "", "initTimer", "reinitHighlightComponent", "shouldReinit", "intellij.featuresTrainer"})
public final class RepaintHighlighting<T extends Component> {
    private boolean removed;
    private final Date startDate;
    private Point listLocationOnScreen;
    private Rectangle cellBoundsInList;
    private GlassHighlightComponent highlightComponent;
    private final int pulsationOffset;
    @NotNull
    private final T original;
    private final JComponent glassPane;
    @NotNull
    private final LearningUiHighlightingManager.HighlightingOptions options;
    @NotNull
    private final Function0<Rectangle> rectangle;

    public final boolean getRemoved() {
        return this.removed;
    }

    public final void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public final void initTimer() {
        Timer timer = TimerUtil.createNamedTimer((String)"IFT item", (int)50);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"TimerUtil.createNamedTimer(\"IFT item\", 50)");
        Timer timer2 = timer;
        timer2.addActionListener(new ActionListener(this, timer2){
            final /* synthetic */ RepaintHighlighting this$0;
            final /* synthetic */ Timer $timer;

            public final void actionPerformed(ActionEvent it) {
                if (!((Component)this.this$0.getOriginal()).isShowing()) {
                    LearningUiHighlightingManager.INSTANCE.removeIt$intellij_featuresTrainer(this.this$0);
                }
                if (this.this$0.getRemoved()) {
                    this.$timer.stop();
                    return;
                }
                if (RepaintHighlighting.access$shouldReinit(this.this$0)) {
                    this.this$0.cleanup();
                    RepaintHighlighting.access$setHighlightComponent$p(this.this$0, null);
                    this.this$0.reinitHighlightComponent();
                }
                RepaintHighlighting.access$getGlassPane$p(this.this$0).repaint();
            }
            {
                this.this$0 = repaintHighlighting;
                this.$timer = timer;
            }
        });
        timer2.start();
    }

    public final void cleanup() {
        GlassHighlightComponent glassHighlightComponent = this.highlightComponent;
        if (glassHighlightComponent != null) {
            GlassHighlightComponent glassHighlightComponent2 = glassHighlightComponent;
            boolean bl = false;
            boolean bl2 = false;
            GlassHighlightComponent it = glassHighlightComponent2;
            boolean bl3 = false;
            this.glassPane.remove(it);
        }
        if (this.glassPane.isValid()) {
            this.glassPane.revalidate();
            this.glassPane.repaint();
        }
    }

    private final boolean shouldReinit() {
        return this.highlightComponent == null || Intrinsics.areEqual((Object)((Component)this.original).getLocationOnScreen(), (Object)this.listLocationOnScreen) ^ true || Intrinsics.areEqual((Object)((Rectangle)this.rectangle.invoke()), (Object)this.cellBoundsInList) ^ true;
    }

    public final void reinitHighlightComponent() {
        Rectangle rectangle = (Rectangle)this.rectangle.invoke();
        if (rectangle == null) {
            return;
        }
        Rectangle cellBounds = rectangle;
        GlassHighlightComponent newHighlightComponent = new GlassHighlightComponent(this.startDate, this.options);
        Point pt = SwingUtilities.convertPoint(this.original, cellBounds.getLocation(), this.glassPane);
        Rectangle bounds = new Rectangle(pt.x - this.pulsationOffset, pt.y - this.pulsationOffset, cellBounds.width + 2 * this.pulsationOffset, cellBounds.height + 2 * this.pulsationOffset);
        newHighlightComponent.setBounds(bounds);
        this.glassPane.add(newHighlightComponent);
        this.highlightComponent = newHighlightComponent;
        this.listLocationOnScreen = ((Component)this.original).getLocationOnScreen();
        this.cellBoundsInList = cellBounds;
    }

    @NotNull
    public final T getOriginal() {
        return this.original;
    }

    @NotNull
    public final LearningUiHighlightingManager.HighlightingOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final Function0<Rectangle> getRectangle() {
        return this.rectangle;
    }

    public RepaintHighlighting(@NotNull T original, @NotNull JComponent glassPane, @NotNull LearningUiHighlightingManager.HighlightingOptions options, @NotNull Function0<? extends Rectangle> rectangle) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)glassPane, (String)"glassPane");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(rectangle, (String)"rectangle");
        this.original = original;
        this.glassPane = glassPane;
        this.options = options;
        this.rectangle = rectangle;
        this.startDate = new Date();
        this.pulsationOffset = this.options.getUsePulsation() ? 20 : 0;
    }

    public static final /* synthetic */ boolean access$shouldReinit(RepaintHighlighting $this) {
        return $this.shouldReinit();
    }

    public static final /* synthetic */ GlassHighlightComponent access$getHighlightComponent$p(RepaintHighlighting $this) {
        return $this.highlightComponent;
    }

    public static final /* synthetic */ void access$setHighlightComponent$p(RepaintHighlighting $this, GlassHighlightComponent glassHighlightComponent) {
        $this.highlightComponent = glassHighlightComponent;
    }

    public static final /* synthetic */ JComponent access$getGlassPane$p(RepaintHighlighting $this) {
        return $this.glassPane;
    }
}

