/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.AnonymizedIdsCache;
import com.intellij.internal.statistic.eventLog.AtomicLazyValue;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.messages.Topic;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000f\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u001a\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\u0003H\u0002J\r\u0010\u0017\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020\u0019H\u0002J\f\u0010%\u001a\u00020\n*\u00020\u0003H\u0002J\f\u0010&\u001a\u00020\u0003*\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006("}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "eventLogConfiguration", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;)V", "anonymizedCache", "Lcom/intellij/internal/statistic/eventLog/AnonymizedIdsCache;", "bucket", "", "getBucket", "()I", "deviceId", "getDeviceId", "()Ljava/lang/String;", "machineId", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "getMachineId", "()Lcom/intellij/internal/statistic/eventLog/MachineId;", "machineIdReference", "Lcom/intellij/internal/statistic/eventLog/AtomicLazyValue;", "maxFilesToSend", "getMaxFilesToSend", "salt", "", "sessionId", "getSessionId", "anonymize", "data", "generateMachineId", "machineIdSalt", "value", "generateSessionId", "getMaxFilesToSend$intellij_platform_statistics", "getOrGenerateDeviceId", "getOrGenerateSalt", "asBucket", "shortedUUID", "Companion", "intellij.platform.statistics"})
public final class EventLogRecorderConfiguration {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String deviceId;
    private final int bucket;
    private final byte[] salt;
    private final AnonymizedIdsCache anonymizedCache;
    private final AtomicLazyValue<MachineId> machineIdReference;
    private final int maxFilesToSend;
    private final String recorderId;
    private final EventLogConfiguration eventLogConfiguration;
    private static final int DEFAULT_MAX_FILES_TO_SEND = 5;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final MachineId getMachineId() {
        return this.machineIdReference.getValue();
    }

    public final int getMaxFilesToSend() {
        return this.maxFilesToSend;
    }

    private final MachineId generateMachineId(String machineIdSalt, int value) {
        String salt;
        String string = machineIdSalt;
        if (string == null) {
            string = salt = "";
        }
        if (Intrinsics.areEqual((Object)salt, (Object)"disabled")) {
            return MachineId.DISABLED;
        }
        int revision = value >= 0 ? value : 0;
        String machineId = MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrains" + this.recorderId, salt);
        if (machineId == null) {
            return MachineId.UNKNOWN;
        }
        return new MachineId(machineId, revision);
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        return this.anonymizedCache.computeIfAbsent(data, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ EventLogRecorderConfiguration this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return EventLogConfiguration.Companion.hashSha256(EventLogRecorderConfiguration.access$getSalt$p(this.this$0), it);
            }
            {
                this.this$0 = eventLogRecorderConfiguration;
                super(1);
            }
        }));
    }

    private final String shortedUUID(String $this$shortedUUID) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $this$shortedUUID.length()) {
            String string = $this$shortedUUID;
            int n = start + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $this$shortedUUID;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String generateSessionId() {
        String presentableHour = StatisticsUtil.getCurrentHourInUTC$default(StatisticsUtil.INSTANCE, null, 1, null);
        StringBuilder stringBuilder = new StringBuilder().append(presentableHour).append('-');
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        return stringBuilder.append(this.shortedUUID(string)).toString();
    }

    private final String getOrGenerateDeviceId() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = this.eventLogConfiguration.getHeadlessDeviceIdProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        try {
            String string = DeviceIdManager.getOrGenerateId(new DeviceIdManager.DeviceIdToken(){}, this.recorderId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DeviceIdManager.getOrGen\u2026ceIdToken {}, recorderId)");
            return string;
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            EventLogConfiguration.Companion.getLOG$intellij_platform_statistics().warn("Failed retrieving device id for " + this.recorderId);
            return "000000000000000-0000-0000-0000-000000000000";
        }
    }

    private final byte[] getOrGenerateSalt() {
        String string;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = this.eventLogConfiguration.getHeadlessSaltProperty$intellij_platform_statistics(this.recorderId);
            String string2 = System.getProperty(property);
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                String string4 = it;
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string5.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return byArray;
            }
        }
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"ApplicationInfoImpl.getShadowInstance()");
        String companyName = applicationInfoEx.getShortCompanyName();
        if (StringUtil.isEmptyOrSpaces((String)companyName)) {
            string = "jetbrains";
        } else {
            String string6 = companyName;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"companyName");
            String string7 = string6;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean it = false;
            String string8 = string7;
            boolean bl = false;
            String string9 = string8;
            if (string9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string10 = string9.toLowerCase(locale2);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase(locale)");
        }
        String name = string;
        Preferences prefs = Preferences.userRoot().node(name);
        String saltKey = this.eventLogConfiguration.getSaltPropertyKey$intellij_platform_statistics(this.recorderId);
        byte[] salt = prefs.getByteArray(saltKey, null);
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
            prefs.putByteArray(saltKey, salt);
            EventLogConfiguration.Companion.getLOG$intellij_platform_statistics().info("Generating new salt for " + this.recorderId);
        }
        return salt;
    }

    public final int getMaxFilesToSend$intellij_platform_statistics() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            Integer value;
            String property = this.eventLogConfiguration.getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            Integer n = value = string != null ? StringsKt.toIntOrNull((String)string) : null;
            if (value != null && (value == -1 || value >= 0)) {
                return value;
            }
        }
        return 5;
    }

    public EventLogRecorderConfiguration(@NotNull String recorderId, @NotNull EventLogConfiguration eventLogConfiguration) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)eventLogConfiguration, (String)"eventLogConfiguration");
        this.recorderId = recorderId;
        this.eventLogConfiguration = eventLogConfiguration;
        this.sessionId = this.generateSessionId();
        this.deviceId = this.getOrGenerateDeviceId();
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt();
        this.anonymizedCache = new AnonymizedIdsCache();
        this.maxFilesToSend = this.getMaxFilesToSend$intellij_platform_statistics();
        EventLogOptions eventLogOptions = EventLogConfigOptionsService.getInstance().getOptions(this.recorderId);
        Intrinsics.checkNotNullExpressionValue((Object)eventLogOptions, (String)"EventLogConfigOptionsSer\u2026().getOptions(recorderId)");
        final EventLogOptions configOptions = eventLogOptions;
        this.machineIdReference = new AtomicLazyValue((Function0)new Function0<MachineId>(){

            @NotNull
            public final MachineId invoke() {
                return this.generateMachineId(configOptions.getMachineIdSalt(), configOptions.getMachineIdRevision());
            }
        });
        Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"EventLogConfigOptionsService.TOPIC");
        Topics.subscribe(topic, null, (Object)new EventLogRecorderConfigOptionsListener(this.recorderId){

            @Override
            public void onMachineIdConfigurationChanged(@Nullable String salt, int revision) {
                machineIdReference.updateAndGet((Function1)new Function1<MachineId, MachineId>(this, salt, revision){
                    final /* synthetic */ 2 this$0;
                    final /* synthetic */ String $salt;
                    final /* synthetic */ int $revision;

                    @NotNull
                    public final MachineId invoke(@NotNull MachineId prevValue) {
                        Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
                        return this.$salt != null && this.$revision != -1 && this.$revision > prevValue.getRevision() ? EventLogRecorderConfiguration.access$generateMachineId(this.this$0.this, this.$salt, this.$revision) : prevValue;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$salt = string;
                        this.$revision = n;
                        super(1);
                    }
                });
            }
        });
    }

    public static final /* synthetic */ byte[] access$getSalt$p(EventLogRecorderConfiguration $this) {
        return $this.salt;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration$Companion;", "", "()V", "DEFAULT_MAX_FILES_TO_SEND", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

