/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "Companion", "intellij.grazie.core"})
public final class GrazieInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.INSTANCE.message("grazie.grammar.inspection.grammar.text", new String[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"holder.file");
        PsiFile file2 = psiFile;
        if (Companion.ignoreGrammarChecking(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        List<TextChecker> checkers = TextChecker.allCheckers();
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        Language fileLanguage = language;
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker$intellij_grazie_core(fileLanguage);
        return new PsiElementVisitor(areChecksDisabled, checkedDomains, checkers, isOnTheFly, holder){
            final /* synthetic */ Function1 $areChecksDisabled;
            final /* synthetic */ Set $checkedDomains;
            final /* synthetic */ List $checkers;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiWhiteSpace || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                TextContent textContent = TextExtractor.findUniqueTextAt(element, this.$checkedDomains);
                if (textContent == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"TextExtractor.findUnique\u2026checkedDomains) ?: return");
                TextContent extracted = textContent;
                if (extracted.length() > 50000) {
                    return;
                }
                CheckerRunner runner = new CheckerRunner(extracted);
                List list = this.$checkers;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"checkers");
                List<ProblemDescriptor> warnings = runner.toProblemDescriptors(runner.run(list), this.$isOnTheFly);
                Iterable iterable = warnings;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ProblemDescriptor p1 = (ProblemDescriptor)element$iv;
                    boolean bl = false;
                    problemsHolder.registerProblem(p1);
                }
            }
            {
                this.$areChecksDisabled = $captured_local_variable$0;
                this.$checkedDomains = $captured_local_variable$1;
                this.$checkers = $captured_local_variable$2;
                this.$isOnTheFly = $captured_local_variable$3;
                this.$holder = $captured_local_variable$4;
            }
        };
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J!\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "()V", "checkedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "", "fileLanguage", "Lcom/intellij/lang/Language;", "getDisabledChecker$intellij_grazie_core", "ignoreGrammarChecking", "file", "Lcom/intellij/psi/PsiFile;", "intellij.grazie.core"})
    public static final class Companion {
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file2);
        }

        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            EnumSet<Enum> result2 = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result2.add(TextContent.TextDomain.LITERALS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInCommentsEnabled()) {
                result2.add(TextContent.TextDomain.COMMENTS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInDocumentationEnabled()) {
                result2.add(TextContent.TextDomain.DOCUMENTATION);
            }
            EnumSet<Enum> enumSet = result2;
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"result");
            return enumSet;
        }

        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker$intellij_grazie_core(@NotNull Language fileLanguage) {
            Intrinsics.checkNotNullParameter((Object)fileLanguage, (String)"fileLanguage");
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return (Function1)new Function1<PsiElement, Boolean>(fileLanguage, supportedLanguages, disabledLanguages){
                final /* synthetic */ Language $fileLanguage;
                final /* synthetic */ Set $supportedLanguages;
                final /* synthetic */ Set $disabledLanguages;

                public final boolean invoke(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Language lang = element.getLanguage();
                    if (this.$fileLanguage.isKindOf(lang)) {
                        lang = this.$fileLanguage;
                    }
                    while (lang != null && !this.$supportedLanguages.contains(lang)) {
                        lang = lang.getBaseLanguage();
                    }
                    return lang != null && this.$disabledLanguages.contains(lang.getID());
                }
                {
                    this.$fileLanguage = language;
                    this.$supportedLanguages = set;
                    this.$disabledLanguages = set2;
                    super(1);
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

