/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.properties;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyTextExtractor
extends TextExtractor {
    private static final Pattern apostrophes = Pattern.compile("'(?=')");

    @Override
    @Nullable
    public TextContent buildTextContent(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            PropertyTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            PropertyTextExtractor.$$$reportNull$$$0(1);
        }
        if (root instanceof PsiComment) {
            List<PsiElement> roots = PsiUtilsKt.getNotSoDistantSimilarSiblings(root, (Function1<? super PsiElement, Boolean>)((Function1)e -> PropertiesTokenTypes.COMMENTS.contains(PsiUtilCore.getElementType((PsiElement)e))));
            return TextContent.joinWithWhitespace(ContainerUtil.mapNotNull(roots, c -> TextContentBuilder.FromPsi.removingIndents(" \t#!").build((PsiElement)c, TextContent.TextDomain.COMMENTS)));
        }
        if (PsiUtilCore.getElementType((PsiElement)root) == PropertiesTokenTypes.VALUE_CHARACTERS) {
            String str;
            int start;
            TextContent content2 = TextContent.builder().build(root, TextContent.TextDomain.PLAIN_TEXT);
            if (content2 != null) {
                content2 = content2.excludeRanges(ContainerUtil.map(Text.allOccurrences(apostrophes, content2), TextContent.Exclusion::exclude));
            }
            while (content2 != null && (start = (str = content2.toString()).indexOf("{")) >= 0) {
                int end;
                int nesting = 1;
                for (end = start + 1; end < str.length(); ++end) {
                    if (str.charAt(end) == '}' && --nesting == 0) {
                        ++end;
                        break;
                    }
                    if (str.charAt(end) != '{') continue;
                    ++nesting;
                }
                content2 = content2.markUnknown(new TextRange(start, end));
            }
            return HtmlUtilsKt.removeHtml(content2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "allowedDomains";
                break;
            }
        }
        objectArray[1] = "com/intellij/grazie/ide/language/properties/PropertyTextExtractor";
        objectArray[2] = "buildTextContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

