/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.grammar.strategy.StrategyUtils;
import com.intellij.grazie.text.StrategyTextExtractor;
import com.intellij.grazie.text.StrategyTextExtractor$Companion$WhenMappings;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/text/StrategyTextExtractor;", "", "strategy", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy;", "(Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy;)V", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "root", "Lcom/intellij/psi/PsiElement;", "extractText", "roots", "", "trimLeadingQuotesAndSpaces", "content", "Companion", "intellij.grazie.core"})
public final class StrategyTextExtractor {
    private final GrammarCheckingStrategy strategy;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TextContent extractText(@NotNull List<? extends PsiElement> roots) {
        boolean bl;
        TextContent it$iv$iv;
        TextContent textContent;
        boolean bl2;
        boolean bl3;
        Object it;
        boolean bl4;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        TokenSet wsTokens = this.strategy.getWhiteSpaceTokens();
        Iterable iterable = roots;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            PsiElement it2 = (PsiElement)element$iv$iv2;
            boolean bl5 = false;
            if (!(!(it2 instanceof PsiCompiledElement) && !wsTokens.contains(PsiTreeUtilKt.getElementType((PsiElement)it2)))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl4 = false;
            it = (PsiElement)element$iv$iv;
            boolean bl6 = false;
            if (this.buildTextContent((PsiElement)it) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = textContent;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl4 = false;
            it = (TextContent)element$iv$iv;
            boolean bl7 = false;
            if (this.trimLeadingQuotesAndSpaces((TextContent)it) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = textContent;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        return TextContent.joinWithWhitespace(fragments);
    }

    private final TextContent trimLeadingQuotesAndSpaces(TextContent content2) {
        int trimSuffix;
        String text2 = ((Object)content2).toString();
        int trimPrefix = StrategyUtils.INSTANCE.quotesOffset$intellij_grazie_core(text2);
        boolean bl = trimPrefix <= (trimSuffix = text2.length() - trimPrefix);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        while (trimSuffix > trimPrefix && CharsKt.isWhitespace((char)text2.charAt(trimSuffix - 1))) {
            --trimSuffix;
        }
        while (trimSuffix > trimPrefix && CharsKt.isWhitespace((char)text2.charAt(trimPrefix))) {
            ++trimPrefix;
        }
        if (trimSuffix <= trimPrefix) {
            return null;
        }
        if (trimPrefix > 0 || trimSuffix < text2.length()) {
            return content2.excludeRange(new TextRange(trimSuffix, text2.length())).excludeRange(new TextRange(0, trimPrefix));
        }
        return content2;
    }

    /*
     * WARNING - void declaration
     */
    private final TextContent buildTextContent(PsiElement root) {
        Collection<TextContent.Exclusion> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IntRange it;
        void $this$filterTo$iv$iv;
        TextContent.TextDomain textDomain = Companion.convertDomain(this.strategy.getContextRootTextDomain(root));
        if (textDomain == null) {
            throw (Throwable)new IllegalArgumentException("Non-text " + root.getClass() + " in " + this.strategy.getClass());
        }
        TextContent.TextDomain domain = textDomain;
        Function1<PsiElement, GrammarCheckingStrategy.ElementBehavior> $fun$getBehavior$1 = new Function1<PsiElement, GrammarCheckingStrategy.ElementBehavior>(this, root){
            final /* synthetic */ StrategyTextExtractor this$0;
            final /* synthetic */ PsiElement $root;

            @NotNull
            public final GrammarCheckingStrategy.ElementBehavior invoke(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element != this.$root && StrategyTextExtractor.access$getStrategy$p(this.this$0).isMyContextRoot(element) ? GrammarCheckingStrategy.ElementBehavior.ABSORB : StrategyTextExtractor.access$getStrategy$p(this.this$0).getElementBehavior(this.$root, element);
            }
            {
                this.this$0 = strategyTextExtractor;
                this.$root = psiElement;
                super(1);
            }
        };
        TextContent textContent = TextContentBuilder.FromPsi.withUnknown(new Predicate($fun$getBehavior$1){
            final /* synthetic */ buildTextContent.1 $getBehavior$1;

            public final boolean test(PsiElement e) {
                PsiElement psiElement = e;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"e");
                return this.$getBehavior$1.invoke(psiElement) == GrammarCheckingStrategy.ElementBehavior.ABSORB;
            }
            {
                this.$getBehavior$1 = var1_1;
            }
        }).excluding(new Predicate($fun$getBehavior$1){
            final /* synthetic */ buildTextContent.1 $getBehavior$1;

            public final boolean test(PsiElement e) {
                PsiElement psiElement = e;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"e");
                return this.$getBehavior$1.invoke(psiElement) == GrammarCheckingStrategy.ElementBehavior.STEALTH;
            }
            {
                this.$getBehavior$1 = var1_1;
            }
        }).build(root, domain, new TextRange(0, root.getTextLength()));
        if (textContent == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"TextContentBuilder.FromP\u2026xtLength)) ?: return null");
        TextContent content2 = textContent;
        LinkedHashSet<IntRange> stealthyRanges = this.strategy.getStealthyRanges(root, content2);
        Iterable $this$filter$iv = stealthyRanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IntRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getFirst() <= it.getLast() && it.getLast() < content2.length())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.size() != stealthyRanges.size()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StrategyTextExtractor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            PluginException.logPluginError((Logger)logger, (String)(this.strategy + " produced invalid stealthy ranges " + stealthyRanges + " in a text of length " + content2.length()), null, this.strategy.getClass());
        }
        Iterable $i$f$logger = filtered;
        TextContent textContent2 = content2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IntRange)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            TextContent.Exclusion exclusion = new TextContent.Exclusion(it.getFirst(), it.getLast() + 1, false);
            collection.add(exclusion);
        }
        collection = (List)destination$iv$iv;
        return textContent2.excludeRanges((List<TextContent.Exclusion>)collection);
    }

    public StrategyTextExtractor(@NotNull GrammarCheckingStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.strategy = strategy;
    }

    public static final /* synthetic */ GrammarCheckingStrategy access$getStrategy$p(StrategyTextExtractor $this) {
        return $this.strategy;
    }

    @JvmStatic
    @Nullable
    public static final TextContent.TextDomain convertDomain(@NotNull GrammarCheckingStrategy.TextDomain domain) {
        return Companion.convertDomain(domain);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/text/StrategyTextExtractor$Companion;", "", "()V", "convertDomain", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "domain", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy$TextDomain;", "intellij.grazie.core"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final TextContent.TextDomain convertDomain(@NotNull GrammarCheckingStrategy.TextDomain domain) {
            TextContent.TextDomain textDomain;
            Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
            switch (StrategyTextExtractor$Companion$WhenMappings.$EnumSwitchMapping$0[domain.ordinal()]) {
                case 1: {
                    textDomain = TextContent.TextDomain.LITERALS;
                    break;
                }
                case 2: {
                    textDomain = TextContent.TextDomain.COMMENTS;
                    break;
                }
                case 3: {
                    textDomain = TextContent.TextDomain.DOCUMENTATION;
                    break;
                }
                case 4: {
                    textDomain = TextContent.TextDomain.PLAIN_TEXT;
                    break;
                }
                default: {
                    textDomain = null;
                }
            }
            return textDomain;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

