/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextContentBuilder {
    public static final TextContentBuilder FromPsi = new TextContentBuilder(e -> e instanceof OuterLanguageElement, e -> false, Collections.emptySet());
    private final Predicate<PsiElement> unknown;
    private final Predicate<PsiElement> excluded;
    private final Set<Character> indentChars;

    private TextContentBuilder(Predicate<PsiElement> unknown, Predicate<PsiElement> excluded, Set<Character> indentChars) {
        this.unknown = unknown;
        this.excluded = excluded;
        this.indentChars = indentChars;
    }

    public TextContentBuilder withUnknown(Predicate<PsiElement> unknown) {
        return new TextContentBuilder(e -> this.unknown.test((PsiElement)e) || unknown.test((PsiElement)e), this.excluded, this.indentChars);
    }

    public TextContentBuilder excluding(Predicate<PsiElement> excluded) {
        return new TextContentBuilder(this.unknown, e -> this.excluded.test((PsiElement)e) || excluded.test((PsiElement)e), this.indentChars);
    }

    public TextContentBuilder removingIndents(String indentChars) {
        HashSet<Character> set = new HashSet<Character>(this.indentChars);
        for (int i = 0; i < indentChars.length(); ++i) {
            set.add(Character.valueOf(indentChars.charAt(i)));
        }
        return new TextContentBuilder(this.unknown, this.excluded, set);
    }

    @Nullable
    public TextContent build(PsiElement root, TextContent.TextDomain domain) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)root);
        return this.build(root, domain, manipulator != null ? manipulator.getRangeInElement(root) : new TextRange(0, root.getTextLength()));
    }

    @Nullable
    TextContent build(final PsiElement root, TextContent.TextDomain domain, final TextRange valueRange) {
        String rootText;
        final int rootStart = root.getTextRange().getStartOffset();
        TextContent content2 = new PsiRecursiveElementWalkingVisitor(rootText = root.getText(), domain){
            final List<TextContentImpl.TokenInfo> tokens = new ArrayList<TextContentImpl.TokenInfo>();
            int currentStart = valueRange.getStartOffset();
            final /* synthetic */ String val$rootText;
            final /* synthetic */ TextContent.TextDomain val$domain;
            {
                this.val$rootText = string;
                this.val$domain = textDomain;
            }

            public void visitElement(@NotNull PsiElement element) {
                TextRange range;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((range = element.getTextRange().shiftLeft(rootStart).intersection(valueRange)) == null) {
                    return;
                }
                if (TextContentBuilder.this.unknown.test(element)) {
                    this.exclusionStarted(range);
                    this.tokens.add(new TextContentImpl.PsiToken("", root, TextRange.from((int)range.getStartOffset(), (int)0), true));
                } else if (TextContentBuilder.this.excluded.test(element)) {
                    this.exclusionStarted(range);
                } else {
                    super.visitElement(element);
                }
            }

            private void exclusionStarted(TextRange range) {
                if (range.getStartOffset() != this.currentStart) {
                    TextRange tokenRange = new TextRange(this.currentStart, range.getStartOffset());
                    this.tokens.add(new TextContentImpl.PsiToken(tokenRange.substring(this.val$rootText), root, tokenRange, false));
                }
                this.currentStart = range.getEndOffset();
            }

            @Nullable
            TextContent walkPsiTree() {
                root.accept((PsiElementVisitor)this);
                this.exclusionStarted(TextRange.from((int)valueRange.getEndOffset(), (int)0));
                return this.tokens.isEmpty() ? null : new TextContentImpl(this.val$domain, this.tokens);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/grazie/text/TextContentBuilder$1", "visitElement"));
            }
        }.walkPsiTree();
        return content2 == null ? null : content2.removeIndents(this.indentChars).trimWhitespace();
    }
}

