/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.CmdStatusClient;
import org.jetbrains.idea.svn.status.CmdStatusClientKt;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J2\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/svn/status/CmdStatusClient;", "Lorg/jetbrains/idea/svn/api/BaseSvnClient;", "Lorg/jetbrains/idea/svn/status/StatusClient;", "()V", "createInfoGetter", "Lcom/intellij/util/containers/Convertor;", "Ljava/io/File;", "Lorg/jetbrains/idea/svn/info/Info;", "doStatus", "Lorg/jetbrains/idea/svn/status/Status;", "path", "remote", "", "", "depth", "Lorg/jetbrains/idea/svn/api/Depth;", "reportAll", "includeIgnored", "collectParentExternals", "handler", "Lorg/jetbrains/idea/svn/status/StatusConsumer;", "parseResult", "base", "infoBase", "command", "Lorg/jetbrains/idea/svn/commandLine/CommandExecutor;", "Companion", "intellij.vcs.svn"})
public final class CmdStatusClient
extends BaseSvnClient
implements StatusClient {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void doStatus(@NotNull File path, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)depth), (String)"depth");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        File file = CommandUtil.requireExistingParent(path);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"requireExistingParent(path)");
        File base = file;
        Info infoBase = this.myFactory.createInfoClient().doInfo(base, null);
        boolean bl = false;
        List parameters = new ArrayList();
        CmdStatusClientKt.access$putParameters(parameters, path, depth, remote, reportAll, includeIgnored);
        CommandExecutor commandExecutor = this.execute(this.myVcs, Target.Companion.on$default(Target.Companion, path, null, 2, null), SvnCommandName.st, parameters, null);
        Intrinsics.checkNotNullExpressionValue((Object)commandExecutor, (String)"execute(myVcs, Target.on\u2026ame.st, parameters, null)");
        CommandExecutor command = commandExecutor;
        this.parseResult(path, base, infoBase, command, handler);
    }

    @Override
    @Nullable
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create<Status>()");
        Ref status = ref;
        this.doStatus(path, Depth.EMPTY, remote, false, false, false, new StatusConsumer(status){
            final /* synthetic */ Ref $status;

            public final void consume(Status it) {
                this.$status.set((Object)it);
            }
            {
                this.$status = ref;
            }
        });
        return (Status)status.get();
    }

    private final void parseResult(File path, File base, Info infoBase, CommandExecutor command, StatusConsumer handler) throws SvnBindException {
        String string = command.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.output");
        String result = string;
        if (StringUtil.isEmptyOrSpaces((String)result)) {
            throw (Throwable)((Object)new SvnBindException(SvnBundle.message("error.svn.status.with.no.output", command.getCommandText())));
        }
        try {
            if (!CmdStatusClientKt.access$parseResult(base, infoBase, this.createInfoGetter(), result, handler)) {
                if (!SvnUtil.isSvnVersioned(this.myVcs, path)) {
                    LOG.info("Status requested not in working copy. Command - " + command.getCommandText() + ". Result - " + result);
                    throw (Throwable)((Object)new SvnBindException(ErrorCode.WC_NOT_WORKING_COPY, SvnBundle.message("error.svn.status.not.in.working.copy", command.getCommandText())));
                }
                Status.Builder status = new Status.Builder(path);
                status.setItemStatus(StatusType.STATUS_NORMAL);
                status.setInfoProvider(new Supplier(this, path){
                    final /* synthetic */ CmdStatusClient this$0;
                    final /* synthetic */ File $path;

                    @Nullable
                    public final Info get() {
                        return (Info)CmdStatusClient.access$createInfoGetter(this.this$0).convert((Object)this.$path);
                    }
                    {
                        this.this$0 = cmdStatusClient;
                        this.$path = file;
                    }
                });
                handler.consume(status.build());
            }
        }
        catch (JAXBException e) {
            command.logCommand();
            throw (Throwable)((Object)new SvnBindException(e));
        }
    }

    private final Convertor<File, Info> createInfoGetter() {
        return new Convertor(this){
            final /* synthetic */ CmdStatusClient this$0;

            public final Info convert(File it) {
                Info info2;
                try {
                    info2 = CmdStatusClient.access$getMyFactory$p(this.this$0).createInfoClient().doInfo(it, null);
                }
                catch (SvnBindException e) {
                    throw (Throwable)new SvnExceptionWrapper(e);
                }
                return info2;
            }
            {
                this.this$0 = cmdStatusClient;
            }
        };
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CmdStatusClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Convertor access$createInfoGetter(CmdStatusClient $this) {
        return $this.createInfoGetter();
    }

    public static final /* synthetic */ ClientFactory access$getMyFactory$p(CmdStatusClient $this) {
        return $this.myFactory;
    }

    public static final /* synthetic */ void access$setMyFactory$p(CmdStatusClient $this, ClientFactory clientFactory) {
        $this.myFactory = clientFactory;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/svn/status/CmdStatusClient$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseResult", "Lorg/jetbrains/idea/svn/status/Status;", "base", "Ljava/io/File;", "result", "", "intellij.vcs.svn"})
    public static final class Companion {
        @Nullable
        public final Status parseResult(@NotNull File base, @NotNull String result) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            Ref ref = new Ref();
            Function1 function1 = (Function1)new Function1<Status, Unit>(ref){

                public final void invoke(@Nullable Status p1) {
                    ((Ref)this.receiver).set((Object)p1);
                }
            };
            CmdStatusClientKt.access$parseResult(base, null, parseResult.1.INSTANCE, result, new StatusConsumer(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ void consume(Status p0) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke((Object)p0), (String)"invoke(...)");
                }
            });
            return (Status)ref.get();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

