/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentUnindentHandlerBase;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemUnindentHandler;", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentUnindentHandlerBase;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "decreaseNestingLevel", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;", "outerItem", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "doIndentUnindent", "", "removeLeadingSpaces", "updateNumbering", "intellij.markdown"})
public final class MarkdownListItemUnindentHandler
extends ListItemIndentUnindentHandlerBase {
    @Override
    protected boolean doIndentUnindent(@NotNull MarkdownListItemImpl item, @NotNull MarkdownFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        PsiElement $this$parentOfType$iv = (PsiElement)item;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        MarkdownListItemImpl outerItem = (MarkdownListItemImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItemImpl.class, (boolean)true);
        if (outerItem == null) {
            return this.removeLeadingSpaces(item, document);
        }
        this.decreaseNestingLevel(item, outerItem, file, document);
        return true;
    }

    private final boolean removeLeadingSpaces(MarkdownListItemImpl item, Document document) {
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document, itemInfo.getLines().getFirst());
        if (!indentRange.isEmpty()) {
            Replacement.Companion.replaceSafelyIn$intellij_markdown(itemInfo.changeIndent(0), document);
        }
        return !indentRange.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void decreaseNestingLevel(MarkdownListItemImpl item, MarkdownListItemImpl outerItem, MarkdownFile file, Document document) {
        int n;
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        ListItemInfo outerInfo = new ListItemInfo(outerItem, document);
        int newSiblingsIndent = ListItemIndentInfo.with$default(itemInfo.getIndentInfo(), outerInfo.getIndentInfo().getIndent(), 0, 2, null).subItemIndent();
        int n2 = outerInfo.getLines().getLast();
        if (n2 >= (n = itemInfo.getLines().getLast() + 1)) {
            while (true) {
                void siblingLine;
                Replacement replacement = itemInfo.getIndentInfo().changeLineIndent((int)siblingLine, newSiblingsIndent, document, (PsiFile)file);
                if (replacement != null) {
                    replacement.apply(document);
                }
                if (siblingLine == n) break;
                --siblingLine;
            }
        }
        Replacement.Companion.replaceSafelyIn$intellij_markdown(itemInfo.changeIndent(outerInfo.getIndentInfo().getIndent()), document);
    }

    @Override
    protected void updateNumbering(@NotNull MarkdownListItemImpl item, @NotNull MarkdownFile file, @NotNull Document document) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            ListRenumberUtils.INSTANCE.renumberInBulk(ListUtils.INSTANCE.getList(item), document, false, false);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            MarkdownListImpl markdownListImpl = (MarkdownListImpl)CollectionsKt.firstOrNull(ListUtils.INSTANCE.getSublists(item));
            if (markdownListImpl == null) break block0;
            ListRenumberUtils.INSTANCE.renumberInBulk(markdownListImpl, document, false, true);
        }
    }

    public MarkdownListItemUnindentHandler(@Nullable EditorActionHandler baseHandler) {
        super(baseHandler);
    }
}

