/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings.pandoc;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownNotifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\u0004J\n\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/settings/pandoc/PandocExecutableDetector;", "", "()V", "UNIX_EXECUTABLE", "", "UNIX_PATHS", "", "WIN_EXECUTABLE", "<set-?>", "", "isCanceled", "()Z", "detect", "detectForUnix", "tryToGetPandocVersion", "project", "Lcom/intellij/openapi/project/Project;", "executable", "intellij.markdown"})
public final class PandocExecutableDetector {
    private final List<String> UNIX_PATHS = CollectionsKt.listOf((Object[])new String[]{"/usr/local/bin", "/opt/local/bin", "/usr/bin", "/opt/bin"});
    private final String UNIX_EXECUTABLE;
    private final String WIN_EXECUTABLE;
    private boolean isCanceled;

    public final boolean isCanceled() {
        return this.isCanceled;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String tryToGetPandocVersion(@NotNull Project project, @NotNull String executable) {
        void pandocVersion;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{executable, "-v"});
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        new Task.Modal(this, cmd, project, (Ref.ObjectRef)pandocVersion, project, MarkdownBundle.message("markdown.settings.pandoc.executable.version.process", new Object[0]), true){
            private ProcessOutput output;
            final /* synthetic */ PandocExecutableDetector this$0;
            final /* synthetic */ GeneralCommandLine $cmd;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef $pandocVersion;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.output = ExecUtil.execAndGetOutput((GeneralCommandLine)this.$cmd);
            }

            public void onThrowable(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                MarkdownNotifier.INSTANCE.notifyPandocNotDetected(this.$project);
            }

            public void onCancel() {
                PandocExecutableDetector.access$setCanceled$p(this.this$0, true);
            }

            public void onSuccess() {
                ProcessOutput processOutput = this.output;
                if (processOutput == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                }
                String string = processOutput.getStderr();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.stderr");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    MarkdownNotifier.INSTANCE.notifyPandocDetected(this.$project);
                    ProcessOutput processOutput2 = this.output;
                    if (processOutput2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    List list = processOutput2.getStdoutLines();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"output.stdoutLines");
                    this.$pandocVersion.element = (String)CollectionsKt.first((List)list);
                } else {
                    ProcessOutput processOutput3 = this.output;
                    if (processOutput3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    }
                    String string2 = processOutput3.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"output.stderr");
                    MarkdownNotifier.INSTANCE.notifyPandocDetectionFailed(this.$project, string2);
                }
            }
            {
                this.this$0 = this$0;
                this.$cmd = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$pandocVersion = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.queue();
        return (String)pandocVersion.element;
    }

    public static /* synthetic */ String tryToGetPandocVersion$default(PandocExecutableDetector pandocExecutableDetector, Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "pandoc";
        }
        return pandocExecutableDetector.tryToGetPandocVersion(project, string);
    }

    @NotNull
    public final String detect() {
        String string;
        File executableFromPath = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? this.WIN_EXECUTABLE : this.UNIX_EXECUTABLE), (String)PathEnvironmentVariableUtil.getPathVariableValue(), null);
        if (executableFromPath != null) {
            String string2 = executableFromPath.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"executableFromPath.absolutePath");
            return string2;
        }
        if (SystemInfo.isWindows) {
            string = "";
        } else {
            string = this.detectForUnix();
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    private final String detectForUnix() {
        Iterable $this$forEach$iv = this.UNIX_PATHS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            File file = new File(it, this.UNIX_EXECUTABLE);
            if (!file.exists()) continue;
            return file.getPath();
        }
        return null;
    }

    public PandocExecutableDetector() {
        this.UNIX_EXECUTABLE = "pandoc";
        this.WIN_EXECUTABLE = "pandoc.exe";
    }

    public static final /* synthetic */ boolean access$isCanceled$p(PandocExecutableDetector $this) {
        return $this.isCanceled;
    }

    public static final /* synthetic */ void access$setCanceled$p(PandocExecutableDetector $this, boolean bl) {
        $this.isCanceled = bl;
    }
}

