/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownIntroduceLinkReferenceAction
extends AnAction
implements DumbAware {
    private static final String VAR_NAME = "reference";

    public void update(@NotNull AnActionEvent e) {
        Pair<PsiFile, Editor> fileAndEditor;
        if (e == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(0);
        }
        if ((fileAndEditor = MarkdownIntroduceLinkReferenceAction.getFileAndEditor(e)) == null) {
            return;
        }
        Caret caret = ((Editor)fileAndEditor.getSecond()).getCaretModel().getCurrentCaret();
        Couple<PsiElement> elements = MarkdownActionUtil.getElementsUnderCaretOrSelection((PsiFile)fileAndEditor.getFirst(), caret);
        if (elements == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        PsiElement parentLink = MarkdownActionUtil.getCommonParentOfTypes((PsiElement)elements.getFirst(), (PsiElement)elements.getSecond(), MarkdownTokenTypeSets.LINKS);
        if (parentLink == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Pair<PsiFile, Editor> fileAndEditor;
        if (e == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(1);
        }
        if ((fileAndEditor = MarkdownIntroduceLinkReferenceAction.getFileAndEditor(e)) == null) {
            return;
        }
        Editor editor2 = (Editor)fileAndEditor.getSecond();
        PsiFile file = (PsiFile)fileAndEditor.getFirst();
        Caret caret = editor2.getCaretModel().getCurrentCaret();
        Couple<PsiElement> elements = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, caret);
        assert (elements != null);
        PsiElement link = MarkdownActionUtil.getCommonTopmostParentOfTypes((PsiElement)elements.getFirst(), (PsiElement)elements.getSecond(), MarkdownTokenTypeSets.LINKS);
        if (link == null) {
            return;
        }
        Project project = link.getProject();
        WriteCommandAction.runWriteCommandAction((Project)file.getProject(), () -> {
            PostprocessReformattingAspect.getInstance((Project)file.getProject()).disablePostprocessFormattingInside(() -> {
                if (!file.isValid()) {
                    return;
                }
                Pair<PsiElement, PsiElement> referencePair = MarkdownIntroduceLinkReferenceAction.createLinkDeclarationAndReference(project, link, VAR_NAME);
                MarkdownIntroduceLinkReferenceAction.insertLastNewLines(file, 2);
                PsiElement declaration = file.addAfter((PsiElement)referencePair.getSecond(), file.getLastChild());
                PsiElement reference = link.replace((PsiElement)referencePair.getFirst());
                String url = Objects.requireNonNull((MarkdownLinkDestinationImpl)PsiTreeUtil.getChildOfType((PsiElement)declaration, MarkdownLinkDestinationImpl.class)).getText();
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
                TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)file);
                PsiElement declarationLabel = declaration.getFirstChild();
                PsiElement referenceLabel = reference.getFirstChild().getLastChild();
                TextExpression expression = ApplicationManager.getApplication().isUnitTestMode() ? new TextExpression(VAR_NAME) : new EmptyExpression();
                builder.replaceElement(declarationLabel, TextRange.create((int)1, (int)(declarationLabel.getTextLength() - 1)), VAR_NAME, (Expression)expression, true);
                builder.replaceElement(referenceLabel, TextRange.create((int)1, (int)(referenceLabel.getTextLength() - 1)), VAR_NAME, (Expression)expression, true);
                editor2.getCaretModel().moveToOffset(0);
                Template template = builder.buildInlineTemplate();
                PsiElement title = ((PsiElement)referencePair.getSecond()).getLastChild();
                String titleText = null;
                if (PsiUtilCore.getElementType((PsiElement)title) == MarkdownElementTypes.LINK_TITLE) {
                    titleText = title.getText();
                }
                TemplateManager.getInstance((Project)project).startTemplate(editor2, template, (TemplateEditingListener)new DuplicatesFinder(file, editor2, url, titleText));
            });
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        });
    }

    @Nullable
    private static Pair<PsiFile, Editor> getFileAndEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(2);
        }
        Editor editor2 = MarkdownActionUtil.findMarkdownTextEditor(e);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor2 == null || psiFile == null || !psiFile.isValid()) {
            return null;
        }
        return Pair.create((Object)psiFile, (Object)editor2);
    }

    private static void insertLastNewLines(@NotNull PsiFile psiFile, int num) {
        if (psiFile == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(3);
        }
        assert (num >= 0) : "Cannot insert negative number of new lines";
        PsiElement newLines = MarkdownPsiElementFactory.createNewLines(psiFile.getProject(), num);
        psiFile.addRange(newLines.getFirstChild(), newLines.getLastChild());
    }

    public static void replaceDuplicate(@NotNull PsiElement match, @NotNull String referenceText) {
        if (match == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(4);
        }
        if (referenceText == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(5);
        }
        WriteCommandAction.runWriteCommandAction((Project)match.getProject(), () -> {
            PsiFile file = match.getContainingFile();
            if (!file.isValid()) {
                return;
            }
            match.replace((PsiElement)MarkdownIntroduceLinkReferenceAction.createLinkDeclarationAndReference(match.getProject(), match, referenceText).getFirst());
        });
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(Project project, PsiElement link, String referenceText) {
        String text = null;
        String title = null;
        String url = MarkdownIntroduceLinkReferenceAction.getUrl(link);
        if (PsiUtilCore.getElementType((PsiElement)link) == MarkdownElementTypes.INLINE_LINK) {
            PsiElement titleElement;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser();
            PsiElement textElement = (PsiElement)syntaxTraverser.children((Object)link).find(child -> PsiUtilCore.getElementType((PsiElement)child) == MarkdownElementTypes.LINK_TEXT);
            if (textElement != null) {
                text = textElement.getText();
                assert (text.startsWith("[") && text.endsWith("]"));
                text = text.substring(1, text.length() - 1);
            }
            if ((titleElement = (PsiElement)syntaxTraverser.children((Object)link).find(child -> PsiUtilCore.getElementType((PsiElement)child) == MarkdownElementTypes.LINK_TITLE)) != null) {
                title = titleElement.getText();
            }
        }
        assert (url != null);
        if (text == null) {
            text = url;
        }
        Pair<PsiElement, PsiElement> pair = MarkdownPsiElementFactory.createLinkDeclarationAndReference(project, url, text, title, referenceText);
        if (pair == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    public static String getUrl(@NotNull PsiElement link) {
        if (link == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(7);
        }
        String url = null;
        IElementType type = PsiUtilCore.getElementType((PsiElement)link);
        if (type == MarkdownElementTypes.AUTOLINK) {
            url = link.getFirstChild().getNextSibling().getText();
        } else if (type == MarkdownTokenTypes.GFM_AUTOLINK) {
            url = link.getText();
        } else if (type == MarkdownTokenTypes.EMAIL_AUTOLINK) {
            url = link.getText();
        } else if (type == MarkdownElementTypes.INLINE_LINK) {
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser();
            url = ((PsiElement)syntaxTraverser.children((Object)link).find(child -> PsiUtilCore.getElementType((PsiElement)child) == MarkdownElementTypes.LINK_DESTINATION)).getText();
        }
        return url;
    }

    public static void replaceDuplicates(@NotNull PsiElement file, @NotNull Editor editor2, @NotNull List<SmartPsiElementPointer<PsiElement>> duplicates, @NotNull String referenceText, boolean showWarning) {
        int exitCode;
        if (file == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(9);
        }
        if (duplicates == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(10);
        }
        if (referenceText == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(11);
        }
        Object warningMessage = "";
        if (showWarning) {
            warningMessage = "\n\n" + MarkdownBundle.message("markdown.extract.link.extract.duplicates.warning", new Object[0]);
        }
        String message = MarkdownBundle.message("markdown.extract.link.extract.duplicates.description", ApplicationNamesInfo.getInstance().getProductName(), duplicates.size()) + (String)warningMessage;
        boolean isUnittest = ApplicationManager.getApplication().isUnitTestMode();
        Project project = file.getProject();
        int n = exitCode = !isUnittest ? Messages.showYesNoDialog((Project)project, (String)message, (String)MarkdownBundle.message("markdown.extract.link.refactoring.dialog.title", new Object[0]), (Icon)Messages.getInformationIcon()) : 0;
        if (exitCode == 0) {
            boolean replaceAll = false;
            HashMap<PsiElement, RangeHighlighter> highlighterMap = new HashMap<PsiElement, RangeHighlighter>();
            for (SmartPsiElementPointer<PsiElement> smartPsiElementPointer : duplicates) {
                PsiElement match = smartPsiElementPointer.getElement();
                if (match == null || !match.isValid()) continue;
                if (!replaceAll) {
                    MarkdownIntroduceLinkReferenceAction.highlightInEditor(project, editor2, highlighterMap, match);
                    int promptResult = 3;
                    if (!isUnittest) {
                        ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, MarkdownBundle.message("markdown.extract.link.extract.link.replace", new Object[0]), project);
                        promptDialog.show();
                        promptResult = promptDialog.getExitCode();
                    }
                    if (promptResult == 2) {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
                        RangeHighlighter highlighter = (RangeHighlighter)highlighterMap.get(match);
                        if (highlighter == null) continue;
                        highlightManager.removeSegmentHighlighter(editor2, highlighter);
                        continue;
                    }
                    if (promptResult == 1) break;
                    if (promptResult == 0) {
                        MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
                        continue;
                    }
                    if (promptResult != 3) continue;
                    MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
                    replaceAll = true;
                    continue;
                }
                MarkdownIntroduceLinkReferenceAction.replaceDuplicate(match, referenceText);
            }
        }
    }

    private static void highlightInEditor(@NotNull Project project, @NotNull Editor editor2, @NotNull Map<PsiElement, RangeHighlighter> highlighterMap, @NotNull PsiElement element) {
        if (project == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(12);
        }
        if (editor2 == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(13);
        }
        if (highlighterMap == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(14);
        }
        if (element == null) {
            MarkdownIntroduceLinkReferenceAction.$$$reportNull$$$0(15);
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        int startOffset = element.getTextRange().getStartOffset();
        int endOffset = element.getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor2, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
        highlighterMap.put(element, (RangeHighlighter)highlighters.get(0));
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(startOffset);
        editor2.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/actions/styling/MarkdownIntroduceLinkReferenceAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighterMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/actions/styling/MarkdownIntroduceLinkReferenceAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkDeclarationAndReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileAndEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "insertLastNewLines";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceDuplicate";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUrl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceDuplicates";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "highlightInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DuplicatesFinder
    extends TemplateEditingAdapter {
        @NotNull
        private final String myUrl;
        @NotNull
        private final PsiFile myFile;
        @NotNull
        private final Editor myEditor;
        @Nullable
        private final String myTitleText;

        private DuplicatesFinder(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull String url, String titleText) {
            if (file == null) {
                DuplicatesFinder.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                DuplicatesFinder.$$$reportNull$$$0(1);
            }
            if (url == null) {
                DuplicatesFinder.$$$reportNull$$$0(2);
            }
            this.myUrl = url;
            this.myFile = file;
            this.myEditor = editor2;
            this.myTitleText = titleText;
        }

        public void currentVariableChanged(@NotNull TemplateState templateState, Template template, int oldIndex, int newIndex) {
            if (templateState == null) {
                DuplicatesFinder.$$$reportNull$$$0(3);
            }
            if (!(ApplicationManager.getApplication().isUnitTestMode() || oldIndex == 0 && newIndex == 1 || oldIndex == -1 && newIndex == -1)) {
                return;
            }
            TextResult reference = templateState.getVariableValue(MarkdownIntroduceLinkReferenceAction.VAR_NAME);
            if (reference == null) {
                return;
            }
            this.processDuplicates(reference.getText());
        }

        public void processDuplicates(@NotNull String referenceText) {
            Object[] duplicatedLinks;
            boolean showWarning;
            if (referenceText == null) {
                DuplicatesFinder.$$$reportNull$$$0(4);
            }
            boolean bl = showWarning = !Arrays.stream(duplicatedLinks = PsiTreeUtil.collectElements((PsiElement)this.myFile, element -> MarkdownTokenTypeSets.LINKS.contains(PsiUtilCore.getElementType((PsiElement)element)) && this.myUrl.equals(MarkdownIntroduceLinkReferenceAction.getUrl(element)) && PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, element1 -> PsiUtilCore.getElementType((PsiElement)element1) == MarkdownElementTypes.INLINE_LINK) == null && PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> PsiUtilCore.getElementType((PsiElement)element1) == MarkdownElementTypes.FULL_REFERENCE_LINK) == null)).allMatch(link -> {
                PsiElement[] children2 = link.getChildren();
                return children2.length == 0 && this.myTitleText == null || children2.length == 3 && PsiUtilCore.getElementType((PsiElement)children2[2]) == MarkdownElementTypes.LINK_TITLE && children2[2].getText().equals(this.myTitleText);
            });
            if (duplicatedLinks.length > 0) {
                List duplicates = ContainerUtil.map((Object[])duplicatedLinks, link -> SmartPointerManager.createPointer((PsiElement)link));
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    MarkdownIntroduceLinkReferenceAction.replaceDuplicates((PsiElement)this.myFile, this.myEditor, duplicates, referenceText, showWarning);
                    PsiDocumentManager.getInstance((Project)this.myFile.getProject()).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
                    Document document = this.myEditor.getDocument();
                    document.setText((CharSequence)(document.getText() + "\nTitles Warning: " + showWarning));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> MarkdownIntroduceLinkReferenceAction.replaceDuplicates((PsiElement)this.myFile, this.myEditor, duplicates, referenceText, showWarning));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referenceText";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/plugins/markdown/ui/actions/styling/MarkdownIntroduceLinkReferenceAction$DuplicatesFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "currentVariableChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDuplicates";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

