import sys
from typing import Any, NamedTuple, Optional, Tuple, Union

_TimeTuple = Tuple[int, int, int, int, int, int, int, int, int]

accept2dyear: bool
altzone: int
daylight: int
timezone: int
tzname: Tuple[str, str]

class _struct_time(NamedTuple):
    tm_year: int
    tm_mon: int
    tm_mday: int
    tm_hour: int
    tm_min: int
    tm_sec: int
    tm_wday: int
    tm_yday: int
    tm_isdst: int
    @property
    def n_fields(self) -> int: ...
    @property
    def n_sequence_fields(self) -> int: ...
    @property
    def n_unnamed_fields(self) -> int: ...

class struct_time(_struct_time):
    def __init__(self, o: _TimeTuple, _arg: Any = ...) -> None: ...
    def __new__(cls, o: _TimeTuple, _arg: Any = ...) -> struct_time: ...

def asctime(t: Union[_TimeTuple, struct_time] = ...) -> str: ...
def clock() -> float: ...
def ctime(secs: Optional[float] = ...) -> str: ...
def gmtime(secs: Optional[float] = ...) -> struct_time: ...
def localtime(secs: Optional[float] = ...) -> struct_time: ...
def mktime(t: Union[_TimeTuple, struct_time]) -> float: ...
def sleep(secs: float) -> None: ...
def strftime(format: str, t: Union[_TimeTuple, struct_time] = ...) -> str: ...
def strptime(string: str, format: str = ...) -> struct_time: ...
def time() -> float: ...

if sys.platform != "win32":
    def tzset() -> None: ...  # Unix only
