// SDB-CGEN V1.8.2
// gcc -DMAIN=1 arm.c ; ./a.out > arm.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"adc","add with carry"}, 
  {"adcs","add with carry and update flags"}, 
  {"add","add two values"}, 
  {"addeq","add two values if Z set (equal)"}, 
  {"addg","add with tag"}, 
  {"addlo","add if C is clear (no carry)"}, 
  {"addne","add two values if Z clear (not equal)"}, 
  {"adds","add two values and update flags"}, 
  {"adr","form pc-relative address"}, 
  {"adrp","form pc-relative address to 4kb page"}, 
  {"and","logical AND"}, 
  {"andeq","logical AND if Z set (equal)"}, 
  {"andne","logical AND if Z clear (not equal)"}, 
  {"ands","logical AND that updates flags"}, 
  {"asr","arithmetic shift right"}, 
  {"asrs","arithmetic shift right and update flags"}, 
  {"asrv","arithmetic shift right variable"}, 
  {"at","address translate: an alias of sys"}, 
  {"autda","authenticate data address, using key a"}, 
  {"autdb","authenticate data address, using key b"}, 
  {"autdza","authenticate data address, using key a"}, 
  {"autdzb","authenticate data address, using key b"}, 
  {"autia","authenticate instruction address, using key a"}, 
  {"autia1716","authenticate instruction address, using key a"}, 
  {"autiasp","authenticate return pointer before returning from function using A key"}, 
  {"autiaz","authenticate instruction address, using key a"}, 
  {"autib","authenticate instruction address, using key b"}, 
  {"autib1716","authenticate instruction address, using key b"}, 
  {"autibsp","authenticate return pointer before returning from function using B key"}, 
  {"autibz","authenticate instruction address, using key b"}, 
  {"autiza","authenticate instruction address, using key a"}, 
  {"autizb","authenticate instruction address, using key b"}, 
  {"axflag","convert floating-point condition flags from arm to external format"}, 
  {"b","branches the program counter to dst (pc aka r15)"}, 
  {"b.cond","branch conditionally"}, 
  {"bcc","branch if C clear (no carry)"}, 
  {"bcs","branch if C set (carry)"}, 
  {"beq","branches if equal (see 'b') Z is set"}, 
  {"bfc","bitfield clear: an alias of bfm"}, 
  {"bfi","bitfield insert: an alias of bfm"}, 
  {"bfm","bitfield move"}, 
  {"bfxil","bitfield extract and insert at low end: an alias of bfm"}, 
  {"bge","branch if N clear and V clear"}, 
  {"bgt","branch if Z, N and V clear"}, 
  {"bhi","branch if C set and Z clear"}, 
  {"bhs","variant of bcs"}, 
  {"bic","logical bit clear"}, 
  {"bics","Bitwise bit clear (shifted register), setting the condition flags."}, 
  {"bics.w","word bitwise bit clear and update flags"}, 
  {"bl","branches and link, similar to call in i386, set lr(r14) = pc, changes pc (r15) )"}, 
  {"ble","branch if (Z || (N && V)) or !N && V) or !N && V"}, 
  {"blo","variant of bcc"}, 
  {"blr","branch with link to register"}, 
  {"blraa","brank and link with pointer authentication"}, 
  {"blraaz","variants of blraa"}, 
  {"blrab","variants of blraa"}, 
  {"blrabz","variants of blraa"}, 
  {"bls","branch if C clear or Z set"}, 
  {"blt","branch if N clear and V set"}, 
  {"blx","branch link and optionally exchange to Thumb"}, 
  {"bmi","branch if N set"}, 
  {"bne","branch if Z clear (not equal)"}, 
  {"bpl","branch if N clear"}, 
  {"br","branch to register"}, 
  {"braa","branch with pointer authentication using A key"}, 
  {"braaz","variant of braa"}, 
  {"brab","branch with pointer authentication using B key"}, 
  {"brabz","variant of brabz"}, 
  {"brk","breakpoint instruction"}, 
  {"bti","branch target identification"}, 
  {"bvc","branch if V clear"}, 
  {"bvs","branch if V set"}, 
  {"bx","branches and exchanges cpu mode to 16 bits (thumb mode)"}, 
  {"bxj","branches and exchanges cpu mode to Jazzele (jumps to a bytecode vector)"}, 
  {"cas","compare and swap word or doubleword in memory"}, 
  {"casa","compare and swap word or doubleword in memory"}, 
  {"casab","compare and swap byte in memory"}, 
  {"casah","compare and swap halfword in memory"}, 
  {"casal","compare and swap word or doubleword in memory"}, 
  {"casalb","compare and swap byte in memory"}, 
  {"casalh","compare and swap halfword in memory"}, 
  {"casb","compare and swap byte in memory"}, 
  {"cash","compare and swap halfword in memory"}, 
  {"casl","compare and swap word or doubleword in memory"}, 
  {"caslb","compare and swap byte in memory"}, 
  {"caslh","compare and swap halfword in memory"}, 
  {"casp","compare and swap pair of words or doublewords in memory"}, 
  {"caspa","compare and swap pair of words or doublewords in memory"}, 
  {"caspal","compare and swap pair of words or doublewords in memory"}, 
  {"caspl","compare and swap pair of words or doublewords in memory"}, 
  {"cbnz","compare and branch on non-zero"}, 
  {"cbz","compare and branch on zero"}, 
  {"ccmn","conditional compare negative"}, 
  {"ccmp","conditional compare"}, 
  {"cdp","coprocessor data operations"}, 
  {"cfinv","invert carry flag"}, 
  {"cfp","control flow prediction restriction by context: an alias of sys"}, 
  {"cinc","conditional increment: an alias of csinc"}, 
  {"cinv","conditional invert: an alias of csinv"}, 
  {"clrex","clear exclusive"}, 
  {"cls","count leading sign bits"}, 
  {"clz","count leading zeros"}, 
  {"cmn","compare negated"}, 
  {"cmp","compares two registers"}, 
  {"cmpp","compare with tag: an alias of subps"}, 
  {"cneg","conditional negate: an alias of csneg"}, 
  {"cpp","cache prefetch prediction restriction by context: an alias of sys"}, 
  {"cps","change processor state"}, 
  {"cpsid","like msr, but only disable interrupts (i or f)"}, 
  {"cpsie","like msr, but only enable interrupts (i or f)"}, 
  {"crc32b","crc32 checksum"}, 
  {"crc32cb","crc32c checksum"}, 
  {"crc32ch","crc32c checksum"}, 
  {"crc32cw","crc32c checksum"}, 
  {"crc32cx","crc32c checksum"}, 
  {"crc32h","crc32 checksum"}, 
  {"crc32w","crc32 checksum"}, 
  {"crc32x","crc32 checksum"}, 
  {"csdb","consumption of speculative data barrier"}, 
  {"csel","conditional select"}, 
  {"cset","conditional set: an alias of csinc"}, 
  {"csetm","conditional set mask: an alias of csinv"}, 
  {"csinc","conditional select increment"}, 
  {"csinv","conditional select invert"}, 
  {"csneg","conditional select negation"}, 
  {"dc","data cache operation (alias of sys)"}, 
  {"dcps1","debug change pe state to el1."}, 
  {"dcps2","debug change pe state to el2."}, 
  {"dcps3","debug change pe state to el3"}, 
  {"dgh","data gathering hint"}, 
  {"dmb","data memory barrier"}, 
  {"drps","debug restore process state"}, 
  {"dsb","data synchronization barrier."}, 
  {"dvp","data value prediction restriction by context: an alias of sys"}, 
  {"eon","bitwise exclusive or not"}, 
  {"eor","logical exclusive OR (XOR)"}, 
  {"eoreq","logical exclusive OR (XOR) if Z set (equal)"}, 
  {"eorne","logical exclusive OR (XOR) if Z clear (not equal)"}, 
  {"eors","logical exclusive OR (XOR) and update flags"}, 
  {"eret","return from exception"}, 
  {"eretaa","exception return, with pointer authentication"}, 
  {"eretab","exception return, with pointer authentication"}, 
  {"esb","error synchronization barrier"}, 
  {"extr","extract register"}, 
  {"flt","armfpu: convert int to float: flt"}, 
  {"gmi","tag mask insert"}, 
  {"hint","hint instruction"}, 
  {"hlt","external debug breakpoint."}, 
  {"hvc","hypervisor call"}, 
  {"ic","instruction cache operation (alias of sys)"}, 
  {"irg","insert random tag"}, 
  {"isb","instruction synchronization barrier."}, 
  {"it","if then"}, 
  {"ld64b","single-copy atomic 64-byte load"}, 
  {"ldadd","atomic add on word or doubleword in memory"}, 
  {"ldadda","atomic add on word or doubleword in memory"}, 
  {"ldaddab","atomic add on byte in memory"}, 
  {"ldaddah","atomic add on halfword in memory"}, 
  {"ldaddal","atomic add on word or doubleword in memory"}, 
  {"ldaddalb","atomic add on byte in memory"}, 
  {"ldaddalh","atomic add on halfword in memory"}, 
  {"ldaddb","atomic add on byte in memory"}, 
  {"ldaddh","atomic add on halfword in memory"}, 
  {"ldaddl","atomic add on word or doubleword in memory"}, 
  {"ldaddlb","atomic add on byte in memory"}, 
  {"ldaddlh","atomic add on halfword in memory"}, 
  {"ldapr","load-acquire rcpc register"}, 
  {"ldaprb","load-acquire rcpc register byte"}, 
  {"ldaprh","load-acquire rcpc register halfword"}, 
  {"ldapur","load-acquire rcpc register (unscaled)"}, 
  {"ldapurb","load-acquire rcpc register byte (unscaled)"}, 
  {"ldapurh","load-acquire rcpc register halfword (unscaled)"}, 
  {"ldapursb","load-acquire rcpc register signed byte (unscaled)"}, 
  {"ldapursh","load-acquire rcpc register signed halfword (unscaled)"}, 
  {"ldapursw","load-acquire rcpc register signed word (unscaled)"}, 
  {"ldar","load-acquire register"}, 
  {"ldarb","load-acquire register byte"}, 
  {"ldarh","load-acquire register halfword"}, 
  {"ldaxp","load-acquire exclusive pair of registers"}, 
  {"ldaxr","load-acquire exclusive register"}, 
  {"ldaxrb","load-acquire exclusive register byte"}, 
  {"ldaxrh","load-acquire exclusive register halfword"}, 
  {"ldc","load from memory to coprocessor"}, 
  {"ldclr","atomic bit clear on word or doubleword in memory"}, 
  {"ldclra","atomic bit clear on word or doubleword in memory"}, 
  {"ldclrab","atomic bit clear on byte in memory"}, 
  {"ldclrah","atomic bit clear on halfword in memory"}, 
  {"ldclral","atomic bit clear on word or doubleword in memory"}, 
  {"ldclralb","atomic bit clear on byte in memory"}, 
  {"ldclralh","atomic bit clear on halfword in memory"}, 
  {"ldclrb","atomic bit clear on byte in memory"}, 
  {"ldclrh","atomic bit clear on halfword in memory"}, 
  {"ldclrl","atomic bit clear on word or doubleword in memory"}, 
  {"ldclrlb","atomic bit clear on byte in memory"}, 
  {"ldclrlh","atomic bit clear on halfword in memory"}, 
  {"ldeor","atomic exclusive or on word or doubleword in memory"}, 
  {"ldeora","atomic exclusive or on word or doubleword in memory"}, 
  {"ldeorab","atomic exclusive or on byte in memory"}, 
  {"ldeorah","atomic exclusive or on halfword in memory"}, 
  {"ldeoral","atomic exclusive or on word or doubleword in memory"}, 
  {"ldeoralb","atomic exclusive or on byte in memory"}, 
  {"ldeoralh","atomic exclusive or on halfword in memory"}, 
  {"ldeorb","atomic exclusive or on byte in memory"}, 
  {"ldeorh","atomic exclusive or on halfword in memory"}, 
  {"ldeorl","atomic exclusive or on word or doubleword in memory"}, 
  {"ldeorlb","atomic exclusive or on byte in memory"}, 
  {"ldeorlh","atomic exclusive or on halfword in memory"}, 
  {"ldf","armfpu: load float value pointed by reg+(offset): ldf f0, [r0,#off]"}, 
  {"ldg","load allocation tag"}, 
  {"ldgm","load tag multiple"}, 
  {"ldlar","load loacquire register"}, 
  {"ldlarb","load loacquire register byte"}, 
  {"ldlarh","load loacquire register halfword"}, 
  {"ldm","load to multiple registers from memory"}, 
  {"ldm.w","load multiple words from memory into registers"}, 
  {"ldmda","decrement after"}, 
  {"ldmdb","decrement before"}, 
  {"ldmia","incrememnt after"}, 
  {"ldmib","increment before"}, 
  {"ldnp","load pair of registers, with non-temporal hint"}, 
  {"ldp","load a pair of registers from memory"}, 
  {"ldpsw","load pair of registers signed word"}, 
  {"ldr","load register"}, 
  {"ldr.w","load from memory to register"}, 
  {"ldraa","load from memory to register authenticanting the pointer using A key"}, 
  {"ldrab","load from memory to register authenticanting the pointer using B key"}, 
  {"ldrb","load byte from memory to register"}, 
  {"ldrb.w","load from memory to register"}, 
  {"ldreq","load from memory to register if Z set (equal)"}, 
  {"ldrh","load half word (16bit) from memory to register"}, 
  {"ldrne","load from memory to register if Z clear (not equal)"}, 
  {"ldrsb","load register signed byte"}, 
  {"ldrsh","load register signed halfword"}, 
  {"ldrsw","load register signed word"}, 
  {"ldset","atomic bit set on word or doubleword in memory"}, 
  {"ldseta","atomic bit set on word or doubleword in memory"}, 
  {"ldsetab","atomic bit set on byte in memory"}, 
  {"ldsetah","atomic bit set on halfword in memory"}, 
  {"ldsetal","atomic bit set on word or doubleword in memory"}, 
  {"ldsetalb","atomic bit set on byte in memory"}, 
  {"ldsetalh","atomic bit set on halfword in memory"}, 
  {"ldsetb","atomic bit set on byte in memory"}, 
  {"ldseth","atomic bit set on halfword in memory"}, 
  {"ldsetl","atomic bit set on word or doubleword in memory"}, 
  {"ldsetlb","atomic bit set on byte in memory"}, 
  {"ldsetlh","atomic bit set on halfword in memory"}, 
  {"ldsmax","atomic signed maximum on word or doubleword in memory"}, 
  {"ldsmaxa","atomic signed maximum on word or doubleword in memory"}, 
  {"ldsmaxab","atomic signed maximum on byte in memory"}, 
  {"ldsmaxah","atomic signed maximum on halfword in memory"}, 
  {"ldsmaxal","atomic signed maximum on word or doubleword in memory"}, 
  {"ldsmaxalb","atomic signed maximum on byte in memory"}, 
  {"ldsmaxalh","atomic signed maximum on halfword in memory"}, 
  {"ldsmaxb","atomic signed maximum on byte in memory"}, 
  {"ldsmaxh","atomic signed maximum on halfword in memory"}, 
  {"ldsmaxl","atomic signed maximum on word or doubleword in memory"}, 
  {"ldsmaxlb","atomic signed maximum on byte in memory"}, 
  {"ldsmaxlh","atomic signed maximum on halfword in memory"}, 
  {"ldsmin","atomic signed minimum on word or doubleword in memory"}, 
  {"ldsmina","atomic signed minimum on word or doubleword in memory"}, 
  {"ldsminab","atomic signed minimum on byte in memory"}, 
  {"ldsminah","atomic signed minimum on halfword in memory"}, 
  {"ldsminal","atomic signed minimum on word or doubleword in memory"}, 
  {"ldsminalb","atomic signed minimum on byte in memory"}, 
  {"ldsminalh","atomic signed minimum on halfword in memory"}, 
  {"ldsminb","atomic signed minimum on byte in memory"}, 
  {"ldsminh","atomic signed minimum on halfword in memory"}, 
  {"ldsminl","atomic signed minimum on word or doubleword in memory"}, 
  {"ldsminlb","atomic signed minimum on byte in memory"}, 
  {"ldsminlh","atomic signed minimum on halfword in memory"}, 
  {"ldtr","load register (unprivileged)"}, 
  {"ldtrb","load register byte (unprivileged)"}, 
  {"ldtrh","load register halfword (unprivileged)"}, 
  {"ldtrsb","load register signed byte (unprivileged)"}, 
  {"ldtrsh","load register signed halfword (unprivileged)"}, 
  {"ldtrsw","load register signed word (unprivileged)"}, 
  {"ldumax","atomic unsigned maximum on word or doubleword in memory"}, 
  {"ldumaxa","atomic unsigned maximum on word or doubleword in memory"}, 
  {"ldumaxab","atomic unsigned maximum on byte in memory"}, 
  {"ldumaxah","atomic unsigned maximum on halfword in memory"}, 
  {"ldumaxal","atomic unsigned maximum on word or doubleword in memory"}, 
  {"ldumaxalb","atomic unsigned maximum on byte in memory"}, 
  {"ldumaxalh","atomic unsigned maximum on halfword in memory"}, 
  {"ldumaxb","atomic unsigned maximum on byte in memory"}, 
  {"ldumaxh","atomic unsigned maximum on halfword in memory"}, 
  {"ldumaxl","atomic unsigned maximum on word or doubleword in memory"}, 
  {"ldumaxlb","atomic unsigned maximum on byte in memory"}, 
  {"ldumaxlh","atomic unsigned maximum on halfword in memory"}, 
  {"ldumin","atomic unsigned minimum on word or doubleword in memory"}, 
  {"ldumina","atomic unsigned minimum on word or doubleword in memory"}, 
  {"lduminab","atomic unsigned minimum on byte in memory"}, 
  {"lduminah","atomic unsigned minimum on halfword in memory"}, 
  {"lduminal","atomic unsigned minimum on word or doubleword in memory"}, 
  {"lduminalb","atomic unsigned minimum on byte in memory"}, 
  {"lduminalh","atomic unsigned minimum on halfword in memory"}, 
  {"lduminb","atomic unsigned minimum on byte in memory"}, 
  {"lduminh","atomic unsigned minimum on halfword in memory"}, 
  {"lduminl","atomic unsigned minimum on word or doubleword in memory"}, 
  {"lduminlb","atomic unsigned minimum on byte in memory"}, 
  {"lduminlh","atomic unsigned minimum on halfword in memory"}, 
  {"ldur","load register (unscaled)"}, 
  {"ldurb","load register byte (unscaled)"}, 
  {"ldurh","load register halfword (unscaled)"}, 
  {"ldursb","load register signed byte (unscaled)"}, 
  {"ldursh","load register signed halfword (unscaled)"}, 
  {"ldursw","load register signed word (unscaled)"}, 
  {"ldxp","load exclusive pair of registers"}, 
  {"ldxr","load exclusive register"}, 
  {"ldxrb","load exclusive register byte"}, 
  {"ldxrh","load exclusive register halfword"}, 
  {"lsl","logical shift left"}, 
  {"lsls","logical shift left and update flags"}, 
  {"lslv","logical shift left variable"}, 
  {"lsr","logical shift right"}, 
  {"lsrs","logical shift right and update flags"}, 
  {"lsrv","logical shift right variable"}, 
  {"madd","multiply-add"}, 
  {"mcr","move to coprocessor from ARM register"}, 
  {"mcrr","move to coprocessor from two ARM register"}, 
  {"mla","multiply and accumulate"}, 
  {"mls","multiply and substract"}, 
  {"mneg","multiply-negate: an alias of msub"}, 
  {"mov","move value between registers"}, 
  {"mov.w","move 3byte immediate into register"}, 
  {"movk","move wide with keep"}, 
  {"movn","move wide with not"}, 
  {"movs","move immediate into register and update flags"}, 
  {"movt","write 16 bit value on top of halfword"}, 
  {"movw","write 16 bit value on lower bits"}, 
  {"movz","move shifted 16-bit immediate to register."}, 
  {"mrs","move system register"}, 
  {"msr","move general-purpose register to system register"}, 
  {"msub","multiply-subtract"}, 
  {"mul","multiply"}, 
  {"mvn","move bitwise NOT"}, 
  {"mvns","move bitwise NOT and update flags"}, 
  {"neg","negate: an alias of sub"}, 
  {"negs","negate, setting flags: an alias of subs"}, 
  {"ngc","negate with carry: an alias of sbc"}, 
  {"ngcs","negate with carry, setting flags: an alias of sbcs"}, 
  {"nop","no operation"}, 
  {"orn","bitwise or not"}, 
  {"orr","logical inclusive OR"}, 
  {"orreq","logical inclusive OR if Z set (equal)"}, 
  {"orrne","logical inclusive OR if Z clear (not equal)"}, 
  {"orrs","logical inclusive OR and update flags"}, 
  {"pacda","pointer authentication code for data address, using key a"}, 
  {"pacdb","pointer authentication code for data address, using key b"}, 
  {"pacdza","pointer authentication code for data address, using key a"}, 
  {"pacdzb","pointer authentication code for data address, using key b"}, 
  {"pacga","pointer authentication code, using generic key"}, 
  {"pacia","pointer authentication code for instruction address, using key a"}, 
  {"pacia1716","pointer authentication code for instruction address, using key a"}, 
  {"paciasp","function prelude for pointer authentication using A key"}, 
  {"paciaz","pointer authentication code for instruction address, using key a"}, 
  {"pacib","pointer authentication code for instruction address, using key b"}, 
  {"pacib1716","pointer authentication code for instruction address, using key b"}, 
  {"pacibsp","function prelude for pointer authentication using B key"}, 
  {"pacibz","pointer authentication code for instruction address, using key b"}, 
  {"paciza","pointer authentication code for instruction address, using key a"}, 
  {"pacizb","pointer authentication code for instruction address, using key b"}, 
  {"pop","load N elements from stack into given registers"}, 
  {"pop.w","load N words from stack into registers"}, 
  {"prfm","prefetch memory (literal)"}, 
  {"prfum","prefetch memory (unscaled offset)"}, 
  {"psb","profiling synchronization barrier"}, 
  {"pssbb","physical speculative store bypass barrier: an alias of dsb"}, 
  {"rbit","reverse bits"}, 
  {"ret","return from subroutine"}, 
  {"retaa","return with authenticated pointer using A key"}, 
  {"retab","return with authenticated pointer using B key"}, 
  {"rev","reverse bytes"}, 
  {"rev16","reverse bytes in 16-bit halfwords"}, 
  {"rev32","reverse bytes in 32-bit words"}, 
  {"rev64","reverse bytes: an alias of rev"}, 
  {"rfe","return from exception (loads pc+cpsr)"}, 
  {"rmif","rotate, mask insert flags"}, 
  {"ror","rotate right: an alias of rorv"}, 
  {"rorv","rotate right variable"}, 
  {"rsb","reverse substract"}, 
  {"rsbs","subtracts the value from zero, producing the arithmetic negative of the value, and updates flags"}, 
  {"rsbs.w","substract the negative value"}, 
  {"rsc","reverse substract with carry"}, 
  {"sb","speculation barrier"}, 
  {"sbc","substract with carry"}, 
  {"sbcs","subtract with carry, setting flags"}, 
  {"sbfiz","signed bitfield insert in zero: an alias of sbfm"}, 
  {"sbfm","signed bitfield move"}, 
  {"sbfx","signed bit field extract"}, 
  {"sdiv","signed division"}, 
  {"setf16","evaluation of 8 or 16 bit flag values"}, 
  {"setf8","evaluation of 8 or 16 bit flag values"}, 
  {"sev","send event"}, 
  {"sevl","send event local"}, 
  {"smaddl","signed multiply-add long"}, 
  {"smc","secure monitor call"}, 
  {"smnegl","signed multiply-negate long: an alias of smsubl"}, 
  {"smsubl","signed multiply-subtract long"}, 
  {"smulh","signed multiply high"}, 
  {"smull","signed multiply long: an alias of smaddl"}, 
  {"srs","store return state"}, 
  {"ssbb","speculative store bypass barrier: an alias of dsb"}, 
  {"st2g","store allocation tags"}, 
  {"st64b","single-copy atomic 64-byte store without return"}, 
  {"st64bv","single-copy atomic 64-byte store with return"}, 
  {"st64bv0","single-copy atomic 64-byte el0 store with return"}, 
  {"stadd","atomic add word (arm v8.1)"}, 
  {"staddb","atomic add on byte in memory, without return: an alias of ldaddb, ldaddab, ldaddalb, ldaddlb"}, 
  {"staddh","atomic add on halfword in memory, without return: an alias of ldaddh, ldaddah, ldaddalh, ldaddlh"}, 
  {"staddl","atomic add dword (arm v8.1)"}, 
  {"staddlb","atomic add on byte in memory, without return: an alias of ldaddb, ldaddab, ldaddalb, ldaddlb"}, 
  {"staddlh","atomic add on halfword in memory, without return: an alias of ldaddh, ldaddah, ldaddalh, ldaddlh"}, 
  {"stc","store from coprocessor to memory"}, 
  {"stclr","atomic bit clear on word or doubleword in memory, without return: an alias of ldclr, ldclra, ldclral, ldclrl"}, 
  {"stclrb","atomic bit clear on byte in memory, without return: an alias of ldclrb, ldclrab, ldclralb, ldclrlb"}, 
  {"stclrh","atomic bit clear on halfword in memory, without return: an alias of ldclrh, ldclrah, ldclralh, ldclrlh"}, 
  {"stclrl","atomic bit clear on word or doubleword in memory, without return: an alias of ldclr, ldclra, ldclral, ldclrl"}, 
  {"stclrlb","atomic bit clear on byte in memory, without return: an alias of ldclrb, ldclrab, ldclralb, ldclrlb"}, 
  {"stclrlh","atomic bit clear on halfword in memory, without return: an alias of ldclrh, ldclrah, ldclralh, ldclrlh"}, 
  {"steor","atomic exclusive or on word or doubleword in memory, without return: an alias of ldeor, ldeora, ldeoral, ldeorl"}, 
  {"steorb","atomic exclusive or on byte in memory, without return: an alias of ldeorb, ldeorab, ldeoralb, ldeorlb"}, 
  {"steorh","atomic exclusive or on halfword in memory, without return: an alias of ldeorh, ldeorah, ldeoralh, ldeorlh"}, 
  {"steorl","atomic exclusive or on word or doubleword in memory, without return: an alias of ldeor, ldeora, ldeoral, ldeorl"}, 
  {"steorlb","atomic exclusive or on byte in memory, without return: an alias of ldeorb, ldeorab, ldeoralb, ldeorlb"}, 
  {"steorlh","atomic exclusive or on halfword in memory, without return: an alias of ldeorh, ldeorah, ldeoralh, ldeorlh"}, 
  {"stf","armfpu: store float value pointed by reg+(offset): ldf [r0,#off]"}, 
  {"stg","store allocation tag"}, 
  {"stgm","store tag multiple"}, 
  {"stgp","store allocation tag and pair of registers"}, 
  {"stllr","store lorelease register"}, 
  {"stllrb","store lorelease register byte"}, 
  {"stllrh","store lorelease register halfword"}, 
  {"stlr","store-release register"}, 
  {"stlrb","store-release register byte"}, 
  {"stlrh","store-release register halfword"}, 
  {"stlur","store-release register (unscaled)"}, 
  {"stlurb","store-release register byte (unscaled)"}, 
  {"stlurh","store-release register halfword (unscaled)"}, 
  {"stlxp","store-release exclusive pair of registers"}, 
  {"stlxr","store-release exclusive register"}, 
  {"stlxrb","store-release exclusive register byte"}, 
  {"stlxrh","store-release exclusive register halfword"}, 
  {"stm","store multiple registers to memory"}, 
  {"stnp","store pair of registers, with non-temporal hint"}, 
  {"stp","store register pairs in memory"}, 
  {"str","store register into memory"}, 
  {"strb","store byte value in register into memory"}, 
  {"strb.w","store byte value in register into memory"}, 
  {"strd","store floating point value in memory"}, 
  {"streq","store register into memory if Z set (equal)"}, 
  {"strh","store byte value in register into memory"}, 
  {"strh.w","store byte value in register into memory"}, 
  {"strne","store register into memory if Z clear (not equal)"}, 
  {"stset","atomic bit set on word or doubleword in memory, without return: an alias of ldset, ldseta, ldsetal, ldsetl"}, 
  {"stsetb","atomic bit set on byte in memory, without return: an alias of ldsetb, ldsetab, ldsetalb, ldsetlb"}, 
  {"stseth","atomic bit set on halfword in memory, without return: an alias of ldseth, ldsetah, ldsetalh, ldsetlh"}, 
  {"stsetl","atomic bit set on word or doubleword in memory, without return: an alias of ldset, ldseta, ldsetal, ldsetl"}, 
  {"stsetlb","atomic bit set on byte in memory, without return: an alias of ldsetb, ldsetab, ldsetalb, ldsetlb"}, 
  {"stsetlh","atomic bit set on halfword in memory, without return: an alias of ldseth, ldsetah, ldsetalh, ldsetlh"}, 
  {"stsmax","atomic signed maximum on word or doubleword in memory, without return: an alias of ldsmax, ldsmaxa, ldsmaxal, ldsmaxl"}, 
  {"stsmaxb","atomic signed maximum on byte in memory, without return: an alias of ldsmaxb, ldsmaxab, ldsmaxalb, ldsmaxlb"}, 
  {"stsmaxh","atomic signed maximum on halfword in memory, without return: an alias of ldsmaxh, ldsmaxah, ldsmaxalh, ldsmaxlh"}, 
  {"stsmaxl","atomic signed maximum on word or doubleword in memory, without return: an alias of ldsmax, ldsmaxa, ldsmaxal, ldsmaxl"}, 
  {"stsmaxlb","atomic signed maximum on byte in memory, without return: an alias of ldsmaxb, ldsmaxab, ldsmaxalb, ldsmaxlb"}, 
  {"stsmaxlh","atomic signed maximum on halfword in memory, without return: an alias of ldsmaxh, ldsmaxah, ldsmaxalh, ldsmaxlh"}, 
  {"stsmin","atomic signed minimum on word or doubleword in memory, without return: an alias of ldsmin, ldsmina, ldsminal, ldsminl"}, 
  {"stsminb","atomic signed minimum on byte in memory, without return: an alias of ldsminb, ldsminab, ldsminalb, ldsminlb"}, 
  {"stsminh","atomic signed minimum on halfword in memory, without return: an alias of ldsminh, ldsminah, ldsminalh, ldsminlh"}, 
  {"stsminl","atomic signed minimum on word or doubleword in memory, without return: an alias of ldsmin, ldsmina, ldsminal, ldsminl"}, 
  {"stsminlb","atomic signed minimum on byte in memory, without return: an alias of ldsminb, ldsminab, ldsminalb, ldsminlb"}, 
  {"stsminlh","atomic signed minimum on halfword in memory, without return: an alias of ldsminh, ldsminah, ldsminalh, ldsminlh"}, 
  {"sttr","store register (unprivileged)"}, 
  {"sttrb","store register byte (unprivileged)"}, 
  {"sttrh","store register halfword (unprivileged)"}, 
  {"stumax","atomic unsigned maximum on word or doubleword in memory, without return: an alias of ldumax, ldumaxa, ldumaxal, ldumaxl"}, 
  {"stumaxb","atomic unsigned maximum on byte in memory, without return: an alias of ldumaxb, ldumaxab, ldumaxalb, ldumaxlb"}, 
  {"stumaxh","atomic unsigned maximum on halfword in memory, without return: an alias of ldumaxh, ldumaxah, ldumaxalh, ldumaxlh"}, 
  {"stumaxl","atomic unsigned maximum on word or doubleword in memory, without return: an alias of ldumax, ldumaxa, ldumaxal, ldumaxl"}, 
  {"stumaxlb","atomic unsigned maximum on byte in memory, without return: an alias of ldumaxb, ldumaxab, ldumaxalb, ldumaxlb"}, 
  {"stumaxlh","atomic unsigned maximum on halfword in memory, without return: an alias of ldumaxh, ldumaxah, ldumaxalh, ldumaxlh"}, 
  {"stumin","atomic unsigned minimum on word or doubleword in memory, without return: an alias of ldumin, ldumina, lduminal, lduminl"}, 
  {"stuminb","atomic unsigned minimum on byte in memory, without return: an alias of lduminb, lduminab, lduminalb, lduminlb"}, 
  {"stuminh","atomic unsigned minimum on halfword in memory, without return: an alias of lduminh, lduminah, lduminalh, lduminlh"}, 
  {"stuminl","atomic unsigned minimum on word or doubleword in memory, without return: an alias of ldumin, ldumina, lduminal, lduminl"}, 
  {"stuminlb","atomic unsigned minimum on byte in memory, without return: an alias of lduminb, lduminab, lduminalb, lduminlb"}, 
  {"stuminlh","atomic unsigned minimum on halfword in memory, without return: an alias of lduminh, lduminah, lduminalh, lduminlh"}, 
  {"stur","store register (unscaled)"}, 
  {"sturb","store register byte (unscaled)"}, 
  {"sturh","store register halfword (unscaled)"}, 
  {"stxp","store exclusive pair of registers"}, 
  {"stxr","store exclusive register"}, 
  {"stxrb","store exclusive register byte"}, 
  {"stxrh","store exclusive register halfword"}, 
  {"stz2g","store allocation tags, zeroing"}, 
  {"stzg","store allocation tag, zeroing"}, 
  {"stzgm","store tag and zero multiple"}, 
  {"sub","substract two values"}, 
  {"subeq","substract two values if Z set (equal)"}, 
  {"subg","subtract with tag"}, 
  {"subne","substract two values if Z clear (not equal)"}, 
  {"subp","subtract pointer"}, 
  {"subps","subtract pointer, setting flags"}, 
  {"subs","substract two values and update flags"}, 
  {"svc","supervisor call"}, 
  {"swp","swap word or doubleword in memory"}, 
  {"swpa","swap word or doubleword in memory"}, 
  {"swpab","swap byte in memory"}, 
  {"swpah","swap halfword in memory"}, 
  {"swpal","swap word or doubleword in memory"}, 
  {"swpalb","swap byte in memory"}, 
  {"swpalh","swap halfword in memory"}, 
  {"swpb","swap byte in memory"}, 
  {"swph","swap halfword in memory"}, 
  {"swpl","swap word or doubleword in memory"}, 
  {"swplb","swap byte in memory"}, 
  {"swplh","swap halfword in memory"}, 
  {"sxtb","extracts bits[7:0] and sign extends to 32 bits."}, 
  {"sxth","extracts bits[15:0] and sign extends to 32 bits."}, 
  {"sxtw","signed extend word"}, 
  {"sys","system instruction"}, 
  {"sysl","system instruction with result"}, 
  {"tbnz","test bit and branch if nonzero"}, 
  {"tbz","test bit and branch if zero"}, 
  {"teq","test equivalence"}, 
  {"tlbi","tlb invalidate operation: an alias of sys"}, 
  {"tsb","trace synchronization barrier"}, 
  {"tst","test"}, 
  {"tst.w","logical AND register value with 12-bit immediate value"}, 
  {"ubfiz","unsigned bitfield insert in zero: an alias of ubfm"}, 
  {"ubfm","unsigned bitfield move"}, 
  {"ubfx","unsigned bit field extract"}, 
  {"udf","permanently undefined"}, 
  {"udiv","unsigned division"}, 
  {"umaddl","unsigned multiply-add long"}, 
  {"umnegl","unsigned multiply-negate long: an alias of umsubl"}, 
  {"umsubl","unsigned multiply-subtract long"}, 
  {"umulh","unsigned multiply high"}, 
  {"umull","unsigned multiply long: an alias of umaddl"}, 
  {"uxtab","zero extend byte to word, add"}, 
  {"uxtab16","zero extend bytes to halfwords add halfwords"}, 
  {"uxtb","extracts bits[7:0] and zero extends to 32 bits."}, 
  {"uxtb.w","zero textend word and add, extend to 32bit value"}, 
  {"uxth","extracts bits[15:0] and zero extends to 32 bits."}, 
  {"vadd","vector add"}, 
  {"vldmia","vector load memory into paired registers"}, 
  {"vsri","vector shift right and insert"}, 
  {"wfe","wait for event"}, 
  {"wfet","wait for event with timeout"}, 
  {"wfi","wait for interrupt"}, 
  {"wfit","wait for interrupt with timeout"}, 
  {"wfs","armfpu: write fp status register. wfs r0"}, 
  {"xaflag","convert floating-point condition flags from external format to arm format"}, 
  {"xpacd","strip pac from data pointer"}, 
  {"xpaci","strip pac from instruction pointer"}, 
  {"xpaclri","system strip pointer authentication"}, 
  {"yield","alias for hint instructrion"}, 
  {NULL, NULL}
};
// 0x562ac7fd00b0
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_arm_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_arm_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_arm(x,y) gperf_arm_hash(x)
const unsigned int gperf_arm_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_arm = {
  .name = "arm",
  .get = &gperf_arm_get,
  .hash = &gperf_arm_hash,
  .foreach = &gperf_arm_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_arm.get)("foo");
	printf ("%s\n", s);
}
#endif
