// SDB-CGEN V1.8.2
// gcc -DMAIN=1 openbsd_x86_32.c ; ./a.out > openbsd_x86_32.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"__getcwd","0x80,304,2,"}, 
  {"__semctl","0x80,295,4,"}, 
  {"__syscall","0x80,198,2,"}, 
  {"__sysctl","0x80,202,6,"}, 
  {"accept","0x80,30,3,"}, 
  {"access","0x80,33,2,"}, 
  {"acct","0x80,51,1,"}, 
  {"adjfreq","0x80,305,2,"}, 
  {"adjtime","0x80,140,2,"}, 
  {"bind","0x80,104,3,"}, 
  {"break","0x80,17,1,"}, 
  {"chdir","0x80,12,1,"}, 
  {"chflags","0x80,34,2,"}, 
  {"chmod","0x80,15,2,"}, 
  {"chown","0x80,16,3,"}, 
  {"chroot","0x80,61,1,"}, 
  {"clock_getres","0x80,234,2,"}, 
  {"clock_gettime","0x80,232,2,"}, 
  {"clock_settime","0x80,233,2,"}, 
  {"close","0x80,6,1,"}, 
  {"closefrom","0x80,287,1,"}, 
  {"connect","0x80,98,3,"}, 
  {"dup","0x80,41,1,"}, 
  {"dup2","0x80,90,2,"}, 
  {"execve","0x80,59,3,"}, 
  {"exit","0x80,1,1,"}, 
  {"fchdir","0x80,13,1,"}, 
  {"fchflags","0x80,35,2,"}, 
  {"fchmod","0x80,124,2,"}, 
  {"fchown","0x80,123,3,"}, 
  {"fcntl","0x80,92,3,"}, 
  {"fhopen","0x80,264,2,"}, 
  {"fhstat","0x80,294,2,"}, 
  {"fhstatfs","0x80,309,2,"}, 
  {"flock","0x80,131,2,"}, 
  {"fork","0x80,2,0,"}, 
  {"fpathconf","0x80,192,2,"}, 
  {"fstat","0x80,292,2,"}, 
  {"fstatfs","0x80,308,2,"}, 
  {"fsync","0x80,95,1,"}, 
  {"ftruncate","0x80,201,3,"}, 
  {"futimes","0x80,206,2,"}, 
  {"getdirentries","0x80,196,4,"}, 
  {"getegid","0x80,43,0,"}, 
  {"geteuid","0x80,25,0,"}, 
  {"getfh","0x80,161,2,"}, 
  {"getfsstat","0x80,306,3,"}, 
  {"getgid","0x80,47,0,"}, 
  {"getgroups","0x80,79,2,"}, 
  {"getitimer","0x80,86,2,"}, 
  {"getlogin","0x80,49,2,"}, 
  {"getpeereid","0x80,273,3,"}, 
  {"getpeername","0x80,31,3,"}, 
  {"getpgid","0x80,207,1,"}, 
  {"getpgrp","0x80,81,0,"}, 
  {"getpid","0x80,20,0,"}, 
  {"getppid","0x80,39,0,"}, 
  {"getpriority","0x80,100,2,"}, 
  {"getresgid","0x80,283,3,"}, 
  {"getresuid","0x80,281,3,"}, 
  {"getrlimit","0x80,194,2,"}, 
  {"getrtable","0x80,311,0,"}, 
  {"getrusage","0x80,117,2,"}, 
  {"getsid","0x80,255,1,"}, 
  {"getsockname","0x80,32,3,"}, 
  {"getsockopt","0x80,118,5,"}, 
  {"getthrid","0x80,299,0,"}, 
  {"gettimeofday","0x80,116,2,"}, 
  {"getuid","0x80,24,0,"}, 
  {"ioctl","0x80,54,3,"}, 
  {"issetugid","0x80,253,0,"}, 
  {"kevent","0x80,270,6,"}, 
  {"kill","0x80,37,2,"}, 
  {"kqueue","0x80,269,0,"}, 
  {"ktrace","0x80,45,4,"}, 
  {"lchown","0x80,254,3,"}, 
  {"lfs_bmapv","0x80,184,3,"}, 
  {"lfs_markv","0x80,185,3,"}, 
  {"lfs_segclean","0x80,186,2,"}, 
  {"lfs_segwait","0x80,187,2,"}, 
  {"link","0x80,9,2,"}, 
  {"listen","0x80,106,2,"}, 
  {"lseek","0x80,199,4,"}, 
  {"lstat","0x80,293,2,"}, 
  {"madvise","0x80,75,3,"}, 
  {"mincore","0x80,78,3,"}, 
  {"minherit","0x80,250,3,"}, 
  {"mkdir","0x80,136,2,"}, 
  {"mkfifo","0x80,132,2,"}, 
  {"mknod","0x80,14,3,"}, 
  {"mlock","0x80,203,2,"}, 
  {"mlockall","0x80,271,1,"}, 
  {"mmap","0x80,197,7,"}, 
  {"mount","0x80,21,4,"}, 
  {"mprotect","0x80,74,3,"}, 
  {"mquery","0x80,286,7,"}, 
  {"msgctl","0x80,297,3,"}, 
  {"msgget","0x80,225,2,"}, 
  {"msgrcv","0x80,227,5,"}, 
  {"msgsnd","0x80,226,4,"}, 
  {"msync","0x80,256,3,"}, 
  {"munlock","0x80,204,2,"}, 
  {"munlockall","0x80,272,0,"}, 
  {"munmap","0x80,73,2,"}, 
  {"nanosleep","0x80,240,2,"}, 
  {"nfssvc","0x80,155,2,"}, 
  {"nnpfspioctl","0x80,208,5,"}, 
  {"open","0x80,5,3,"}, 
  {"opipe","0x80,42,0,"}, 
  {"osigaltstack","0x80,53,2,"}, 
  {"pathconf","0x80,191,2,"}, 
  {"pipe","0x80,263,1,"}, 
  {"poll","0x80,252,3,"}, 
  {"pread","0x80,173,5,"}, 
  {"preadv","0x80,267,5,"}, 
  {"profil","0x80,44,4,"}, 
  {"ptrace","0x80,26,4,"}, 
  {"pwrite","0x80,174,5,"}, 
  {"pwritev","0x80,268,5,"}, 
  {"quotactl","0x80,148,4,"}, 
  {"read","0x80,3,3,"}, 
  {"readlink","0x80,58,3,"}, 
  {"readv","0x80,120,3,"}, 
  {"reboot","0x80,55,1,"}, 
  {"recvfrom","0x80,29,6,"}, 
  {"recvmsg","0x80,27,3,"}, 
  {"rename","0x80,128,2,"}, 
  {"revoke","0x80,56,1,"}, 
  {"rfork","0x80,251,1,"}, 
  {"rmdir","0x80,137,1,"}, 
  {"sbrk","0x80,69,1,"}, 
  {"sched_yield","0x80,298,0,"}, 
  {"select","0x80,93,5,"}, 
  {"semget","0x80,221,3,"}, 
  {"semop","0x80,290,3,"}, 
  {"sendmsg","0x80,28,3,"}, 
  {"sendto","0x80,133,6,"}, 
  {"setegid","0x80,182,1,"}, 
  {"seteuid","0x80,183,1,"}, 
  {"setgid","0x80,181,1,"}, 
  {"setgroups","0x80,80,2,"}, 
  {"setitimer","0x80,83,3,"}, 
  {"setlogin","0x80,50,1,"}, 
  {"setpgid","0x80,82,2,"}, 
  {"setpriority","0x80,96,3,"}, 
  {"setregid","0x80,127,2,"}, 
  {"setresgid","0x80,284,3,"}, 
  {"setresuid","0x80,282,3,"}, 
  {"setreuid","0x80,126,2,"}, 
  {"setrlimit","0x80,195,2,"}, 
  {"setrtable","0x80,310,1,"}, 
  {"setsid","0x80,147,0,"}, 
  {"setsockopt","0x80,105,5,"}, 
  {"settimeofday","0x80,122,2,"}, 
  {"setuid","0x80,23,1,"}, 
  {"shmat","0x80,228,3,"}, 
  {"shmctl","0x80,296,3,"}, 
  {"shmdt","0x80,230,1,"}, 
  {"shmget","0x80,289,3,"}, 
  {"shutdown","0x80,134,2,"}, 
  {"sigaction","0x80,46,3,"}, 
  {"sigaltstack","0x80,288,2,"}, 
  {"sigpending","0x80,52,0,"}, 
  {"sigprocmask","0x80,48,2,"}, 
  {"sigreturn","0x80,103,1,"}, 
  {"sigsuspend","0x80,111,1,"}, 
  {"socket","0x80,97,3,"}, 
  {"socketpair","0x80,135,4,"}, 
  {"sstk","0x80,70,1,"}, 
  {"stat","0x80,291,2,"}, 
  {"statfs","0x80,307,2,"}, 
  {"swapctl","0x80,193,3,"}, 
  {"symlink","0x80,57,2,"}, 
  {"sync","0x80,36,0,"}, 
  {"sysarch","0x80,165,2,"}, 
  {"syscall","0x80,0,2,"}, 
  {"threxit","0x80,302,1,"}, 
  {"thrsigdivert","0x80,303,3,"}, 
  {"thrsleep","0x80,300,4,"}, 
  {"thrwakeup","0x80,301,2,"}, 
  {"truncate","0x80,200,3,"}, 
  {"umask","0x80,60,1,"}, 
  {"unlink","0x80,10,1,"}, 
  {"unmount","0x80,22,2,"}, 
  {"utimes","0x80,138,2,"}, 
  {"vfork","0x80,66,0,"}, 
  {"wait4","0x80,7,4,"}, 
  {"write","0x80,4,3,"}, 
  {"writev","0x80,121,3,"}, 
  {NULL, NULL}
};
// 0x562c54b76550
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_openbsd_x86_32_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_openbsd_x86_32_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_openbsd_x86_32(x,y) gperf_openbsd_x86_32_hash(x)
const unsigned int gperf_openbsd_x86_32_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_openbsd_x86_32 = {
  .name = "openbsd-x86-32",
  .get = &gperf_openbsd_x86_32_get,
  .hash = &gperf_openbsd_x86_32_hash,
  .foreach = &gperf_openbsd_x86_32_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_openbsd_x86_32.get)("foo");
	printf ("%s\n", s);
}
#endif
