// SDB-CGEN V1.8.2
// gcc -DMAIN=1 s110_arm_16.c ; ./a.out > s110_arm_16.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"_","-1"}, 
  {"application_0","0,0"}, 
  {"application_1","1,0"}, 
  {"application_10","10,0"}, 
  {"application_11","11,0"}, 
  {"application_12","12,0"}, 
  {"application_13","13,0"}, 
  {"application_14","14,0"}, 
  {"application_15","15,0"}, 
  {"application_2","2,0"}, 
  {"application_3","3,0"}, 
  {"application_4","4,0"}, 
  {"application_5","5,0"}, 
  {"application_6","6,0"}, 
  {"application_7","7,7"}, 
  {"application_8","8,0"}, 
  {"application_9","9,0"}, 
  {"sd_app_evt_wait","0x48,0"}, 
  {"sd_ble_enable","0x60,0,1"}, 
  {"sd_ble_evt_get","0x61,0,2"}, 
  {"sd_ble_gap_address_get","0x71,0,1"}, 
  {"sd_ble_gap_address_set","0x70,0,2"}, 
  {"sd_ble_gap_adv_data_set","0x72,0,4"}, 
  {"sd_ble_gap_adv_start","0x73,0,1"}, 
  {"sd_ble_gap_adv_stop","0x74,0"}, 
  {"sd_ble_gap_appearance_get","0x79,0,1"}, 
  {"sd_ble_gap_appearance_set","0x78,0,1"}, 
  {"sd_ble_gap_auth_key_reply","0x80,0,3"}, 
  {"sd_ble_gap_authenticate","0x7e,0,2"}, 
  {"sd_ble_gap_conn_param_update","0x75,0,2"}, 
  {"sd_ble_gap_conn_sec_get","0x83,0,2"}, 
  {"sd_ble_gap_connect","0x88,0,3"}, 
  {"sd_ble_gap_connect_cancel","0x89,0"}, 
  {"sd_ble_gap_device_name_get","0x7d,0,2"}, 
  {"sd_ble_gap_device_name_set","0x7c,0,3"}, 
  {"sd_ble_gap_disconnect","0x76,0,2"}, 
  {"sd_ble_gap_encrypt","0x81,0,3"}, 
  {"sd_ble_gap_ppcp_get","0x7b,0,1"}, 
  {"sd_ble_gap_ppcp_set","0x7a,0,1"}, 
  {"sd_ble_gap_rssi_get","0x8a,0,2"}, 
  {"sd_ble_gap_rssi_start","0x84,0,3"}, 
  {"sd_ble_gap_rssi_stop","0x85,0,1"}, 
  {"sd_ble_gap_scan_start","0x86,0,1"}, 
  {"sd_ble_gap_scan_stop","0x87,0"}, 
  {"sd_ble_gap_sec_info_reply","0x82,0,4"}, 
  {"sd_ble_gap_sec_params_reply","0x7f,0,4"}, 
  {"sd_ble_gap_tx_power_set","0x77,0,1"}, 
  {"sd_ble_gattc_char_value_by_uuid_read","0x94,0,3"}, 
  {"sd_ble_gattc_char_values_read","0x96,0,3"}, 
  {"sd_ble_gattc_characteristics_discover","0x92,0,2"}, 
  {"sd_ble_gattc_descriptors_discover","0x93,0,2"}, 
  {"sd_ble_gattc_hv_confirm","0x98,0,2"}, 
  {"sd_ble_gattc_primary_services_discover","0x90,0,3"}, 
  {"sd_ble_gattc_read","0x95,0,3"}, 
  {"sd_ble_gattc_relationships_discover","0x91,0,2"}, 
  {"sd_ble_gattc_write","0x97,0,2"}, 
  {"sd_ble_gatts_characteristic_add","0xa2,0,4"}, 
  {"sd_ble_gatts_descriptor_add","0xa3,0,3"}, 
  {"sd_ble_gatts_hvx","0xa6,0,2"}, 
  {"sd_ble_gatts_include_add","0xa1,0,3"}, 
  {"sd_ble_gatts_rw_authorize_reply","0xa8,0,2"}, 
  {"sd_ble_gatts_service_add","0xa0,0,3"}, 
  {"sd_ble_gatts_service_changed","0xa7,0,3"}, 
  {"sd_ble_gatts_sys_attr_get","0xaa,0,4"}, 
  {"sd_ble_gatts_sys_attr_set","0xa9,0,4"}, 
  {"sd_ble_gatts_value_get","0xa5,0,3"}, 
  {"sd_ble_gatts_value_set","0xa4,0,3"}, 
  {"sd_ble_l2cap_10","0xb9,0"}, 
  {"sd_ble_l2cap_11","0xba,0"}, 
  {"sd_ble_l2cap_12","0xbb,0"}, 
  {"sd_ble_l2cap_13","0xbe,0"}, 
  {"sd_ble_l2cap_14","0xbd,0"}, 
  {"sd_ble_l2cap_15","0xbe,0"}, 
  {"sd_ble_l2cap_16","0xbf,0"}, 
  {"sd_ble_l2cap_4","0xb3,0"}, 
  {"sd_ble_l2cap_5","0xb4,0"}, 
  {"sd_ble_l2cap_6","0xb5,0"}, 
  {"sd_ble_l2cap_7","0xb6,0"}, 
  {"sd_ble_l2cap_8","0xb7,0"}, 
  {"sd_ble_l2cap_9","0xb8,0"}, 
  {"sd_ble_l2cap_cid_register","0xb0,0,1"}, 
  {"sd_ble_l2cap_cid_unregister","0xb1,0,1"}, 
  {"sd_ble_l2cap_tx","0xb2,0,3"}, 
  {"sd_ble_opt_get","0x69,0,2"}, 
  {"sd_ble_opt_set","0x68,0,2"}, 
  {"sd_ble_tx_buffer_count_get","0x62,0,1"}, 
  {"sd_ble_user_mem_reply","0x67,0,2"}, 
  {"sd_ble_uuid_decode","0x64,0,3"}, 
  {"sd_ble_uuid_encode","0x65,0,3"}, 
  {"sd_ble_uuid_vs_add","0x63,0,2"}, 
  {"sd_ble_version_get","0x66,0,1"}, 
  {"sd_clock_hfclk_is_running","0x4b,0,1"}, 
  {"sd_clock_hfclk_release","0x4a,0"}, 
  {"sd_clock_hfclk_request","0x49,0"}, 
  {"sd_ecb_block_encrypt","0x4d,0,1"}, 
  {"sd_evt_get","0x51,0,1"}, 
  {"sd_flash_page_erase","0x28,0,1"}, 
  {"sd_flash_protect","0x2a,0,2"}, 
  {"sd_flash_write","0x29,0,3"}, 
  {"sd_mbr_command","0x14,0,1"}, 
  {"sd_mutex_acquire","0x2c,0,1"}, 
  {"sd_mutex_new","0x2b,0,1"}, 
  {"sd_mutex_release","0x2d,0,1"}, 
  {"sd_nvic_clearpendingirq","0x32,0,1"}, 
  {"sd_nvic_critical_region_enter","0x36,0,1"}, 
  {"sd_nvic_critical_region_exit","0x37,0,1"}, 
  {"sd_nvic_disableirq","0x2f,0,1"}, 
  {"sd_nvic_enableirq","0x2e,0,1"}, 
  {"sd_nvic_getpendingirq","0x30,0,2"}, 
  {"sd_nvic_getpriority","0x34,0,2"}, 
  {"sd_nvic_setpendingirq","0x31,0,1"}, 
  {"sd_nvic_setpriority","0x33,0,1"}, 
  {"sd_nvic_systemreset","0x35,0,2"}, 
  {"sd_power_dcdc_mode_set","0x47,0,1"}, 
  {"sd_power_gpregret_clr","0x45,0,1"}, 
  {"sd_power_gpregret_get","0x46,0,1"}, 
  {"sd_power_gpregret_set","0x44,0,1"}, 
  {"sd_power_mode_set","0x3b,0,1"}, 
  {"sd_power_pof_enable","0x3f,0,1"}, 
  {"sd_power_pof_threshold_set","0x40,0,1"}, 
  {"sd_power_ramon_clr","0x42,0,1"}, 
  {"sd_power_ramon_get","0x43,0,1"}, 
  {"sd_power_ramon_set","0x41,0,1"}, 
  {"sd_power_reset_reason_clr","0x3e,0,1"}, 
  {"sd_power_reset_reason_get","0x3d,0,1"}, 
  {"sd_power_system_off","0x3c,0"}, 
  {"sd_ppi_channel_assign","0x23,0,3"}, 
  {"sd_ppi_channel_enable_clr","0x22,0,1"}, 
  {"sd_ppi_channel_enable_get","0x20,0,1"}, 
  {"sd_ppi_channel_enable_set","0x21,0,1"}, 
  {"sd_ppi_group_assign","0x26,0,2"}, 
  {"sd_ppi_group_get","0x27,0,2"}, 
  {"sd_ppi_group_task_disable","0x25,0,1"}, 
  {"sd_ppi_group_task_enable","0x24,0,1"}, 
  {"sd_radio_notification_cfg_set","0x4c,0,2"}, 
  {"sd_radio_request","0x50,0,1"}, 
  {"sd_radio_session_close","0x4f,0"}, 
  {"sd_radio_session_open","0x4e,0,1"}, 
  {"sd_rand_application_bytes_available","0x39,0,1"}, 
  {"sd_rand_application_get_vector","0x3a,0,2"}, 
  {"sd_rand_application_pool_capacity","0x38,0,1"}, 
  {"sd_softdevice_disable","0x11,0"}, 
  {"sd_softdevice_enable","0x10,0"}, 
  {"sd_softdevice_is_enabled","0x12,0,1"}, 
  {"sd_softdevice_vector_table_base_set","0x13,0,1"}, 
  {"sd_temp_get","0x52,0,1"}, 
  {NULL, NULL}
};
// 0x55e690a25470
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_s110_arm_16_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_s110_arm_16_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_s110_arm_16(x,y) gperf_s110_arm_16_hash(x)
const unsigned int gperf_s110_arm_16_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_s110_arm_16 = {
  .name = "s110-arm-16",
  .get = &gperf_s110_arm_16_get,
  .hash = &gperf_s110_arm_16_hash,
  .foreach = &gperf_s110_arm_16_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_s110_arm_16.get)("foo");
	printf ("%s\n", s);
}
#endif
