/*!
 * OpenUI5
 * (c) Copyright 2009-2020 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Input','./Tokenizer','./Token','./library','sap/ui/core/EnabledPropagator','sap/ui/base/ManagedObjectMetadata','sap/ui/base/ManagedObjectObserver','sap/ui/Device','./Popover','./List','./Title','./Bar','./Toolbar','./StandardListItem','sap/ui/core/ResizeHandler','sap/ui/core/IconPool','./MultiInputRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes",'sap/ui/core/InvisibleText',"sap/ui/thirdparty/jquery","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/control"],function(I,T,a,l,E,M,b,D,P,L,c,B,d,S,R,f,g,h,K,j,q){"use strict";var k=l.TokenizerRenderMode;var m=I.extend("sap.m.MultiInput",{metadata:{library:"sap.m",designtime:"sap/m/designtime/MultiInput.designtime",properties:{enableMultiLineMode:{type:"boolean",group:"Behavior",defaultValue:false},maxTokens:{type:"int",group:"Behavior"}},aggregations:{tokens:{type:"sap.m.Token",multiple:true,singularName:"token"},tokenizer:{type:"sap.m.Tokenizer",multiple:false,visibility:"hidden"}},events:{tokenChange:{parameters:{type:{type:"string"},token:{type:"sap.m.Token"},tokens:{type:"sap.m.Token[]"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}},tokenUpdate:{allowPreventDefault:true,parameters:{type:{type:"string"},addedTokens:{type:"sap.m.Token[]"},removedTokens:{type:"sap.m.Token[]"}}}},dnd:{draggable:false,droppable:true}}});E.apply(m.prototype,[true]);var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");m.prototype.init=function(){var t=this;this._bShowListWithTokens=false;I.prototype.init.call(this);this._bIsValidating=false;var o=new T({renderMode:k.Narrow});this.setAggregation("tokenizer",o);o.attachTokenChange(this._onTokenChange,this);o.attachTokenUpdate(this._onTokenUpdate,this);this._oTokenizerObserver=new b(this.invalidate.bind(this));this._oTokenizerObserver.observe(o,{aggregations:["tokens"]});o.getTokensPopup().setInitialFocus(this).attachBeforeOpen(this._onBeforeOpenTokensPicker.bind(this));o.addEventDelegate({onThemeChanged:this._handleInnerVisibility.bind(this),onAfterRendering:function(){if(this.isMobileDevice()&&this.getEditable()){o.addStyleClass("sapMTokenizerIndicatorDisabled");}else{o.removeStyleClass("sapMTokenizerIndicatorDisabled");}this._syncInputWidth(o);this._handleInnerVisibility();this._handleNMoreAccessibility();this._registerTokenizerResizeHandler();}.bind(this)},this);this._aTokenValidators=[];this.setShowValueHelp(true);this.setShowSuggestion(true);this._getSuggestionsPopoverInstance()._oPopover.attachBeforeOpen(function(){if(t.isMobileDevice()!==true){return;}var e=o._getTokensList();o._fillTokensList(e);this.addContent(e);t._manageListsVisibility(!!o.getTokens().length);});this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);this._getValueHelpIcon().setProperty("visible",true,true);this._onResize=this._onResize.bind(this);};m.prototype.exit=function(){this._deregisterResizeHandler();this._deregisterTokenizerResizeHandler();this._oTokenizerObserver.disconnect();this._oTokenizerObserver.destroy();this._oTokenizerObserver=null;I.prototype.exit.call(this);};m.prototype.onAfterRendering=function(){var t=this.getAggregation("tokenizer");this._bTokenIsValidated=false;t.setMaxWidth(this._calculateSpaceForTokenizer());t.scrollToEnd();this._registerResizeHandler();I.prototype.onAfterRendering.apply(this,arguments);};m.prototype._handleInnerVisibility=function(){var H=!!this.getAggregation("tokenizer").getHiddenTokensCount();this._setValueVisible(!H);};m.prototype.oninput=function(e){this.setProperty("selectedKey",'',true);I.prototype.oninput.call(this,e);if(e.isMarked("invalid")||!this.getEditable()){return;}this._setValueVisible(true);this._manageListsVisibility(false);this.getAggregation("tokenizer").getTokensPopup().close();};m.prototype._registerResizeHandler=function(){if(!this._iResizeHandlerId){this._iResizeHandlerId=R.register(this,this._onResize);}};m.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};m.prototype._registerTokenizerResizeHandler=function(){if(!this._iTokenizerResizeHandler){this._iTokenizerResizeHandler=R.register(this.getAggregation("tokenizer"),this._onResize);}};m.prototype._deregisterTokenizerResizeHandler=function(){if(this._iTokenizerResizeHandler){R.deregister(this._iTokenizerResizeHandler);this._iTokenizerResizeHandler=null;}};m.prototype._onResize=function(){this.getAggregation("tokenizer").setMaxWidth(this._calculateSpaceForTokenizer());};m.prototype._onTokenChange=function(e){this.fireTokenChange(e.getParameters());this.invalidate();if(e.getParameter("type")==="removed"){this.getAggregation("tokenizer").setRenderMode(k.Loose);}if(this.isMobileDevice()){this._manageListsVisibility(true);}};m.prototype._onTokenUpdate=function(e){var i=this.fireTokenUpdate(e.getParameters());if(!this.getTokens().length){this.$().find("input").trigger("focus");}if(!i){e.preventDefault();}else{this.invalidate();}};m.prototype._onSuggestionItemSelected=function(e){var t=this.getAggregation("tokenizer"),i=null,n=null,o=t.getTokens().length;if(this.getMaxTokens()&&o>=this.getMaxTokens()||this._bValueHelpOpen){return;}if(this._hasTabularSuggestions()){i=e.getParameter("selectedRow");}else{i=e.getParameter("selectedItem");if(i){n=new a({text:i.getText(),key:i.getKey()});}}if(i&&!this._bTokenIsAdded){var p=this.getValue();this.addValidateToken({text:p,token:n,suggestionObject:i,validationCallback:this._validationCallback.bind(this,o)});}if(this.isMobileDevice()){var N=t.getTokens().length;if(o<N){this.setValue("");}if(this._getSuggestionsList()instanceof sap.m.Table){this._getSuggestionsList().addStyleClass("sapMInputSuggestionTableHidden");}else{this._getSuggestionsList().destroyItems();}var s=this.getAggregation("tokenizer").getScrollDelegate();if(s){s.scrollTo(0,0,0);}this._getSuggestionsPopoverInstance()._oPopupInput.focus();}this._bTokenIsAdded=false;};m.prototype._onValueHelpRequested=function(){this._bValueHelpOpen=true;};m.prototype._onLiveChange=function(e){this.getAggregation("tokenizer")._removeSelectedTokens();};m.prototype._setValueVisible=function(v){var V=v?"1":"0";this.$("inner").css("opacity",V);};m.prototype.onmousedown=function(e){if(e.target==this.getDomRef('content')){e.preventDefault();e.stopPropagation();}};m.prototype.openMultiLine=function(){};m.prototype.closeMultiLine=function(){};m.prototype.showItems=function(){I.prototype.showItems.apply(this,arguments);this._manageListsVisibility(false);};m.prototype.onBeforeRendering=function(){I.prototype.onBeforeRendering.apply(this,arguments);this.getAggregation("tokenizer").setEnabled(this.getEnabled());};m.prototype.onsapnext=function(e){var t=this.getAggregation("tokenizer");if(e.isMarked()){return;}var F=q(document.activeElement).control()[0];if(!F){return;}if(t===F||t.$().find(F.$()).length>0){t.scrollToEnd();this.$().find("input").trigger("focus");}};m.prototype.onsapbackspace=function(e){if(this._$input.cursorPos()>0||!this.getEditable()||this.getValue().length>0){return;}if(!e.isMarked()){T.prototype.onsapbackspace.apply(this.getAggregation("tokenizer"),arguments);}if(e.isMarked("forwardFocusToParent")){this.focus();}e.preventDefault();e.stopPropagation();};m.prototype.onsapdelete=function(e){if(!this.getEditable()){return;}if(this.getValue()&&!this._completeTextIsSelected()){return;}if(e.isMarked("forwardFocusToParent")){this.focus();}};m.prototype.onkeydown=function(e){var t=this.getAggregation("tokenizer");if(!this.getEnabled()){return;}if(e.which===K.TAB){t.selectAllTokens(false);}if((e.ctrlKey||e.metaKey)&&e.which===K.A&&t.getTokens().length>0){t.focus();t.selectAllTokens(true);e.preventDefault();}if((e.ctrlKey||e.metaKey)&&e.which===K.I&&t.getTokens().length){t._togglePopup(t.getTokensPopup());e.preventDefault();}};m.prototype.onpaste=function(e){var o,i,s,A=[];if(this.getValueHelpOnly()){return;}if(window.clipboardData){o=window.clipboardData.getData("Text");}else{o=e.originalEvent.clipboardData.getData('text/plain');}s=o.split(/\r\n|\r|\n/g);if(s.length<=1){return;}setTimeout(function(){if(s){if(this.fireEvent("_validateOnPaste",{texts:s},true)){var n="";for(i=0;i<s.length;i++){if(s[i]){var t=this._convertTextToToken(s[i],true);if(this._addUniqueToken(t)){A.push(t);}else{n=s[i];}}}this.updateDomValue(n);if(A.length>0){this.fireTokenUpdate({addedTokens:A,removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:A,removedTokens:[],type:T.TokenChangeType.TokensChanged});}}if(A.length){this.cancelPendingSuggest();}}}.bind(this),0);};m.prototype._validationCallback=function(o,v){var n=this.getAggregation("tokenizer").getTokens().length;var s=this._getSuggestionsPopoverInstance();this._bIsValidating=false;if(v){this.setValue("");this._bTokenIsValidated=true;if(this.isMobileDevice()&&s&&s._oPopupInput&&(o<n)){s._oPopupInput.setValue("");}}};m.prototype.onsapprevious=function(e){if(this._getIsSuggestionPopupOpen()){return;}if(this._$input.cursorPos()===0){if(e.srcControl===this){T.prototype.onsapprevious.apply(this.getAggregation("tokenizer"),arguments);}}if(e.keyCode===K.ARROW_UP){e.preventDefault();}};m.prototype.onsaphome=function(e){if(!this.getFocusDomRef().selectionStart){T.prototype.onsaphome.apply(this.getAggregation("tokenizer"),arguments);}};m.prototype.onsapend=function(e){if(e.isMarked("forwardFocusToParent")){this.focus();}};m.prototype.onsapenter=function(e){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}var v=true,t=this.getAggregation("tokenizer");if(this._getIsSuggestionPopupOpen()){if(this._hasTabularSuggestions()){v=!this._oSuggestionTable.getSelectedItem();}else{v=!this._getSuggestionsList().getSelectedItem();}}if(v){this._validateCurrentText();}if(e&&e.setMarked&&this._bTokenIsValidated){e.setMarked();}if(!this.getEditable()&&t.getHiddenTokensCount()&&e.target===this.getFocusDomRef()){t._togglePopup(t.getTokensPopup());}this.focus();};m.prototype.onsapfocusleave=function(e){var p=this._getSuggestionsPopoverPopup(),t=this.getAggregation("tokenizer"),s=t.getTokensPopup(),n=false,N=false,i=this.getDomRef()&&h(this.getDomRef(),document.activeElement),o,F;if(p&&p.isA("sap.m.Popover")){if(e.relatedControlId){o=sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef();n=h(p.getFocusDomRef(),o);N=h(t.getFocusDomRef(),o);if(s){F=h(s.getFocusDomRef(),o);}}}I.prototype.onsapfocusleave.apply(this,arguments);if(this._bIsValidating||this._bValueHelpOpen){return;}if(!this.isMobileDevice()&&!n&&e.relatedControlId!==this.getId()&&!N){this._validateCurrentText(true);}if(!this.isMobileDevice()&&this.getEditable()){if(i||n){return;}}if(!F&&!N){s.isOpen()&&!this.isMobileDevice()&&t._togglePopup(s);t.setRenderMode(k.Narrow);}this._handleInnerVisibility();};m.prototype.ontap=function(e){var t=this.getAggregation("tokenizer");if(document.activeElement===this._$input[0]||document.activeElement===t.getDomRef()){t.selectAllTokens(false);}if(e&&e.isMarked("tokenDeletePress")){return;}I.prototype.ontap.apply(this,arguments);};m.prototype.onfocusin=function(e){var t=this.getAggregation("tokenizer");this._deregisterTokenizerResizeHandler();this._bValueHelpOpen=false;if(e.target===this.getFocusDomRef()){I.prototype.onfocusin.apply(this,arguments);if(t.hasOneTruncatedToken()){t.getTokens()[0].setSelected(false);!this.isMobileDevice()&&t.setFirstTokenTruncated(false);}}if(!this.isMobileDevice()&&this.getEditable()&&e.target===this.getDomRef("inner")&&!(this._getIsSuggestionPopupOpen())){t.setRenderMode(k.Loose);this._setValueVisible(true);}this._registerResizeHandler();};m.prototype.onsapescape=function(e){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup();this.getAggregation("tokenizer").selectAllTokens(false);this.selectText(0,0);if(p.isOpen()){t._togglePopup(p);}I.prototype.onsapescape.apply(this,arguments);};m.prototype._completeTextIsSelected=function(){var i=this._$input[0];if(i.selectionStart!==0){return false;}if(i.selectionEnd!==this.getValue().length){return false;}return true;};m.prototype._getIsSuggestionPopupOpen=function(){var s=this._getSuggestionsPopoverInstance(),o=this._getSuggestionsPopoverPopup();return s&&o&&o.isOpen();};m.prototype.setEditable=function(e){var t=this.getAggregation("tokenizer");e=this.validateProperty("editable",e);if(e===this.getEditable()){return this;}if(I.prototype.setEditable){I.prototype.setEditable.apply(this,arguments);}t.setEditable(e);return this;};m.prototype._findItem=function(t,e,n,G){if(!t){return;}if(!(e&&e.length)){return;}t=t.toLowerCase();var o=e.length;for(var i=0;i<o;i++){var p=e[i];var s=G(p);if(!s){continue;}s=s.toLowerCase();if(s===t){return p;}if(!n&&s.indexOf(t)===0){return p;}}};m.prototype._getSuggestionItem=function(t,e){var n=null;var o=null;if(this._hasTabularSuggestions()){n=this.getSuggestionRows();o=this._findItem(t,n,e,function(p){var s=p.getCells();var u=null;if(s){var i;for(i=0;i<s.length;i++){if(s[i].getText){u=s[i].getText();break;}}}return u;});}else{n=this.getSuggestionItems();o=this._findItem(t,n,e,function(o){return o.getText();});}return o;};m.prototype.clone=function(){var C,t=this.getAggregation("tokenizer");this.detachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.detachLiveChange(this._onLiveChange,this);t.detachTokenChange(this._onTokenChange,this);t.detachTokenUpdate(this._onTokenUpdate,this);this.detachValueHelpRequest(this._onValueHelpRequested,this);C=I.prototype.clone.apply(this,arguments);this.attachSuggestionItemSelected(this._onSuggestionItemSelected,this);this.attachLiveChange(this._onLiveChange,this);t.attachTokenChange(this._onTokenChange,this);t.attachTokenUpdate(this._onTokenUpdate,this);this.attachValueHelpRequest(this._onValueHelpRequested,this);return C;};m.getMetadata().forwardAggregation("tokens",{getter:function(){return this.getAggregation("tokenizer");},aggregation:"tokens",forwardBinding:true});m.prototype.getPopupAnchorDomRef=function(){return this.getDomRef("content");};m.prototype.setTokens=function(t){var v,V=[],i;if(Array.isArray(t)){for(i=0;i<t.length;i++){v=this.validateAggregation("tokens",t[i],true);M.addAPIParentInfoBegin(t[i],this,"tokens");V.push(v);}this.getAggregation("tokenizer").setTokens(V);for(i=0;i<t.length;i++){M.addAPIParentInfoEnd(t[i]);}}else{throw new Error("\""+t+"\" is of type "+typeof t+", expected array for aggregation tokens of "+this);}return this;};m.TokenChangeType={Added:"added",Removed:"removed",RemovedAll:"removedAll",TokensChanged:"tokensChanged"};m.WaitForAsyncValidation="sap.m.MultiInput.WaitForAsyncValidation";m.prototype.getDomRefForValueStateMessage=m.prototype.getPopupAnchorDomRef;m.prototype.updateInputField=function(n){I.prototype.updateInputField.call(this,n);var s=this._getSuggestionsPopoverInstance();this.setDOMValue('');if(s._oPopupInput){s._oPopupInput.setDOMValue('');}};m.prototype.onChange=function(e,p,n){p=p||this.getChangeEventParams();if(!this.getEditable()||!this.getEnabled()){return;}var v=this._getInputValue(n);if(v===this.getLastValue()){this._bCheckDomValue=false;return;}if(!this._bTokenIsValidated){this.setValue(v);v=this.getValue();this.setLastValue(v);}this.fireChangeEvent(v,p);return true;};m.prototype.getAccessibilityInfo=function(){var t=this.getTokens().map(function(o){return o.getText();}).join(" ");var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.type=r.getText("ACC_CTR_TYPE_MULTIINPUT");i.description=((i.description||"")+" "+t).trim();return i;};m.prototype._modifyPopupInput=function(p){var t=this;p.addEventDelegate({oninput:t._manageListsVisibility.bind(t,false),onsapenter:function(e){if(p.getValue()){t._closeSuggestionPopup();}t._validateCurrentText();t._setValueVisible(false);t.onChange(e,null,p.getValue());}});return p;};m.prototype._hasShowSelectedButton=function(){return true;};m.prototype.forwardEventHandlersToSuggPopover=function(s){I.prototype.forwardEventHandlersToSuggPopover.apply(this,arguments);s.setShowSelectedPressHandler(this._handleShowSelectedPress.bind(this));};m.prototype._handleShowSelectedPress=function(e){this._bShowListWithTokens=e.getSource().getPressed();this._manageListsVisibility(this._bShowListWithTokens);};m.prototype._onBeforeOpenTokensPicker=function(){var t=this.getAggregation("tokenizer"),p=t.getTokensPopup(),o=this.getDomRef(),e=this.getEditable(),w;this._setValueVisible(false);this._manageListsVisibility(true);if(o&&p){w=(t.getTokens().length===1)?"auto":(o.offsetWidth/parseFloat(l.BaseFontSize))+"rem";p.setContentWidth(e?w:"auto");}};m.prototype.getDialogTitle=function(){var p=this._getSuggestionsPopoverPopup(),H=p&&p.getCustomHeader();if(H){return H.getContentMiddle()[0];}return null;};m.prototype._updatePickerHeaderTitle=function(){var o,e;e=this.getLabels();if(e.length){o=e[0];if(o&&(typeof o.getText==="function")){this.getDialogTitle().setText(o.getText());}}else{this.getDialogTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};m.prototype._getSuggestionsList=function(){var s=this._getSuggestionsPopoverInstance();return s&&s._oList;};m.prototype._getSuggestionsPopoverInstance=function(){return this._oSuggPopover;};m.prototype._getSuggestionsPopoverPopup=function(){return this._oSuggestionPopup;};m.prototype._manageListsVisibility=function(s){if(!this.isMobileDevice()){return;}this.getAggregation("tokenizer")._getTokensList().setVisible(s);this._getSuggestionsList()&&this._getSuggestionsList().setVisible(!s);this._getSuggestionsPopover().getFilterSelectedButton().setPressed(s);};m.prototype._handleNMoreAccessibility=function(){var i=j.getStaticId("sap.m","MULTICOMBOBOX_OPEN_NMORE_POPOVER"),F=this.getFocusDomRef(),A=(F&&F.getAttribute("aria-labelledby")),e=A?A.split(" "):[],n=e.indexOf(i),o=this.getEnabled(),N=!this.getEditable()&&this.getAggregation("tokenizer").getHiddenTokensCount();if(N&&n===-1){e.push(i);o&&this.getFocusDomRef().setAttribute("aria-keyshortcuts","Enter");}else if(n!==-1&&!N){e.splice(n,1);this.getFocusDomRef().removeAttribute("aria-keyshortcuts");}if(F&&e.length){F.setAttribute("aria-labelledby",e.join(" ").trim());}};m.prototype._calculateSpaceForTokenizer=function(){var o=this.getDomRef();if(o){var s,e=this.$().find(".sapMInputDescriptionWrapper"),i=this.$().find(".sapMInputBaseInner"),C=o.offsetWidth||0,n=e.width()||0,p=this._calculateIconsSpace(),t=["min-width","padding-right","padding-left"],u=t.reduce(function(A,v){return A+(parseInt(i.css(v))||0);},0);s=C-(p+u+n);s=s<0?0:s;return s+"px";}else{return null;}};m.prototype._syncInputWidth=function(t){var F=this.getDomRef('inner'),s,i;if(!F||(t&&!t.getDomRef())){return;}s=this._calculateIconsSpace();i=Math.ceil(t.getDomRef().getBoundingClientRect().width);F.style.width='calc(100% - '+Math.floor(s+i)+"px";};m.prototype.isValueHelpOnlyOpener=function(t){return[this._$input[0],this._getValueHelpIcon().getDomRef()].indexOf(t)>-1;};m.prototype._shouldTriggerSuggest=function(){var s=I.prototype._shouldTriggerSuggest.apply(this,arguments);return s&&!this._bShowListWithTokens;};m.prototype.addValidator=function(v){if(typeof(v)==="function"){this._aTokenValidators.push(v);}};m.prototype.removeValidator=function(v){var i=this._aTokenValidators.indexOf(v);if(i!==-1){this._aTokenValidators.splice(i,1);}};m.prototype.removeAllValidators=function(){this._aTokenValidators=[];};m.prototype.getValidators=function(){return this._aTokenValidators;};m.prototype.addValidateToken=function(p,v){var t=this._validateToken(p,v),A=this._addUniqueToken(t,p.validationCallback);if(A){this.fireTokenUpdate({addedTokens:[t],removedTokens:[],type:T.TokenUpdateType.Added});this.fireTokenChange({addedTokens:[t],removedTokens:[],type:T.TokenChangeType.TokensChanged});}};m.prototype._validateToken=function(p,v){var t=p.token,V=p.validationCallback,s=p.suggestionObject,e=t&&t.getText(),n=e?e:p.text,o;v=v?v:this._aTokenValidators;o=v.length;if(!o){if(!t&&V){V(false);}return t;}for(var i=0;i<o;i++){t=v[i]({text:n,suggestedToken:t,suggestionObject:s,asyncCallback:this._getAsyncValidationCallback(v,i,n,s,V)});if(!t){if(V){V(false);}return null;}if(t===m.WaitForAsyncValidation){return null;}}return t;};m.prototype._addUniqueToken=function(t,v){if(!t){return false;}var e=!this._tokenExists(t);e&&this.addToken(t);if(v){v(e);}return e;};m.prototype._tokenExists=function(t){var o=this.getTokens(),e=o.length,s=t&&t.getKey();if(!s){return false;}for(var i=0;i<e;i++){if(o[i].getKey()===s){return true;}}return false;};m.prototype._convertTextToToken=function(t,C){var o=this.getAggregation("tokenizer"),O=o.getTokens().length,e=this._configureTokenOptions(t,false,C),v=e.text,i=e.item,n=e.token;if(!v){return null;}return this._validateToken({text:v,token:n,suggestionObject:i,validationCallback:this._validationCallback.bind(this,O)});};m.prototype._validateCurrentText=function(e){var t=this.getAggregation("tokenizer"),o=t.getTokens().length,O=this._configureTokenOptions(this.getValue(),e),v=O.text,i=O.item,n=O.token;if(!v){return null;}if(i){this._bTokenIsAdded=true;}if(!this.getMaxTokens()||this.getTokens().length<this.getMaxTokens()){this._bIsValidating=true;this.addValidateToken({text:v,token:n,suggestionObject:i,validationCallback:this._validationCallback.bind(this,o)});}};m.prototype._configureTokenOptions=function(v,e,p){var i,t;if(v&&this.getEditable()){v=v.trim();}if(v&&(e||p||this._getIsSuggestionPopupOpen())){if(this._hasTabularSuggestions()){i=this._oSuggestionTable.getSelectedItem();}else{i=this._getSuggestionItem(v,e);}}if(i&&i.getText&&i.getKey){t=new a({text:i.getText(),key:i.getKey()});}return{text:v,item:i,token:t};};m.prototype._getAsyncValidationCallback=function(v,V,i,s,e){var t=this;return function(o){if(o){o=t.addValidateToken({text:i,token:o,suggestionObject:s,validationCallback:e},v.slice(V+1));}else{e&&e(false);}};};return m;});
